
package org.apache.activemq.schema.core;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.activemq.plugin.jaxb2_commons.ElementAwareEqualsStrategy;
import org.jvnet.jaxb.lang.Equals;
import org.jvnet.jaxb.lang.EqualsStrategy;
import org.jvnet.jaxb.lang.HashCode;
import org.jvnet.jaxb.lang.HashCodeStrategy;
import org.jvnet.jaxb.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Classe Java pour anonymous complex type.
 * 
 * <p>Le fragment de schéma suivant indique le contenu attendu figurant dans cette classe.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;attribute name="rateDuration" type="{http://www.w3.org/2001/XMLSchema}integer" /&gt;
 *       &lt;attribute name="rateLimit" type="{http://www.w3.org/2001/XMLSchema}integer" /&gt;
 *       &lt;attribute name="replayDelay" type="{http://www.w3.org/2001/XMLSchema}integer" /&gt;
 *       &lt;attribute name="replayWhenNoConsumers" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="selectorAware" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}ID" /&gt;
 *       &lt;anyAttribute processContents='lax' namespace='##other'/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "conditionalNetworkBridgeFilterFactory")
public class DtoConditionalNetworkBridgeFilterFactory implements Equals, HashCode, ToString
{

    @XmlAttribute(name = "rateDuration")
    protected BigInteger rateDuration;
    @XmlAttribute(name = "rateLimit")
    protected BigInteger rateLimit;
    @XmlAttribute(name = "replayDelay")
    protected BigInteger replayDelay;
    @XmlAttribute(name = "replayWhenNoConsumers")
    protected Boolean replayWhenNoConsumers;
    @XmlAttribute(name = "selectorAware")
    protected Boolean selectorAware;
    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    protected String id;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    /**
     * Obtient la valeur de la propriété rateDuration.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getRateDuration() {
        return rateDuration;
    }

    /**
     * Définit la valeur de la propriété rateDuration.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setRateDuration(BigInteger value) {
        this.rateDuration = value;
    }

    /**
     * Obtient la valeur de la propriété rateLimit.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getRateLimit() {
        return rateLimit;
    }

    /**
     * Définit la valeur de la propriété rateLimit.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setRateLimit(BigInteger value) {
        this.rateLimit = value;
    }

    /**
     * Obtient la valeur de la propriété replayDelay.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getReplayDelay() {
        return replayDelay;
    }

    /**
     * Définit la valeur de la propriété replayDelay.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setReplayDelay(BigInteger value) {
        this.replayDelay = value;
    }

    /**
     * Obtient la valeur de la propriété replayWhenNoConsumers.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isReplayWhenNoConsumers() {
        return replayWhenNoConsumers;
    }

    /**
     * Définit la valeur de la propriété replayWhenNoConsumers.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setReplayWhenNoConsumers(Boolean value) {
        this.replayWhenNoConsumers = value;
    }

    /**
     * Obtient la valeur de la propriété selectorAware.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isSelectorAware() {
        return selectorAware;
    }

    /**
     * Définit la valeur de la propriété selectorAware.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setSelectorAware(Boolean value) {
        this.selectorAware = value;
    }

    /**
     * Obtient la valeur de la propriété id.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Définit la valeur de la propriété id.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            BigInteger theRateDuration;
            theRateDuration = this.getRateDuration();
            strategy.appendField(locator, this, "rateDuration", buffer, theRateDuration, (this.rateDuration!= null));
        }
        {
            BigInteger theRateLimit;
            theRateLimit = this.getRateLimit();
            strategy.appendField(locator, this, "rateLimit", buffer, theRateLimit, (this.rateLimit!= null));
        }
        {
            BigInteger theReplayDelay;
            theReplayDelay = this.getReplayDelay();
            strategy.appendField(locator, this, "replayDelay", buffer, theReplayDelay, (this.replayDelay!= null));
        }
        {
            Boolean theReplayWhenNoConsumers;
            theReplayWhenNoConsumers = this.isReplayWhenNoConsumers();
            strategy.appendField(locator, this, "replayWhenNoConsumers", buffer, theReplayWhenNoConsumers, (this.replayWhenNoConsumers!= null));
        }
        {
            Boolean theSelectorAware;
            theSelectorAware = this.isSelectorAware();
            strategy.appendField(locator, this, "selectorAware", buffer, theSelectorAware, (this.selectorAware!= null));
        }
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId, (this.id!= null));
        }
        return buffer;
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            BigInteger theRateDuration;
            theRateDuration = this.getRateDuration();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "rateDuration", theRateDuration), currentHashCode, theRateDuration, (this.rateDuration!= null));
        }
        {
            BigInteger theRateLimit;
            theRateLimit = this.getRateLimit();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "rateLimit", theRateLimit), currentHashCode, theRateLimit, (this.rateLimit!= null));
        }
        {
            BigInteger theReplayDelay;
            theReplayDelay = this.getReplayDelay();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "replayDelay", theReplayDelay), currentHashCode, theReplayDelay, (this.replayDelay!= null));
        }
        {
            Boolean theReplayWhenNoConsumers;
            theReplayWhenNoConsumers = this.isReplayWhenNoConsumers();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "replayWhenNoConsumers", theReplayWhenNoConsumers), currentHashCode, theReplayWhenNoConsumers, (this.replayWhenNoConsumers!= null));
        }
        {
            Boolean theSelectorAware;
            theSelectorAware = this.isSelectorAware();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "selectorAware", theSelectorAware), currentHashCode, theSelectorAware, (this.selectorAware!= null));
        }
        {
            String theId;
            theId = this.getId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "id", theId), currentHashCode, theId, (this.id!= null));
        }
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, strategy);
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final DtoConditionalNetworkBridgeFilterFactory that = ((DtoConditionalNetworkBridgeFilterFactory) object);
        {
            BigInteger lhsRateDuration;
            lhsRateDuration = this.getRateDuration();
            BigInteger rhsRateDuration;
            rhsRateDuration = that.getRateDuration();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "rateDuration", lhsRateDuration), LocatorUtils.property(thatLocator, "rateDuration", rhsRateDuration), lhsRateDuration, rhsRateDuration, (this.rateDuration!= null), (that.rateDuration!= null))) {
                return false;
            }
        }
        {
            BigInteger lhsRateLimit;
            lhsRateLimit = this.getRateLimit();
            BigInteger rhsRateLimit;
            rhsRateLimit = that.getRateLimit();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "rateLimit", lhsRateLimit), LocatorUtils.property(thatLocator, "rateLimit", rhsRateLimit), lhsRateLimit, rhsRateLimit, (this.rateLimit!= null), (that.rateLimit!= null))) {
                return false;
            }
        }
        {
            BigInteger lhsReplayDelay;
            lhsReplayDelay = this.getReplayDelay();
            BigInteger rhsReplayDelay;
            rhsReplayDelay = that.getReplayDelay();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "replayDelay", lhsReplayDelay), LocatorUtils.property(thatLocator, "replayDelay", rhsReplayDelay), lhsReplayDelay, rhsReplayDelay, (this.replayDelay!= null), (that.replayDelay!= null))) {
                return false;
            }
        }
        {
            Boolean lhsReplayWhenNoConsumers;
            lhsReplayWhenNoConsumers = this.isReplayWhenNoConsumers();
            Boolean rhsReplayWhenNoConsumers;
            rhsReplayWhenNoConsumers = that.isReplayWhenNoConsumers();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "replayWhenNoConsumers", lhsReplayWhenNoConsumers), LocatorUtils.property(thatLocator, "replayWhenNoConsumers", rhsReplayWhenNoConsumers), lhsReplayWhenNoConsumers, rhsReplayWhenNoConsumers, (this.replayWhenNoConsumers!= null), (that.replayWhenNoConsumers!= null))) {
                return false;
            }
        }
        {
            Boolean lhsSelectorAware;
            lhsSelectorAware = this.isSelectorAware();
            Boolean rhsSelectorAware;
            rhsSelectorAware = that.isSelectorAware();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "selectorAware", lhsSelectorAware), LocatorUtils.property(thatLocator, "selectorAware", rhsSelectorAware), lhsSelectorAware, rhsSelectorAware, (this.selectorAware!= null), (that.selectorAware!= null))) {
                return false;
            }
        }
        {
            String lhsId;
            lhsId = this.getId();
            String rhsId;
            rhsId = that.getId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "id", lhsId), LocatorUtils.property(thatLocator, "id", rhsId), lhsId, rhsId, (this.id!= null), (that.id!= null))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        final EqualsStrategy strategy = new ElementAwareEqualsStrategy();
        return equals(null, null, object, strategy);
    }

}
