/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.url;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.linkedin.util.lang.LangUtils;
import org.linkedin.util.text.StringSplitter;
import org.linkedin.util.text.TextUtils;
import org.linkedin.util.url.Query;
import org.linkedin.util.url.URLCodec;

public class QueryBuilder
implements Query,
Serializable {
    private static final long serialVersionUID = 1L;
    private static StringSplitter SS = new StringSplitter('&');
    private Map<String, String[]> _queryParameters = null;
    private final StringBuilder _query = new StringBuilder();
    private final URLCodec _urlCodec;

    public QueryBuilder() {
        this._urlCodec = URLCodec.instance();
    }

    public QueryBuilder(String encoding) throws UnsupportedEncodingException {
        this._urlCodec = new URLCodec(true, encoding);
    }

    public QueryBuilder(URLCodec urlCodec) {
        this._urlCodec = urlCodec;
    }

    @Override
    public String getEncoding() {
        return this._urlCodec.getCharacterEncoding();
    }

    @Override
    public boolean getHasQueryParameters() {
        return this._query.length() > 0;
    }

    @Override
    public Iterator<String> getParameterNames() {
        return this.getParameterMap().keySet().iterator();
    }

    @Override
    public String getQuery() {
        return this._query.toString();
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.getMap().get(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.getMap());
    }

    @Override
    public String getParameter(String name) {
        String[] params = this.getParameterValues(name);
        if (params == null) {
            return null;
        }
        return params[0];
    }

    @Override
    public boolean getBooleanParameter(String name) {
        String paramValue = this.getParameter(name);
        if (!TextUtils.isEmptyString(paramValue) && paramValue.equals(name)) {
            return true;
        }
        return LangUtils.convertToBoolean(paramValue);
    }

    @Override
    public int getIntParameter(String name, int defaultValue) {
        String paramValue = this.getParameter(name);
        if (TextUtils.isEmptyString(paramValue)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(paramValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void addParameter(String name) {
        this.addParameter(name, "");
    }

    private void addQueryParameter(String name, String value) {
        if (this._query.length() > 0) {
            this._query.append('&');
        }
        this._query.append(this.encode(name));
        this._query.append('=');
        this._query.append(this.encode(value));
    }

    public void addParameter(String name, String value) {
        this.addQueryParameter(name, value);
        if (this._queryParameters != null) {
            this.addParameterToMap(name, value);
        }
    }

    private void addParameterToMap(String name, String value) {
        String[] params = this.getParameterValues(name);
        if (params == null) {
            params = new String[]{value};
            this._queryParameters.put(name, params);
        } else {
            int len = params.length;
            String[] newParams = new String[len + 1];
            System.arraycopy(params, 0, newParams, 0, len);
            newParams[len] = value;
            this._queryParameters.put(name, newParams);
        }
    }

    public void addParameters(String name, String[] values) {
        if (this._query.length() > 0) {
            this._query.append('&');
        }
        String encodedName = this.encode(name);
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                this._query.append('&');
            }
            this._query.append(encodedName);
            this._query.append('=');
            this._query.append(this.encode(values[i]));
        }
        if (this._queryParameters != null) {
            this.addParametersToMap(name, values);
        }
    }

    public void addParameters(Map<String, String[]> parameters) {
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            this.addParameters(entry.getKey(), entry.getValue());
        }
    }

    private void addParametersToMap(String name, String[] values) {
        String[] params = this.getParameterValues(name);
        if (params == null) {
            this._queryParameters.put(name, values);
        } else {
            int len = params.length;
            String[] newParams = new String[len + values.length];
            System.arraycopy(params, 0, newParams, 0, len);
            System.arraycopy(values, 0, newParams, len, values.length);
            this._queryParameters.put(name, newParams);
        }
    }

    public void addParameter(String name, int value) {
        this.addParameter(name, String.valueOf(value));
    }

    public void addParameter(String name, long value) {
        this.addParameter(name, String.valueOf(value));
    }

    public void addIndexedParameter(String name, String value, int index) {
        this.addParameter(QueryBuilder.getIndexedParamName(name, index), value);
    }

    public void addIndexedParameter(String name, String value, int ... indices) {
        this.addParameter(QueryBuilder.getIndexedParamName(name, indices), value);
    }

    public void addIndexedParameter(String name, int value, int index) {
        this.addParameter(QueryBuilder.getIndexedParamName(name, index), value);
    }

    public void addIndexedParameter(String name, int value, int ... indices) {
        this.addParameter(QueryBuilder.getIndexedParamName(name, indices), value);
    }

    public void addBooleanParameter(String name, boolean value) {
        if (value) {
            this.addParameter(name, name);
        }
    }

    public void addQuery(String query) throws URISyntaxException {
        this.addQuery(query, true);
    }

    public void addQuery(URI uri) {
        try {
            this.addQuery(uri.getRawQuery(), false);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void addQuery(String query, boolean validate) throws URISyntaxException {
        if (query == null) {
            return;
        }
        if ("".equals(query)) {
            return;
        }
        if (validate) {
            this.validateQuery(query);
        }
        if (this._query.length() > 0) {
            this._query.append('&');
        }
        this._query.append(query);
        if (this._queryParameters != null) {
            this.addQueryToMap(query);
        }
    }

    private void validateQuery(String query) throws URISyntaxException {
        if (query.length() == 0) {
            return;
        }
        Iterator<String> iter = SS.splitToIterator(query);
        while (iter.hasNext()) {
            String s = iter.next();
            if (s.length() <= 0) continue;
            int idx = s.indexOf(61);
            if (idx == -1) {
                throw new URISyntaxException(query, "missing equal sign in " + s);
            }
            if (s.lastIndexOf(61) == idx) continue;
            throw new URISyntaxException(query, "extra equal sign in " + s);
        }
    }

    private void addQueryToMap(String query) {
        String[] params = SS.split(query);
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            if (param.length() == 0) continue;
            int idx = param.indexOf(61);
            if (idx == -1) {
                this.addParameterToMap(this.decode(param), null);
                continue;
            }
            this.addParameterToMap(this.decode(param.substring(0, idx)), this.decode(param.substring(idx + 1)));
        }
    }

    public void addQuery(Query query) {
        if (query == null) {
            return;
        }
        try {
            if (!query.getEncoding().equals(this.getEncoding())) {
                throw new RuntimeException("TODO");
            }
            this.addQuery(query.getQuery(), false);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this._query.setLength(0);
        this._queryParameters = null;
    }

    public String toString() {
        return this.getQuery();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryBuilder that = (QueryBuilder)o;
        if (!this._urlCodec.equals(that._urlCodec)) {
            return false;
        }
        return this._query.toString().equals(that._query.toString());
    }

    public int hashCode() {
        int result = this._query.hashCode();
        result = 29 * result + this._urlCodec.hashCode();
        return result;
    }

    private Map<String, String[]> getMap() {
        if (this._queryParameters != null) {
            return this._queryParameters;
        }
        this._queryParameters = new LinkedHashMap<String, String[]>();
        this.addQueryToMap(this._query.toString());
        return this._queryParameters;
    }

    public QueryBuilder deepClone() {
        QueryBuilder query = new QueryBuilder(this._urlCodec);
        query.addQuery(this);
        return query;
    }

    private String encode(String s) {
        return this._urlCodec.urlEncode(s);
    }

    private String decode(String s) {
        return this._urlCodec.urlDecode(s);
    }

    public static String getIndexedParamName(String paramPrefix, int index) {
        StringBuilder sb = new StringBuilder(paramPrefix);
        sb.append('_').append(index);
        return sb.toString();
    }

    public static String getIndexedParamName(String paramPrefix, int ... indices) {
        StringBuilder sb = new StringBuilder(paramPrefix);
        for (int index : indices) {
            sb.append('_').append(index);
        }
        return sb.toString();
    }

    private void rebuildQuery() {
        Map<String, String[]> map2 = this.getMap();
        this._query.setLength(0);
        for (String key : map2.keySet()) {
            String[] parameters;
            for (String param : parameters = map2.get(key)) {
                this.addQueryParameter(key, param);
            }
        }
    }

    public void removeParameters(String ... parameterNames) {
        Map<String, String[]> map2 = this.getMap();
        boolean needsRebuild = false;
        for (String name : parameterNames) {
            if (map2.remove(name) == null) continue;
            needsRebuild = true;
        }
        if (needsRebuild) {
            this.rebuildQuery();
        }
    }

    public String[] removeParameter(String name) {
        Map<String, String[]> map2 = this.getMap();
        String[] v = map2.remove(name);
        if (v != null) {
            this.rebuildQuery();
        }
        return v;
    }

    public String[] replaceParameter(String name, String value) {
        Map<String, String[]> map2 = this.getMap();
        String[] v = map2.put(name, new String[]{value});
        this.rebuildQuery();
        return v;
    }
}

