/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import org.iq80.leveldb.impl.SequenceNumber;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;

public class InternalKey {
    private final Slice userKey;
    private final long sequenceNumber;
    private final ValueType valueType;
    private int hash;

    public InternalKey(Slice userKey, long sequenceNumber, ValueType valueType) {
        Preconditions.checkNotNull(userKey, "userKey is null");
        Preconditions.checkArgument(sequenceNumber >= 0L, "sequenceNumber is negative");
        Preconditions.checkNotNull(valueType, "valueType is null");
        this.userKey = userKey;
        this.sequenceNumber = sequenceNumber;
        this.valueType = valueType;
    }

    public InternalKey(Slice data) {
        Preconditions.checkNotNull(data, "data is null");
        Preconditions.checkArgument(data.length() >= 8, "data must be at least %s bytes", new Object[]{(byte)8});
        this.userKey = InternalKey.getUserKey(data);
        long packedSequenceAndType = data.getLong(data.length() - 8);
        this.sequenceNumber = SequenceNumber.unpackSequenceNumber(packedSequenceAndType);
        this.valueType = SequenceNumber.unpackValueType(packedSequenceAndType);
    }

    public InternalKey(byte[] data) {
        this(Slices.wrappedBuffer(data));
    }

    public Slice getUserKey() {
        return this.userKey;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Slice encode() {
        Slice slice = Slices.allocate(this.userKey.length() + 8);
        SliceOutput sliceOutput = slice.output();
        sliceOutput.writeBytes(this.userKey);
        sliceOutput.writeLong(SequenceNumber.packSequenceAndValueType(this.sequenceNumber, this.valueType));
        return slice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalKey that = (InternalKey)o;
        if (this.sequenceNumber != that.sequenceNumber) {
            return false;
        }
        if (this.userKey != null ? !this.userKey.equals(that.userKey) : that.userKey != null) {
            return false;
        }
        return this.valueType == that.valueType;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int result = this.userKey != null ? this.userKey.hashCode() : 0;
            result = 31 * result + (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
            if ((result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0)) == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InternalKey");
        sb.append("{key=").append(this.getUserKey().toString(Charsets.UTF_8));
        sb.append(", sequenceNumber=").append(this.getSequenceNumber());
        sb.append(", valueType=").append((Object)this.getValueType());
        sb.append('}');
        return sb.toString();
    }

    private static Slice getUserKey(Slice data) {
        return data.slice(0, data.length() - 8);
    }
}

