/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.Version;
import org.iq80.leveldb.impl.VersionEdit;
import org.iq80.leveldb.impl.VersionSet;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.Slice;

public class Compaction {
    private final Version inputVersion;
    private final int level;
    private final List<FileMetaData> levelInputs;
    private final List<FileMetaData> levelUpInputs;
    private final List<FileMetaData> grandparents;
    private final List<FileMetaData>[] inputs;
    private final long maxOutputFileSize;
    private final VersionEdit edit = new VersionEdit();
    private int grandparentIndex;
    private boolean seenKey;
    private long overlappedBytes;
    private final int[] levelPointers = new int[7];

    public Compaction(Version inputVersion, int level, List<FileMetaData> levelInputs, List<FileMetaData> levelUpInputs, List<FileMetaData> grandparents) {
        this.inputVersion = inputVersion;
        this.level = level;
        this.levelInputs = levelInputs;
        this.levelUpInputs = levelUpInputs;
        this.grandparents = grandparents;
        this.maxOutputFileSize = VersionSet.maxFileSizeForLevel(level);
        this.inputs = new List[]{levelInputs, levelUpInputs};
    }

    public int getLevel() {
        return this.level;
    }

    public List<FileMetaData> getLevelInputs() {
        return this.levelInputs;
    }

    public List<FileMetaData> getLevelUpInputs() {
        return this.levelUpInputs;
    }

    public VersionEdit getEdit() {
        return this.edit;
    }

    public FileMetaData input(int which, int i) {
        Preconditions.checkArgument(which == 0 || which == 1, "which must be either 0 or 1");
        if (which == 0) {
            return this.levelInputs.get(i);
        }
        return this.levelUpInputs.get(i);
    }

    public long getMaxOutputFileSize() {
        return this.maxOutputFileSize;
    }

    public boolean isTrivialMove() {
        return this.levelInputs.size() == 1 && this.levelUpInputs.isEmpty() && Compaction.totalFileSize(this.grandparents) <= 0x1400000L;
    }

    public static long totalFileSize(List<FileMetaData> files) {
        long sum = 0L;
        for (FileMetaData file : files) {
            sum += file.getFileSize();
        }
        return sum;
    }

    public void addInputDeletions(VersionEdit edit) {
        for (FileMetaData input : this.levelInputs) {
            edit.deleteFile(this.level, input.getNumber());
        }
        for (FileMetaData input : this.levelUpInputs) {
            edit.deleteFile(this.level + 1, input.getNumber());
        }
    }

    public boolean isBaseLevelForKey(Slice userKey) {
        UserComparator userComparator = this.inputVersion.getInternalKeyComparator().getUserComparator();
        block0: for (int level = this.level + 2; level < 7; ++level) {
            List<FileMetaData> files = this.inputVersion.getFiles(level);
            while (this.levelPointers[level] < files.size()) {
                FileMetaData f = files.get(this.levelPointers[level]);
                if (userComparator.compare(userKey, f.getLargest().getUserKey()) <= 0) {
                    if (userComparator.compare(userKey, f.getSmallest().getUserKey()) < 0) continue block0;
                    return false;
                }
                int n = level;
                this.levelPointers[n] = this.levelPointers[n] + 1;
            }
        }
        return true;
    }

    public boolean shouldStopBefore(InternalKey internalKey) {
        if (this.grandparents == null) {
            return false;
        }
        InternalKeyComparator internalKeyComparator = this.inputVersion.getInternalKeyComparator();
        while (this.grandparentIndex < this.grandparents.size() && internalKeyComparator.compare(internalKey, this.grandparents.get(this.grandparentIndex).getLargest()) > 0) {
            if (this.seenKey) {
                this.overlappedBytes += this.grandparents.get(this.grandparentIndex).getFileSize();
            }
            ++this.grandparentIndex;
        }
        this.seenKey = true;
        if (this.overlappedBytes > 0x1400000L) {
            this.overlappedBytes = 0L;
            return true;
        }
        return false;
    }

    public List<FileMetaData>[] getInputs() {
        return this.inputs;
    }
}

