/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class Decimal128Element
extends AtomicElement<Decimal128> {
    private final Decimal128 _value;

    Decimal128Element(Element parent, Element prev, Decimal128 d) {
        super(parent, prev);
        this._value = d;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 16 : 17;
    }

    @Override
    public Decimal128 getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.DECIMAL128;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size2 = this.size();
        if (b.remaining() >= size2) {
            if (size2 == 17) {
                b.put((byte)-108);
            }
            b.putLong(this._value.getMostSignificantBits());
            b.putLong(this._value.getLeastSignificantBits());
            return size2;
        }
        return 0;
    }
}

