/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin.util;

import java.util.Set;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.plugin.AbstractRuntimeConfigurationBroker;

public class PolicyEntryUtil {
    public static PolicyEntry findEntryByDestination(AbstractRuntimeConfigurationBroker runtimeBroker, PolicyEntry entry) {
        PolicyMap existingMap = runtimeBroker.getBrokerService().getDestinationPolicy();
        Set existingEntries = existingMap.get(entry.getDestination());
        PolicyEntry existingEntry = null;
        for (PolicyEntry ee : existingEntries) {
            if (!ee.getDestination().equals(entry.getDestination())) continue;
            existingEntry = ee;
            break;
        }
        return existingEntry;
    }

    public static void applyRetrospectively(AbstractRuntimeConfigurationBroker runtimeBroker, PolicyEntry updatedEntry) {
        PolicyEntryUtil.applyRetrospectively(runtimeBroker, updatedEntry, null);
    }

    public static void applyRetrospectively(AbstractRuntimeConfigurationBroker runtimeBroker, PolicyEntry updatedEntry, Set<String> includedProperties) {
        RegionBroker regionBroker = (RegionBroker)runtimeBroker.getBrokerService().getRegionBroker();
        for (Destination destination : regionBroker.getDestinations(updatedEntry.getDestination())) {
            PolicyEntry specificyPolicy = regionBroker.getDestinationPolicy().getEntryFor(destination.getActiveMQDestination());
            if (!updatedEntry.equals(specificyPolicy)) continue;
            Destination target = destination;
            while (target instanceof DestinationFilter) {
                target = ((DestinationFilter)target).getNext();
            }
            if (target.getActiveMQDestination().isQueue()) {
                updatedEntry.update((Queue)target, includedProperties);
            } else if (target.getActiveMQDestination().isTopic()) {
                updatedEntry.update((Topic)target, includedProperties);
            }
            runtimeBroker.debug("applied update to:" + target);
        }
    }
}

