/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io;

public class PathUtils {
    public static String addPaths(String path1, String path2) {
        if (path1.endsWith("/")) {
            if (path2.startsWith("/")) {
                return path1.substring(0, path1.length() - 1) + path2;
            }
            return path1 + path2;
        }
        if (path2.startsWith("/")) {
            return path1 + path2;
        }
        return path1 + "/" + path2;
    }

    public static String addLeadingSlash(String path) {
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    public static String removeLeadingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    public static String addTrailingSlash(String path) {
        if (!path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    public static String removeTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getParentPath(String path) {
        String parentPath = path;
        if ("/".equals(parentPath)) {
            return parentPath;
        }
        int idx = (parentPath = PathUtils.removeTrailingSlash(parentPath)).lastIndexOf("/");
        parentPath = idx >= 0 ? parentPath.substring(0, idx + 1) : "/";
        return parentPath;
    }
}

