/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.Message;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.activemq.util.MarshallingSupport;
import org.apache.activemq.wireformat.WireFormat;

public class ActiveMQTextMessage
extends ActiveMQMessage
implements TextMessage {
    public static final byte DATA_STRUCTURE_TYPE = 28;
    protected String text;

    public Message copy() {
        ActiveMQTextMessage copy = new ActiveMQTextMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(ActiveMQTextMessage copy) {
        super.copy(copy);
        copy.text = this.text;
    }

    public byte getDataStructureType() {
        return 28;
    }

    public String getJMSXMimeType() {
        return "jms/text-message";
    }

    public void setText(String text) throws MessageNotWriteableException {
        this.checkReadOnlyBody();
        this.text = text;
        this.setContent(null);
    }

    public String getText() throws JMSException {
        if (this.text == null && this.getContent() != null) {
            InputStream is = null;
            try {
                ByteSequence bodyAsBytes = this.getContent();
                if (bodyAsBytes != null) {
                    is = new ByteArrayInputStream(bodyAsBytes);
                    if (this.isCompressed()) {
                        is = new InflaterInputStream(is);
                    }
                    DataInputStream dataIn = new DataInputStream(is);
                    this.text = MarshallingSupport.readUTF8(dataIn);
                    dataIn.close();
                    this.setContent(null);
                }
            }
            catch (IOException ioe) {
                throw JMSExceptionSupport.create(ioe);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return this.text;
    }

    public void beforeMarshall(WireFormat wireFormat) throws IOException {
        super.beforeMarshall(wireFormat);
        ByteSequence content = this.getContent();
        if (content == null && this.text != null) {
            ByteArrayOutputStream bytesOut;
            OutputStream os = bytesOut = new ByteArrayOutputStream();
            ActiveMQConnection connection = this.getConnection();
            if (connection != null && connection.isUseCompression()) {
                this.compressed = true;
                os = new DeflaterOutputStream(os);
            }
            DataOutputStream dataOut = new DataOutputStream(os);
            MarshallingSupport.writeUTF8(dataOut, this.text);
            dataOut.close();
            this.setContent(bytesOut.toByteSequence());
            this.text = null;
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    public int getSize() {
        if (this.size == 0 && this.content == null && this.text != null) {
            this.size = this.getMinimumMessageSize();
            if (this.marshalledProperties != null) {
                this.size += this.marshalledProperties.getLength();
            }
            this.size += this.text.length() * 2;
        }
        return super.getSize();
    }

    public String toString() {
        try {
            String text = this.getText();
            if (text != null && text.length() > 63) {
                text = text.substring(0, 45) + "..." + text.substring(text.length() - 12);
                HashMap<String, Object> overrideFields = new HashMap<String, Object>();
                overrideFields.put("text", text);
                return super.toString(overrideFields);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return super.toString();
    }
}

