/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.concurrent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.core.serializer.support.SerializationDelegate;
import org.springframework.util.Assert;

public class ConcurrentMapCache
extends AbstractValueAdaptingCache {
    private final String name;
    private final ConcurrentMap<Object, Object> store;
    private final SerializationDelegate serialization;

    public ConcurrentMapCache(String name) {
        this(name, new ConcurrentHashMap<Object, Object>(256), true);
    }

    public ConcurrentMapCache(String name, boolean allowNullValues) {
        this(name, new ConcurrentHashMap<Object, Object>(256), allowNullValues);
    }

    public ConcurrentMapCache(String name, ConcurrentMap<Object, Object> store2, boolean allowNullValues) {
        this(name, store2, allowNullValues, null);
    }

    protected ConcurrentMapCache(String name, ConcurrentMap<Object, Object> store2, boolean allowNullValues, SerializationDelegate serialization) {
        super(allowNullValues);
        Assert.notNull(name, "Name must not be null");
        Assert.notNull(store2, "Store must not be null");
        this.name = name;
        this.store = store2;
        this.serialization = serialization;
    }

    public final boolean isStoreByValue() {
        return this.serialization != null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final ConcurrentMap<Object, Object> getNativeCache() {
        return this.store;
    }

    @Override
    protected Object lookup(Object key) {
        return this.store.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Object key, Callable<T> valueLoader) {
        Cache.ValueWrapper storeValue = this.get(key);
        if (storeValue != null) {
            return (T)storeValue.get();
        }
        ConcurrentMap<Object, Object> concurrentMap = this.store;
        synchronized (concurrentMap) {
            T value;
            storeValue = this.get(key);
            if (storeValue != null) {
                return (T)storeValue.get();
            }
            try {
                value = valueLoader.call();
            }
            catch (Throwable ex) {
                throw new Cache.ValueRetrievalException(key, valueLoader, ex);
            }
            this.put(key, value);
            return value;
        }
    }

    @Override
    public void put(Object key, Object value) {
        this.store.put(key, this.toStoreValue(value));
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object existing = this.store.putIfAbsent(key, this.toStoreValue(value));
        return this.toValueWrapper(existing);
    }

    @Override
    public void evict(Object key) {
        this.store.remove(key);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    protected Object toStoreValue(Object userValue) {
        Object storeValue = super.toStoreValue(userValue);
        if (this.serialization != null) {
            try {
                return this.serializeValue(storeValue);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Failed to serialize cache value '" + userValue + "'. Does it implement Serializable?", ex);
            }
        }
        return storeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object serializeValue(Object storeValue) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.serialization.serialize(storeValue, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            out.close();
        }
    }

    @Override
    protected Object fromStoreValue(Object storeValue) {
        if (this.serialization != null) {
            try {
                return super.fromStoreValue(this.deserializeValue(storeValue));
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Failed to deserialize cache value '" + storeValue + "'", ex);
            }
        }
        return super.fromStoreValue(storeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserializeValue(Object storeValue) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream((byte[])storeValue);
        try {
            Object object = this.serialization.deserialize(in);
            return object;
        }
        finally {
            in.close();
        }
    }
}

