/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.core.xml.AbstractCamelContextFactoryBean;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.CamelProxyFactoryDefinition;
import org.apache.camel.core.xml.CamelServiceExporterDefinition;
import org.apache.camel.core.xml.CamelStreamCachingStrategyDefinition;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.GlobalOptionsDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.PropertiesDefinition;
import org.apache.camel.model.RestContextRefDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformersDefinition;
import org.apache.camel.model.validator.ValidatorsDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelConsumerTemplateFactoryBean;
import org.apache.camel.spring.CamelEndpointFactoryBean;
import org.apache.camel.spring.CamelFluentProducerTemplateFactoryBean;
import org.apache.camel.spring.CamelProducerTemplateFactoryBean;
import org.apache.camel.spring.CamelRedeliveryPolicyFactoryBean;
import org.apache.camel.spring.CamelThreadPoolFactoryBean;
import org.apache.camel.spring.ContextScanRouteBuilderFinder;
import org.apache.camel.spring.ErrorHandlerDefinition;
import org.apache.camel.spring.PackageScanRouteBuilderFinder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.spi.BridgePropertyPlaceholderConfigurer;
import org.apache.camel.spring.spi.XmlCamelContextConfigurer;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.Lifecycle;
import org.springframework.context.Phased;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

@Metadata(label="spring,configuration")
@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends AbstractCamelContextFactoryBean<SpringCamelContext>
implements FactoryBean<SpringCamelContext>,
InitializingBean,
DisposableBean,
ApplicationContextAware,
Lifecycle,
Phased,
ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextFactoryBean.class);
    @XmlAttribute(name="depends-on")
    private String dependsOn;
    @XmlAttribute
    private String trace;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private String messageHistory;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private String logMask;
    @XmlAttribute
    private String logExhaustedMessageBody;
    @XmlAttribute
    private String streamCache;
    @XmlAttribute
    private String delayer;
    @XmlAttribute
    private String handleFault;
    @XmlAttribute
    private String errorHandlerRef;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private String autoStartup;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private String shutdownEager;
    @XmlAttribute
    @Metadata(defaultValue="false")
    @Deprecated
    private String registerEndpointIdsFromRoute;
    @XmlAttribute
    private String useMDCLogging;
    @XmlAttribute
    private String useDataType;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private String useBreadcrumb;
    @XmlAttribute
    private String allowUseOriginalMessage;
    @XmlAttribute
    private String runtimeEndpointRegistryEnabled;
    @XmlAttribute
    @Metadata(defaultValue="#name#")
    private String managementNamePattern;
    @XmlAttribute
    @Metadata(defaultValue="Camel (#camelId#) thread ##counter# - #name#")
    private String threadNamePattern;
    @XmlAttribute
    @Metadata(defaultValue="Default")
    private ShutdownRoute shutdownRoute;
    @XmlAttribute
    @Metadata(defaultValue="CompleteCurrentTaskOnly")
    private ShutdownRunningTask shutdownRunningTask;
    @XmlAttribute
    @Deprecated
    @Metadata(defaultValue="false")
    private Boolean lazyLoadTypeConverters;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean loadTypeConverters;
    @XmlAttribute
    private Boolean typeConverterStatisticsEnabled;
    @XmlAttribute
    @Metadata(defaultValue="Override")
    private TypeConverterExists typeConverterExists;
    @XmlAttribute
    @Metadata(defaultValue="WARN")
    private LoggingLevel typeConverterExistsLoggingLevel;
    @Deprecated
    @XmlElement(name="properties")
    private PropertiesDefinition properties;
    @XmlElement(name="globalOptions")
    private GlobalOptionsDefinition globalOptions;
    @XmlElement(name="propertyPlaceholder", type=CamelPropertyPlaceholderDefinition.class)
    private CamelPropertyPlaceholderDefinition camelPropertyPlaceholder;
    @XmlElement(name="package")
    private String[] packages = new String[0];
    @XmlElement(name="packageScan", type=PackageScanDefinition.class)
    private PackageScanDefinition packageScan;
    @XmlElement(name="contextScan", type=ContextScanDefinition.class)
    private ContextScanDefinition contextScan;
    @XmlElement(name="streamCaching", type=CamelStreamCachingStrategyDefinition.class)
    private CamelStreamCachingStrategyDefinition camelStreamCachingStrategy;
    @XmlElement(name="jmxAgent", type=CamelJMXAgentDefinition.class)
    private CamelJMXAgentDefinition camelJMXAgent;
    @XmlElements(value={@XmlElement(name="template", type=CamelProducerTemplateFactoryBean.class), @XmlElement(name="fluentTemplate", type=CamelFluentProducerTemplateFactoryBean.class), @XmlElement(name="consumerTemplate", type=CamelConsumerTemplateFactoryBean.class)})
    private List<AbstractCamelFactoryBean<?>> beansFactory;
    @XmlElements(value={@XmlElement(name="proxy", type=CamelProxyFactoryDefinition.class), @XmlElement(name="export", type=CamelServiceExporterDefinition.class), @XmlElement(name="errorHandler", type=ErrorHandlerDefinition.class)})
    private List<?> beans;
    @XmlElement(name="defaultServiceCallConfiguration")
    private ServiceCallConfigurationDefinition defaultServiceCallConfiguration;
    @XmlElement(name="serviceCallConfiguration", type=ServiceCallConfigurationDefinition.class)
    private List<ServiceCallConfigurationDefinition> serviceCallConfigurations;
    @XmlElement(name="defaultHystrixConfiguration")
    private HystrixConfigurationDefinition defaultHystrixConfiguration;
    @XmlElement(name="hystrixConfiguration", type=HystrixConfigurationDefinition.class)
    private List<HystrixConfigurationDefinition> hystrixConfigurations;
    @XmlElement(name="routeBuilder")
    private List<RouteBuilderDefinition> builderRefs = new ArrayList<RouteBuilderDefinition>();
    @XmlElement(name="routeContextRef")
    private List<RouteContextRefDefinition> routeRefs = new ArrayList<RouteContextRefDefinition>();
    @XmlElement(name="restContextRef")
    private List<RestContextRefDefinition> restRefs = new ArrayList<RestContextRefDefinition>();
    @XmlElement(name="threadPoolProfile")
    private List<ThreadPoolProfileDefinition> threadPoolProfiles;
    @XmlElement(name="threadPool")
    private List<CamelThreadPoolFactoryBean> threadPools;
    @XmlElement(name="endpoint")
    private List<CamelEndpointFactoryBean> endpoints;
    @XmlElement(name="dataFormats")
    private DataFormatsDefinition dataFormats;
    @XmlElement(name="transformers")
    private TransformersDefinition transformers;
    @XmlElement(name="validators")
    private ValidatorsDefinition validators;
    @XmlElement(name="redeliveryPolicyProfile")
    private List<CamelRedeliveryPolicyFactoryBean> redeliveryPolicies;
    @XmlElement(name="onException")
    private List<OnExceptionDefinition> onExceptions = new ArrayList<OnExceptionDefinition>();
    @XmlElement(name="onCompletion")
    private List<OnCompletionDefinition> onCompletions = new ArrayList<OnCompletionDefinition>();
    @XmlElement(name="intercept")
    private List<InterceptDefinition> intercepts = new ArrayList<InterceptDefinition>();
    @XmlElement(name="interceptFrom")
    private List<InterceptFromDefinition> interceptFroms = new ArrayList<InterceptFromDefinition>();
    @XmlElement(name="interceptSendToEndpoint")
    private List<InterceptSendToEndpointDefinition> interceptSendToEndpoints = new ArrayList<InterceptSendToEndpointDefinition>();
    @XmlElement(name="restConfiguration")
    private RestConfigurationDefinition restConfiguration;
    @XmlElement(name="rest")
    private List<RestDefinition> rests = new ArrayList<RestDefinition>();
    @XmlElement(name="route")
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    @XmlTransient
    private SpringCamelContext context;
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart;
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private BeanPostProcessor beanPostProcessor;
    @XmlTransient
    private boolean implicitId;

    @Override
    public Class<SpringCamelContext> getObjectType() {
        return SpringCamelContext.class;
    }

    @Override
    protected <S> S getBeanForType(Class<S> clazz) {
        ApplicationContext parentContext;
        S bean = null;
        String[] names = this.getApplicationContext().getBeanNamesForType(clazz, true, true);
        if (names.length == 1) {
            bean = this.getApplicationContext().getBean(names[0], clazz);
        }
        if (bean == null && (parentContext = this.getApplicationContext().getParent()) != null && (names = parentContext.getBeanNamesForType(clazz, true, true)).length == 1) {
            bean = parentContext.getBean(names[0], clazz);
        }
        return bean;
    }

    @Override
    protected void findRouteBuildersByPackageScan(String[] packages, PackageScanFilter filter, List<RoutesBuilder> builders) throws Exception {
        ((SpringCamelContext)this.getContext()).getPackageScanClassResolver().addFilter(filter);
        PackageScanRouteBuilderFinder finder = new PackageScanRouteBuilderFinder((SpringCamelContext)this.getContext(), packages, this.getContextClassLoaderOnStart(), this.getBeanPostProcessor(), ((SpringCamelContext)this.getContext()).getPackageScanClassResolver());
        finder.appendBuilders(builders);
        ((SpringCamelContext)this.getContext()).getPackageScanClassResolver().removeFilter(filter);
    }

    @Override
    protected void findRouteBuildersByContextScan(PackageScanFilter filter, boolean includeNonSingletons, List<RoutesBuilder> builders) throws Exception {
        ContextScanRouteBuilderFinder finder = new ContextScanRouteBuilderFinder((SpringCamelContext)this.getContext(), filter, includeNonSingletons);
        finder.appendBuilders(builders);
    }

    @Override
    protected void initBeanPostProcessor(SpringCamelContext context) {
        if (this.beanPostProcessor != null) {
            if (this.beanPostProcessor instanceof ApplicationContextAware) {
                ((ApplicationContextAware)((Object)this.beanPostProcessor)).setApplicationContext(this.applicationContext);
            }
            if (this.beanPostProcessor instanceof CamelBeanPostProcessor) {
                ((CamelBeanPostProcessor)this.beanPostProcessor).setCamelContext((CamelContext)this.getContext());
            }
        }
    }

    @Override
    protected void postProcessBeforeInit(RouteBuilder builder) {
        if (this.beanPostProcessor != null) {
            this.beanPostProcessor.postProcessBeforeInitialization(builder, builder.toString());
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        StopWatch watch = new StopWatch();
        super.afterPropertiesSet();
        Boolean shutdownEager = CamelContextHelper.parseBoolean(this.getContext(), this.getShutdownEager());
        if (shutdownEager != null) {
            LOG.debug("Using shutdownEager: {}", (Object)shutdownEager);
            ((SpringCamelContext)this.getContext()).setShutdownEager(shutdownEager);
        }
        LOG.debug("afterPropertiesSet() took {} millis", (Object)watch.stop());
    }

    @Override
    protected void initCustomRegistry(SpringCamelContext context) {
        Registry registry = this.getBeanForType(Registry.class);
        if (registry != null) {
            LOG.info("Using custom Registry: {}", (Object)registry);
            context.setRegistry(registry);
        }
    }

    @Override
    protected void initPropertyPlaceholder() throws Exception {
        super.initPropertyPlaceholder();
        Map<String, BridgePropertyPlaceholderConfigurer> beans = this.applicationContext.getBeansOfType(BridgePropertyPlaceholderConfigurer.class);
        if (beans.size() == 1) {
            BridgePropertyPlaceholderConfigurer configurer = beans.values().iterator().next();
            String id = beans.keySet().iterator().next();
            LOG.info("Bridging Camel and Spring property placeholder configurer with id: {}", (Object)id);
            PropertiesComponent pc = (PropertiesComponent)((SpringCamelContext)this.getContext()).getComponent("properties", false);
            if (pc == null) {
                pc = new PropertiesComponent();
                ((SpringCamelContext)this.getContext()).addComponent("properties", pc);
            }
            pc.setSystemPropertiesMode(configurer.getSystemPropertiesMode());
            configurer.setResolver(pc.getPropertiesResolver());
            configurer.setParser(pc.getPropertiesParser());
            pc.setPropertiesResolver(configurer);
            pc.setPropertiesParser(configurer);
            ArrayList<PropertiesLocation> locations = new ArrayList<PropertiesLocation>(pc.getLocations());
            locations.add(0, new PropertiesLocation("ref", id));
            pc.setLocations((List<PropertiesLocation>)locations);
        } else if (beans.size() > 1) {
            LOG.warn("Cannot bridge Camel and Spring property placeholders, as exact only 1 bean of type BridgePropertyPlaceholderConfigurer must be defined, was {} beans defined.", (Object)beans.size());
        }
    }

    @Override
    public void start() {
        try {
            this.setupRoutes();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        this.context.start();
    }

    @Override
    public void stop() {
        if (this.context != null) {
            this.context.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.context != null && this.context.isRunning();
    }

    @Override
    public int getPhase() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFFE;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.start();
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalArgumentException("No applicationContext has been injected!");
        }
        return this.applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanPostProcessor(BeanPostProcessor postProcessor) {
        this.beanPostProcessor = postProcessor;
    }

    public BeanPostProcessor getBeanPostProcessor() {
        return this.beanPostProcessor;
    }

    protected SpringCamelContext createContext() {
        SpringCamelContext ctx = this.newCamelContext();
        ctx.setName(this.getId());
        return ctx;
    }

    protected void configure(SpringCamelContext ctx) {
        try {
            XmlCamelContextConfigurer configurer;
            if (this.applicationContext.containsBean("xmlCamelContextConfigurer") && (configurer = this.applicationContext.getBean("xmlCamelContextConfigurer", XmlCamelContextConfigurer.class)) != null) {
                configurer.configure(this.applicationContext, ctx);
            }
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    protected SpringCamelContext newCamelContext() {
        return new SpringCamelContext(this.getApplicationContext());
    }

    @Override
    public SpringCamelContext getContext(boolean create) {
        if (this.context == null && create) {
            this.context = this.createContext();
            this.configure(this.context);
        }
        return this.context;
    }

    public void setContext(SpringCamelContext context) {
        this.context = context;
    }

    @Override
    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    @Override
    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
    }

    @Override
    public List<RestDefinition> getRests() {
        return this.rests;
    }

    @Override
    public void setRests(List<RestDefinition> rests) {
        this.rests = rests;
    }

    @Override
    public RestConfigurationDefinition getRestConfiguration() {
        return this.restConfiguration;
    }

    public void setRestConfiguration(RestConfigurationDefinition restConfiguration) {
        this.restConfiguration = restConfiguration;
    }

    @Override
    public List<CamelEndpointFactoryBean> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<CamelEndpointFactoryBean> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public List<CamelRedeliveryPolicyFactoryBean> getRedeliveryPolicies() {
        return this.redeliveryPolicies;
    }

    @Override
    public List<InterceptDefinition> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptDefinition> intercepts) {
        this.intercepts = intercepts;
    }

    @Override
    public List<InterceptFromDefinition> getInterceptFroms() {
        return this.interceptFroms;
    }

    public void setInterceptFroms(List<InterceptFromDefinition> interceptFroms) {
        this.interceptFroms = interceptFroms;
    }

    @Override
    public List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints() {
        return this.interceptSendToEndpoints;
    }

    public void setInterceptSendToEndpoints(List<InterceptSendToEndpointDefinition> interceptSendToEndpoints) {
        this.interceptSendToEndpoints = interceptSendToEndpoints;
    }

    @Override
    @Deprecated
    public PropertiesDefinition getProperties() {
        return this.properties;
    }

    @Override
    public GlobalOptionsDefinition getGlobalOptions() {
        return this.globalOptions;
    }

    @Deprecated
    public void setProperties(PropertiesDefinition properties) {
        this.properties = properties;
    }

    public void setGlobalOptions(GlobalOptionsDefinition globalOptions) {
        this.globalOptions = globalOptions;
    }

    @Override
    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    @Override
    public PackageScanDefinition getPackageScan() {
        return this.packageScan;
    }

    @Override
    public void setPackageScan(PackageScanDefinition packageScan) {
        this.packageScan = packageScan;
    }

    @Override
    public ContextScanDefinition getContextScan() {
        return this.contextScan;
    }

    @Override
    public void setContextScan(ContextScanDefinition contextScan) {
        this.contextScan = contextScan;
    }

    @Override
    public CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder() {
        return this.camelPropertyPlaceholder;
    }

    public void setCamelPropertyPlaceholder(CamelPropertyPlaceholderDefinition camelPropertyPlaceholder) {
        this.camelPropertyPlaceholder = camelPropertyPlaceholder;
    }

    @Override
    public CamelStreamCachingStrategyDefinition getCamelStreamCachingStrategy() {
        return this.camelStreamCachingStrategy;
    }

    public void setCamelStreamCachingStrategy(CamelStreamCachingStrategyDefinition camelStreamCachingStrategy) {
        this.camelStreamCachingStrategy = camelStreamCachingStrategy;
    }

    public void setCamelJMXAgent(CamelJMXAgentDefinition agent) {
        this.camelJMXAgent = agent;
    }

    @Override
    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    @Override
    public String getMessageHistory() {
        return this.messageHistory;
    }

    public void setMessageHistory(String messageHistory) {
        this.messageHistory = messageHistory;
    }

    @Override
    public String getLogMask() {
        return this.logMask;
    }

    public void setLogMask(String logMask) {
        this.logMask = logMask;
    }

    @Override
    public String getLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    public void setLogExhaustedMessageBody(String logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    @Override
    public String getStreamCache() {
        return this.streamCache;
    }

    public void setStreamCache(String streamCache) {
        this.streamCache = streamCache;
    }

    @Override
    public String getDelayer() {
        return this.delayer;
    }

    public void setDelayer(String delayer) {
        this.delayer = delayer;
    }

    @Override
    public String getHandleFault() {
        return this.handleFault;
    }

    public void setHandleFault(String handleFault) {
        this.handleFault = handleFault;
    }

    @Override
    public String getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(String autoStartup) {
        this.autoStartup = autoStartup;
    }

    public String getShutdownEager() {
        return this.shutdownEager;
    }

    public void setShutdownEager(String shutdownEager) {
        this.shutdownEager = shutdownEager;
    }

    public String getRegisterEndpointIdsFromRoute() {
        return this.registerEndpointIdsFromRoute;
    }

    public void setRegisterEndpointIdsFromRoute(String registerEndpointIdsFromRoute) {
        this.registerEndpointIdsFromRoute = registerEndpointIdsFromRoute;
    }

    @Override
    public String getUseMDCLogging() {
        return this.useMDCLogging;
    }

    public void setUseMDCLogging(String useMDCLogging) {
        this.useMDCLogging = useMDCLogging;
    }

    @Override
    public String getUseDataType() {
        return this.useDataType;
    }

    public void setUseDataType(String useDataType) {
        this.useDataType = useDataType;
    }

    @Override
    public String getUseBreadcrumb() {
        return this.useBreadcrumb;
    }

    public void setUseBreadcrumb(String useBreadcrumb) {
        this.useBreadcrumb = useBreadcrumb;
    }

    @Override
    public String getAllowUseOriginalMessage() {
        return this.allowUseOriginalMessage;
    }

    public void setAllowUseOriginalMessage(String allowUseOriginalMessage) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
    }

    @Override
    public String getRuntimeEndpointRegistryEnabled() {
        return this.runtimeEndpointRegistryEnabled;
    }

    public void setRuntimeEndpointRegistryEnabled(String runtimeEndpointRegistryEnabled) {
        this.runtimeEndpointRegistryEnabled = runtimeEndpointRegistryEnabled;
    }

    @Override
    public String getManagementNamePattern() {
        return this.managementNamePattern;
    }

    public void setManagementNamePattern(String managementNamePattern) {
        this.managementNamePattern = managementNamePattern;
    }

    @Override
    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    public void setThreadNamePattern(String threadNamePattern) {
        this.threadNamePattern = threadNamePattern;
    }

    @Override
    @Deprecated
    public Boolean getLazyLoadTypeConverters() {
        return this.lazyLoadTypeConverters;
    }

    @Deprecated
    public void setLazyLoadTypeConverters(Boolean lazyLoadTypeConverters) {
        this.lazyLoadTypeConverters = lazyLoadTypeConverters;
    }

    @Override
    public Boolean getLoadTypeConverters() {
        return this.loadTypeConverters;
    }

    public void setLoadTypeConverters(Boolean loadTypeConverters) {
        this.loadTypeConverters = loadTypeConverters;
    }

    @Override
    public Boolean getTypeConverterStatisticsEnabled() {
        return this.typeConverterStatisticsEnabled;
    }

    public void setTypeConverterStatisticsEnabled(Boolean typeConverterStatisticsEnabled) {
        this.typeConverterStatisticsEnabled = typeConverterStatisticsEnabled;
    }

    @Override
    public TypeConverterExists getTypeConverterExists() {
        return this.typeConverterExists;
    }

    public void setTypeConverterExists(TypeConverterExists typeConverterExists) {
        this.typeConverterExists = typeConverterExists;
    }

    @Override
    public LoggingLevel getTypeConverterExistsLoggingLevel() {
        return this.typeConverterExistsLoggingLevel;
    }

    public void setTypeConverterExistsLoggingLevel(LoggingLevel typeConverterExistsLoggingLevel) {
        this.typeConverterExistsLoggingLevel = typeConverterExistsLoggingLevel;
    }

    @Override
    public CamelJMXAgentDefinition getCamelJMXAgent() {
        return this.camelJMXAgent;
    }

    @Override
    public List<RouteBuilderDefinition> getBuilderRefs() {
        return this.builderRefs;
    }

    public void setBuilderRefs(List<RouteBuilderDefinition> builderRefs) {
        this.builderRefs = builderRefs;
    }

    @Override
    public List<RouteContextRefDefinition> getRouteRefs() {
        return this.routeRefs;
    }

    public void setRouteRefs(List<RouteContextRefDefinition> routeRefs) {
        this.routeRefs = routeRefs;
    }

    @Override
    public List<RestContextRefDefinition> getRestRefs() {
        return this.restRefs;
    }

    public void setRestRefs(List<RestContextRefDefinition> restRefs) {
        this.restRefs = restRefs;
    }

    @Override
    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
    }

    public void setDataFormats(DataFormatsDefinition dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public DataFormatsDefinition getDataFormats() {
        return this.dataFormats;
    }

    public void setTransformers(TransformersDefinition transformers) {
        this.transformers = transformers;
    }

    @Override
    public TransformersDefinition getTransformers() {
        return this.transformers;
    }

    public void setValidators(ValidatorsDefinition validators) {
        this.validators = validators;
    }

    @Override
    public ValidatorsDefinition getValidators() {
        return this.validators;
    }

    public void setRedeliveryPolicies(List<CamelRedeliveryPolicyFactoryBean> redeliveryPolicies) {
        this.redeliveryPolicies = redeliveryPolicies;
    }

    @Override
    public List<AbstractCamelFactoryBean<?>> getBeansFactory() {
        return this.beansFactory;
    }

    public void setBeansFactory(List<AbstractCamelFactoryBean<?>> beansFactory) {
        this.beansFactory = beansFactory;
    }

    @Override
    public List<?> getBeans() {
        return this.beans;
    }

    public void setBeans(List<?> beans) {
        this.beans = beans;
    }

    @Override
    public ServiceCallConfigurationDefinition getDefaultServiceCallConfiguration() {
        return this.defaultServiceCallConfiguration;
    }

    public void setDefaultServiceCallConfiguration(ServiceCallConfigurationDefinition defaultServiceCallConfiguration) {
        this.defaultServiceCallConfiguration = defaultServiceCallConfiguration;
    }

    @Override
    public List<ServiceCallConfigurationDefinition> getServiceCallConfigurations() {
        return this.serviceCallConfigurations;
    }

    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> serviceCallConfigurations) {
        this.serviceCallConfigurations = serviceCallConfigurations;
    }

    @Override
    public List<HystrixConfigurationDefinition> getHystrixConfigurations() {
        return this.hystrixConfigurations;
    }

    @Override
    public HystrixConfigurationDefinition getDefaultHystrixConfiguration() {
        return this.defaultHystrixConfiguration;
    }

    public void setDefaultHystrixConfiguration(HystrixConfigurationDefinition defaultHystrixConfiguration) {
        this.defaultHystrixConfiguration = defaultHystrixConfiguration;
    }

    public void setHystrixConfigurations(List<HystrixConfigurationDefinition> hystrixConfigurations) {
        this.hystrixConfigurations = hystrixConfigurations;
    }

    public void setOnExceptions(List<OnExceptionDefinition> onExceptions) {
        this.onExceptions = onExceptions;
    }

    @Override
    public List<OnExceptionDefinition> getOnExceptions() {
        return this.onExceptions;
    }

    @Override
    public List<OnCompletionDefinition> getOnCompletions() {
        return this.onCompletions;
    }

    public void setOnCompletions(List<OnCompletionDefinition> onCompletions) {
        this.onCompletions = onCompletions;
    }

    @Override
    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    @Override
    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    @Override
    public List<ThreadPoolProfileDefinition> getThreadPoolProfiles() {
        return this.threadPoolProfiles;
    }

    public void setThreadPoolProfiles(List<ThreadPoolProfileDefinition> threadPoolProfiles) {
        this.threadPoolProfiles = threadPoolProfiles;
    }

    public List<CamelThreadPoolFactoryBean> getThreadPools() {
        return this.threadPools;
    }

    public void setThreadPools(List<CamelThreadPoolFactoryBean> threadPools) {
        this.threadPools = threadPools;
    }

    @Override
    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public boolean isImplicitId() {
        return this.implicitId;
    }

    public void setImplicitId(boolean flag) {
        this.implicitId = flag;
    }
}

