/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transaction;

import java.io.IOException;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transaction.Synchronization;

public abstract class Transaction {
    public static final byte START_STATE = 0;
    public static final byte IN_USE_STATE = 1;
    public static final byte PREPARED_STATE = 2;
    public static final byte FINISHED_STATE = 3;
    private ArrayList<Synchronization> synchronizations = new ArrayList();
    private byte state = 0;

    public byte getState() {
        return this.state;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public void addSynchronization(Synchronization r) {
        this.synchronizations.add(r);
        if (this.state == 0) {
            this.state = 1;
        }
    }

    public void removeSynchronization(Synchronization r) {
        this.synchronizations.remove(r);
    }

    public void prePrepare() throws Exception {
        switch (this.state) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                XAException xae = new XAException("Prepare cannot be called now.");
                xae.errorCode = -6;
                throw xae;
            }
        }
    }

    protected void fireAfterCommit() throws Exception {
        for (Synchronization s : this.synchronizations) {
            s.afterCommit();
        }
    }

    public void fireAfterRollback() throws Exception {
        for (Synchronization s : this.synchronizations) {
            s.afterRollback();
        }
    }

    public String toString() {
        return super.toString() + "[synchronizations=" + this.synchronizations + "]";
    }

    public abstract void commit(boolean var1) throws XAException, IOException;

    public abstract void rollback() throws XAException, IOException;

    public abstract int prepare() throws XAException, IOException;

    public abstract TransactionId getTransactionId();

    public boolean isPrepared() {
        return this.getState() == 2;
    }
}

