/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.IOException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.ReferenceStore;
import org.apache.activemq.store.kahadaptor.KahaReferenceStoreAdapter;
import org.apache.activemq.store.kahadaptor.ReferenceRecord;
import org.apache.activemq.usage.MemoryUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KahaReferenceStore
implements ReferenceStore {
    protected final ActiveMQDestination destination;
    protected final MapContainer<MessageId, ReferenceRecord> messageContainer;
    protected KahaReferenceStoreAdapter adapter;
    private StoreEntry batchEntry;
    private String lastBatchId;

    public KahaReferenceStore(KahaReferenceStoreAdapter adapter, MapContainer<MessageId, ReferenceRecord> container, ActiveMQDestination destination) throws IOException {
        this.adapter = adapter;
        this.messageContainer = container;
        this.destination = destination;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    protected MessageId getMessageId(Object object) {
        return new MessageId(((ReferenceRecord)object).getMessageId());
    }

    @Override
    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        throw new RuntimeException("Use addMessageReference instead");
    }

    @Override
    public synchronized Message getMessage(MessageId identity) throws IOException {
        throw new RuntimeException("Use addMessageReference instead");
    }

    protected final boolean recoverReference(MessageRecoveryListener listener, ReferenceRecord record) throws Exception {
        MessageId id = new MessageId(record.getMessageId());
        if (listener.hasSpace()) {
            listener.recoverMessageReference(id);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void recover(MessageRecoveryListener listener) throws Exception {
        ReferenceRecord record;
        StoreEntry entry = this.messageContainer.getFirst();
        while (entry != null && this.recoverReference(listener, record = this.messageContainer.getValue(entry))) {
            entry = this.messageContainer.getNext(entry);
        }
    }

    @Override
    public synchronized void recoverNextMessages(int maxReturned, MessageRecoveryListener listener) throws Exception {
        StoreEntry entry = this.batchEntry;
        if (entry == null) {
            entry = this.messageContainer.getFirst();
        } else if ((entry = this.messageContainer.refresh(entry)) != null) {
            entry = this.messageContainer.getNext(entry);
        }
        if (entry != null) {
            int count = 0;
            do {
                ReferenceRecord msg;
                if ((msg = this.messageContainer.getValue(entry)) != null) {
                    if (this.recoverReference(listener, msg)) {
                        ++count;
                        this.lastBatchId = msg.getMessageId();
                    }
                } else {
                    this.lastBatchId = null;
                }
                this.batchEntry = entry;
            } while ((entry = this.messageContainer.getNext(entry)) != null && count < maxReturned && listener.hasSpace());
        }
    }

    @Override
    public synchronized void addMessageReference(ConnectionContext context, MessageId messageId, ReferenceStore.ReferenceData data) throws IOException {
        ReferenceRecord record = new ReferenceRecord(messageId.toString(), data);
        this.messageContainer.put(messageId, record);
        this.addInterest(record);
    }

    @Override
    public synchronized ReferenceStore.ReferenceData getMessageReference(MessageId identity) throws IOException {
        ReferenceRecord result = this.messageContainer.get(identity);
        if (result == null) {
            return null;
        }
        return result.getData();
    }

    public void addReferenceFileIdsInUse() {
        StoreEntry entry = this.messageContainer.getFirst();
        while (entry != null) {
            ReferenceRecord msg = this.messageContainer.getValue(entry);
            this.addInterest(msg);
            entry = this.messageContainer.getNext(entry);
        }
    }

    @Override
    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.removeMessage(ack.getLastMessageId());
    }

    public synchronized void removeMessage(MessageId msgId) throws IOException {
        ReferenceRecord rr;
        StoreEntry entry = this.messageContainer.getEntry(msgId);
        if (entry != null && (rr = this.messageContainer.remove(msgId)) != null) {
            this.removeInterest(rr);
            if (this.messageContainer.isEmpty() || this.lastBatchId != null && this.lastBatchId.equals(msgId.toString()) || this.batchEntry != null && this.batchEntry.equals(entry)) {
                this.resetBatching();
            }
        }
    }

    @Override
    public synchronized void removeAllMessages(ConnectionContext context) throws IOException {
        this.messageContainer.clear();
    }

    @Override
    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public synchronized void delete() {
        this.messageContainer.clear();
    }

    @Override
    public synchronized void resetBatching() {
        this.batchEntry = null;
        this.lastBatchId = null;
    }

    @Override
    public int getMessageCount() {
        return this.messageContainer.size();
    }

    @Override
    public void setMemoryUsage(MemoryUsage memoryUsage) {
    }

    public boolean isSupportForCursors() {
        return true;
    }

    @Override
    public boolean supportsExternalBatchControl() {
        return true;
    }

    void removeInterest(ReferenceRecord rr) {
        this.adapter.removeInterestInRecordFile(rr.getData().getFileId());
    }

    void addInterest(ReferenceRecord rr) {
        this.adapter.addInterestInRecordFile(rr.getData().getFileId());
    }

    @Override
    public void setBatch(MessageId startAfter) {
    }
}

