/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.naming.NamingException;
import org.apache.activemq.network.jms.InboundQueueBridge;
import org.apache.activemq.network.jms.JmsConnector;
import org.apache.activemq.network.jms.OutboundQueueBridge;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsQueueConnector
extends JmsConnector {
    private static final Log LOG = LogFactory.getLog(JmsQueueConnector.class);
    private String outboundQueueConnectionFactoryName;
    private String localConnectionFactoryName;
    private QueueConnectionFactory outboundQueueConnectionFactory;
    private QueueConnectionFactory localQueueConnectionFactory;
    private QueueConnection outboundQueueConnection;
    private QueueConnection localQueueConnection;
    private InboundQueueBridge[] inboundQueueBridges;
    private OutboundQueueBridge[] outboundQueueBridges;

    public boolean init() {
        boolean result = super.init();
        if (result) {
            try {
                this.initializeForeignQueueConnection();
                this.initializeLocalQueueConnection();
                this.initializeInboundJmsMessageConvertor();
                this.initializeOutboundJmsMessageConvertor();
                this.initializeInboundQueueBridges();
                this.initializeOutboundQueueBridges();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to initialize the JMSConnector", (Throwable)e);
            }
        }
        return result;
    }

    public InboundQueueBridge[] getInboundQueueBridges() {
        return this.inboundQueueBridges;
    }

    public void setInboundQueueBridges(InboundQueueBridge[] inboundQueueBridges) {
        this.inboundQueueBridges = inboundQueueBridges;
    }

    public OutboundQueueBridge[] getOutboundQueueBridges() {
        return this.outboundQueueBridges;
    }

    public void setOutboundQueueBridges(OutboundQueueBridge[] outboundQueueBridges) {
        this.outboundQueueBridges = outboundQueueBridges;
    }

    public QueueConnectionFactory getLocalQueueConnectionFactory() {
        return this.localQueueConnectionFactory;
    }

    public void setLocalQueueConnectionFactory(QueueConnectionFactory localConnectionFactory) {
        this.localQueueConnectionFactory = localConnectionFactory;
    }

    public QueueConnectionFactory getOutboundQueueConnectionFactory() {
        return this.outboundQueueConnectionFactory;
    }

    public String getOutboundQueueConnectionFactoryName() {
        return this.outboundQueueConnectionFactoryName;
    }

    public void setOutboundQueueConnectionFactoryName(String foreignQueueConnectionFactoryName) {
        this.outboundQueueConnectionFactoryName = foreignQueueConnectionFactoryName;
    }

    public String getLocalConnectionFactoryName() {
        return this.localConnectionFactoryName;
    }

    public void setLocalConnectionFactoryName(String localConnectionFactoryName) {
        this.localConnectionFactoryName = localConnectionFactoryName;
    }

    public QueueConnection getLocalQueueConnection() {
        return this.localQueueConnection;
    }

    public void setLocalQueueConnection(QueueConnection localQueueConnection) {
        this.localQueueConnection = localQueueConnection;
    }

    public QueueConnection getOutboundQueueConnection() {
        return this.outboundQueueConnection;
    }

    public void setOutboundQueueConnection(QueueConnection foreignQueueConnection) {
        this.outboundQueueConnection = foreignQueueConnection;
    }

    public void setOutboundQueueConnectionFactory(QueueConnectionFactory foreignQueueConnectionFactory) {
        this.outboundQueueConnectionFactory = foreignQueueConnectionFactory;
    }

    public void restartProducerConnection() throws NamingException, JMSException {
        this.outboundQueueConnection = null;
        this.initializeForeignQueueConnection();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeForeignQueueConnection() throws NamingException, JMSException {
        if (this.outboundQueueConnection == null) {
            if (this.outboundQueueConnectionFactory == null) {
                if (this.outboundQueueConnectionFactoryName == null) throw new JMSException("Cannot create localConnection - no information");
                this.outboundQueueConnectionFactory = (QueueConnectionFactory)this.jndiOutboundTemplate.lookup(this.outboundQueueConnectionFactoryName, QueueConnectionFactory.class);
                this.outboundQueueConnection = this.outboundUsername != null ? this.outboundQueueConnectionFactory.createQueueConnection(this.outboundUsername, this.outboundPassword) : this.outboundQueueConnectionFactory.createQueueConnection();
            } else {
                this.outboundQueueConnection = this.outboundUsername != null ? this.outboundQueueConnectionFactory.createQueueConnection(this.outboundUsername, this.outboundPassword) : this.outboundQueueConnectionFactory.createQueueConnection();
            }
        }
        this.outboundQueueConnection.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeLocalQueueConnection() throws NamingException, JMSException {
        if (this.localQueueConnection == null) {
            if (this.localQueueConnectionFactory == null) {
                if (this.embeddedConnectionFactory == null) {
                    if (this.localConnectionFactoryName == null) throw new JMSException("Cannot create localConnection - no information");
                    this.localQueueConnectionFactory = (QueueConnectionFactory)this.jndiLocalTemplate.lookup(this.localConnectionFactoryName, QueueConnectionFactory.class);
                    this.localQueueConnection = this.localUsername != null ? this.localQueueConnectionFactory.createQueueConnection(this.localUsername, this.localPassword) : this.localQueueConnectionFactory.createQueueConnection();
                } else {
                    this.localQueueConnection = this.embeddedConnectionFactory.createQueueConnection();
                }
            } else {
                this.localQueueConnection = this.localUsername != null ? this.localQueueConnectionFactory.createQueueConnection(this.localUsername, this.localPassword) : this.localQueueConnectionFactory.createQueueConnection();
            }
        }
        this.localQueueConnection.start();
    }

    protected void initializeInboundJmsMessageConvertor() {
        this.inboundMessageConvertor.setConnection(this.localQueueConnection);
    }

    protected void initializeOutboundJmsMessageConvertor() {
        this.outboundMessageConvertor.setConnection(this.outboundQueueConnection);
    }

    protected void initializeInboundQueueBridges() throws JMSException {
        if (this.inboundQueueBridges != null) {
            QueueSession outboundSession = this.outboundQueueConnection.createQueueSession(false, 1);
            QueueSession localSession = this.localQueueConnection.createQueueSession(false, 1);
            for (int i = 0; i < this.inboundQueueBridges.length; ++i) {
                InboundQueueBridge bridge = this.inboundQueueBridges[i];
                String localQueueName = bridge.getLocalQueueName();
                Queue activemqQueue = this.createActiveMQQueue(localSession, localQueueName);
                String queueName = bridge.getInboundQueueName();
                Queue foreignQueue = this.createForeignQueue(outboundSession, queueName);
                bridge.setConsumerQueue(foreignQueue);
                bridge.setProducerQueue(activemqQueue);
                bridge.setProducerConnection(this.localQueueConnection);
                bridge.setConsumerConnection(this.outboundQueueConnection);
                if (bridge.getJmsMessageConvertor() == null) {
                    bridge.setJmsMessageConvertor(this.getInboundMessageConvertor());
                }
                bridge.setJmsConnector(this);
                this.addInboundBridge(bridge);
            }
            outboundSession.close();
            localSession.close();
        }
    }

    protected void initializeOutboundQueueBridges() throws JMSException {
        if (this.outboundQueueBridges != null) {
            QueueSession outboundSession = this.outboundQueueConnection.createQueueSession(false, 1);
            QueueSession localSession = this.localQueueConnection.createQueueSession(false, 1);
            for (int i = 0; i < this.outboundQueueBridges.length; ++i) {
                OutboundQueueBridge bridge = this.outboundQueueBridges[i];
                String localQueueName = bridge.getLocalQueueName();
                Queue activemqQueue = this.createActiveMQQueue(localSession, localQueueName);
                String queueName = bridge.getOutboundQueueName();
                Queue foreignQueue = this.createForeignQueue(outboundSession, queueName);
                bridge.setConsumerQueue(activemqQueue);
                bridge.setProducerQueue(foreignQueue);
                bridge.setProducerConnection(this.outboundQueueConnection);
                bridge.setConsumerConnection(this.localQueueConnection);
                if (bridge.getJmsMessageConvertor() == null) {
                    bridge.setJmsMessageConvertor(this.getOutboundMessageConvertor());
                }
                bridge.setJmsConnector(this);
                this.addOutboundBridge(bridge);
            }
            outboundSession.close();
            localSession.close();
        }
    }

    protected Destination createReplyToBridge(Destination destination, Connection replyToProducerConnection, Connection replyToConsumerConnection) {
        Queue replyToProducerQueue = (Queue)destination;
        boolean isInbound = replyToProducerConnection.equals(this.localQueueConnection);
        if (isInbound) {
            InboundQueueBridge bridge = (InboundQueueBridge)this.replyToBridges.get(replyToProducerQueue);
            if (bridge == null) {
                bridge = new InboundQueueBridge(){

                    protected Destination processReplyToDestination(Destination destination) {
                        return null;
                    }
                };
                try {
                    QueueSession replyToConsumerSession = ((QueueConnection)replyToConsumerConnection).createQueueSession(false, 1);
                    TemporaryQueue replyToConsumerQueue = replyToConsumerSession.createTemporaryQueue();
                    replyToConsumerSession.close();
                    bridge.setConsumerQueue(replyToConsumerQueue);
                    bridge.setProducerQueue(replyToProducerQueue);
                    bridge.setProducerConnection((QueueConnection)replyToProducerConnection);
                    bridge.setConsumerConnection((QueueConnection)replyToConsumerConnection);
                    bridge.setDoHandleReplyTo(false);
                    if (bridge.getJmsMessageConvertor() == null) {
                        bridge.setJmsMessageConvertor(this.getInboundMessageConvertor());
                    }
                    bridge.setJmsConnector(this);
                    bridge.start();
                    LOG.info((Object)("Created replyTo bridge for " + replyToProducerQueue));
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to create replyTo bridge for queue: " + replyToProducerQueue), (Throwable)e);
                    return null;
                }
                this.replyToBridges.put(replyToProducerQueue, bridge);
            }
            return bridge.getConsumerQueue();
        }
        OutboundQueueBridge bridge = (OutboundQueueBridge)this.replyToBridges.get(replyToProducerQueue);
        if (bridge == null) {
            bridge = new OutboundQueueBridge(){

                protected Destination processReplyToDestination(Destination destination) {
                    return null;
                }
            };
            try {
                QueueSession replyToConsumerSession = ((QueueConnection)replyToConsumerConnection).createQueueSession(false, 1);
                TemporaryQueue replyToConsumerQueue = replyToConsumerSession.createTemporaryQueue();
                replyToConsumerSession.close();
                bridge.setConsumerQueue(replyToConsumerQueue);
                bridge.setProducerQueue(replyToProducerQueue);
                bridge.setProducerConnection((QueueConnection)replyToProducerConnection);
                bridge.setConsumerConnection((QueueConnection)replyToConsumerConnection);
                bridge.setDoHandleReplyTo(false);
                if (bridge.getJmsMessageConvertor() == null) {
                    bridge.setJmsMessageConvertor(this.getOutboundMessageConvertor());
                }
                bridge.setJmsConnector(this);
                bridge.start();
                LOG.info((Object)("Created replyTo bridge for " + replyToProducerQueue));
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to create replyTo bridge for queue: " + replyToProducerQueue), (Throwable)e);
                return null;
            }
            this.replyToBridges.put(replyToProducerQueue, bridge);
        }
        return bridge.getConsumerQueue();
    }

    protected Queue createActiveMQQueue(QueueSession session, String queueName) throws JMSException {
        return session.createQueue(queueName);
    }

    protected Queue createForeignQueue(QueueSession session, String queueName) throws JMSException {
        Queue result = null;
        try {
            result = session.createQueue(queueName);
        }
        catch (JMSException e) {
            try {
                result = (Queue)this.jndiOutboundTemplate.lookup(queueName, Queue.class);
            }
            catch (NamingException e1) {
                String errStr = "Failed to look-up Queue for name: " + queueName;
                LOG.error((Object)errStr, (Throwable)e);
                JMSException jmsEx = new JMSException(errStr);
                jmsEx.setLinkedException(e1);
                throw jmsEx;
            }
        }
        return result;
    }
}

