/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.container;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.kaha.ContainerId;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.container.BaseContainerImpl;
import org.apache.activemq.kaha.impl.container.ContainerEntrySet;
import org.apache.activemq.kaha.impl.container.ContainerKeySet;
import org.apache.activemq.kaha.impl.container.ContainerValueCollection;
import org.apache.activemq.kaha.impl.index.Index;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.activemq.kaha.impl.index.VMIndex;
import org.apache.activemq.kaha.impl.index.hash.HashIndex;
import org.apache.activemq.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MapContainerImpl
extends BaseContainerImpl
implements MapContainer {
    private static final Log LOG = LogFactory.getLog(MapContainerImpl.class);
    protected Index index;
    protected Marshaller keyMarshaller = Store.OBJECT_MARSHALLER;
    protected Marshaller valueMarshaller = Store.OBJECT_MARSHALLER;
    protected File directory;
    private int indexBinSize = HashIndex.DEFAULT_BIN_SIZE;
    private int indexKeySize = HashIndex.DEFAULT_KEY_SIZE;
    private int indexPageSize = HashIndex.DEFAULT_PAGE_SIZE;

    public MapContainerImpl(File directory, ContainerId id, IndexItem root, IndexManager indexManager, DataManager dataManager, boolean persistentIndex) {
        super(id, root, indexManager, dataManager, persistentIndex);
        this.directory = directory;
    }

    public synchronized void init() {
        super.init();
        if (this.index == null) {
            if (this.persistentIndex) {
                String name = this.containerId.getDataContainerName() + "_" + this.containerId.getKey();
                name = IOHelper.toFileSystemSafeName(name);
                try {
                    HashIndex hashIndex = new HashIndex(this.directory, name, this.indexManager);
                    hashIndex.setNumberOfBins(this.getIndexBinSize());
                    hashIndex.setKeySize(this.getIndexKeySize());
                    hashIndex.setPageSize(this.getIndexPageSize());
                    this.index = hashIndex;
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to create HashIndex", (Throwable)e);
                    throw new RuntimeException(e);
                }
            } else {
                this.index = new VMIndex(this.indexManager);
            }
        }
        this.index.setKeyMarshaller(this.keyMarshaller);
    }

    public synchronized void load() {
        this.checkClosed();
        if (!this.loaded && !this.loaded) {
            this.loaded = true;
            try {
                this.init();
                this.index.load();
                long nextItem = this.root.getNextItem();
                while (nextItem != -1L) {
                    IndexItem item = this.indexManager.getIndex(nextItem);
                    StoreLocation data = item.getKeyDataItem();
                    Object key = this.dataManager.readItem(this.keyMarshaller, data);
                    if (this.index.isTransient()) {
                        this.index.store(key, item);
                    }
                    this.indexList.add(item);
                    nextItem = item.getNextItem();
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to load container " + this.getId()), (Throwable)e);
                throw new RuntimeStoreException(e);
            }
        }
    }

    public synchronized void unload() {
        this.checkClosed();
        if (this.loaded) {
            this.loaded = false;
            try {
                this.index.unload();
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to unload the index", (Throwable)e);
            }
            this.indexList.clear();
        }
    }

    public synchronized void setKeyMarshaller(Marshaller keyMarshaller) {
        this.checkClosed();
        this.keyMarshaller = keyMarshaller;
        if (this.index != null) {
            this.index.setKeyMarshaller(keyMarshaller);
        }
    }

    public synchronized void setValueMarshaller(Marshaller valueMarshaller) {
        this.checkClosed();
        this.valueMarshaller = valueMarshaller;
    }

    public synchronized int size() {
        this.load();
        return this.indexList.size();
    }

    public synchronized boolean isEmpty() {
        this.load();
        return this.indexList.isEmpty();
    }

    public synchronized boolean containsKey(Object key) {
        this.load();
        try {
            return this.index.containsKey(key);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed trying to find key: " + key), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public synchronized Object get(Object key) {
        this.load();
        Object result = null;
        StoreEntry item = null;
        try {
            item = this.index.get(key);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed trying to get key: " + key), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (item != null) {
            result = this.getValue(item);
        }
        return result;
    }

    public synchronized StoreEntry getEntry(Object key) {
        this.load();
        StoreEntry item = null;
        try {
            item = this.index.get(key);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed trying to get key: " + key), (Throwable)e);
            throw new RuntimeException(e);
        }
        return item;
    }

    public synchronized boolean containsValue(Object o) {
        this.load();
        boolean result = false;
        if (o != null) {
            IndexItem item = this.indexList.getFirst();
            while (item != null) {
                Object value = this.getValue(item);
                if (value != null && value.equals(o)) {
                    result = true;
                    break;
                }
                item = this.indexList.getNextEntry(item);
            }
        }
        return result;
    }

    public synchronized void putAll(Map t) {
        this.load();
        if (t != null) {
            for (Map.Entry entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public synchronized Set keySet() {
        this.load();
        return new ContainerKeySet(this);
    }

    public synchronized Collection values() {
        this.load();
        return new ContainerValueCollection(this);
    }

    public synchronized Set entrySet() {
        this.load();
        return new ContainerEntrySet(this);
    }

    public synchronized Object put(Object key, Object value) {
        this.load();
        Object result = this.remove(key);
        IndexItem item = this.write(key, value);
        try {
            this.index.store(key, item);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed trying to insert key: " + key), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.indexList.add(item);
        return result;
    }

    public synchronized Object remove(Object key) {
        this.load();
        try {
            Object result = null;
            IndexItem item = (IndexItem)this.index.remove(key);
            if (item != null) {
                item = (IndexItem)this.indexList.refreshEntry(item);
                result = this.getValue(item);
                IndexItem prev = this.indexList.getPrevEntry(item);
                IndexItem next = this.indexList.getNextEntry(item);
                this.indexList.remove(item);
                this.delete(item, prev, next);
            }
            return result;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed trying to remove key: " + key), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public synchronized boolean removeValue(Object o) {
        this.load();
        boolean result = false;
        if (o != null) {
            IndexItem item = this.indexList.getFirst();
            while (item != null) {
                Object value = this.getValue(item);
                if (value != null && value.equals(o)) {
                    result = true;
                    Object key = this.getKey(item);
                    if (key == null) break;
                    this.remove(key);
                    break;
                }
                item = this.indexList.getNextEntry(item);
            }
        }
        return result;
    }

    protected synchronized void remove(IndexItem item) {
        Object key = this.getKey(item);
        if (key != null) {
            this.remove(key);
        }
    }

    public synchronized void clear() {
        this.checkClosed();
        this.loaded = true;
        this.init();
        if (this.index != null) {
            try {
                this.index.clear();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed trying clear index", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        super.clear();
        this.doClear();
    }

    public synchronized StoreEntry place(Object key, Object value) {
        this.load();
        try {
            this.remove(key);
            IndexItem item = this.write(key, value);
            this.index.store(key, item);
            this.indexList.add(item);
            return item;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed trying to place key: " + key), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public synchronized void remove(StoreEntry entry) {
        this.load();
        IndexItem item = (IndexItem)entry;
        if (item != null) {
            Object key = this.getKey(item);
            try {
                this.index.remove(key);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed trying to remove entry: " + entry), (Throwable)e);
                throw new RuntimeException(e);
            }
            IndexItem prev = this.indexList.getPrevEntry(item);
            IndexItem next = this.indexList.getNextEntry(item);
            this.indexList.remove(item);
            this.delete(item, prev, next);
        }
    }

    public synchronized StoreEntry getFirst() {
        this.load();
        return this.indexList.getFirst();
    }

    public synchronized StoreEntry getLast() {
        this.load();
        return this.indexList.getLast();
    }

    public synchronized StoreEntry getNext(StoreEntry entry) {
        this.load();
        IndexItem item = (IndexItem)entry;
        return this.indexList.getNextEntry(item);
    }

    public synchronized StoreEntry getPrevious(StoreEntry entry) {
        this.load();
        IndexItem item = (IndexItem)entry;
        return this.indexList.getPrevEntry(item);
    }

    public synchronized StoreEntry refresh(StoreEntry entry) {
        this.load();
        return this.indexList.getEntry(entry);
    }

    public synchronized Object getValue(StoreEntry item) {
        this.load();
        Object result = null;
        if (item != null) {
            try {
                StoreLocation data = item.getValueDataItem();
                result = this.dataManager.readItem(this.valueMarshaller, data);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to get value for " + item), (Throwable)e);
                throw new RuntimeStoreException(e);
            }
        }
        return result;
    }

    public synchronized Object getKey(StoreEntry item) {
        this.load();
        Object result = null;
        if (item != null) {
            try {
                StoreLocation data = item.getKeyDataItem();
                result = this.dataManager.readItem(this.keyMarshaller, data);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to get key for " + item), (Throwable)e);
                throw new RuntimeStoreException(e);
            }
        }
        return result;
    }

    protected IndexLinkedList getItemList() {
        return this.indexList;
    }

    protected synchronized IndexItem write(Object key, Object value) {
        IndexItem index = null;
        try {
            IndexItem prev;
            index = this.indexManager.createNewIndex();
            StoreLocation data = this.dataManager.storeDataItem(this.keyMarshaller, key);
            index.setKeyData(data);
            if (value != null) {
                data = this.dataManager.storeDataItem(this.valueMarshaller, value);
                index.setValueData(data);
            }
            prev = (prev = this.indexList.getLast()) != null ? prev : this.indexList.getRoot();
            IndexItem next = this.indexList.getNextEntry(prev);
            prev.setNextItem(index.getOffset());
            index.setPreviousItem(prev.getOffset());
            this.updateIndexes(prev);
            if (next != null) {
                next.setPreviousItem(index.getOffset());
                index.setNextItem(next.getOffset());
                this.updateIndexes(next);
            }
            this.storeIndex(index);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to write " + key + " , " + value), (Throwable)e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    public int getIndexBinSize() {
        return this.indexBinSize;
    }

    public void setIndexBinSize(int indexBinSize) {
        this.indexBinSize = indexBinSize;
    }

    public int getIndexKeySize() {
        return this.indexKeySize;
    }

    public void setIndexKeySize(int indexKeySize) {
        this.indexKeySize = indexKeySize;
    }

    public int getIndexPageSize() {
        return this.indexPageSize;
    }

    public void setIndexPageSize(int indexPageSize) {
        this.indexPageSize = indexPageSize;
    }
}

