/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.DataFile;
import org.apache.activemq.kaha.impl.async.DataFileAppender;

class NIODataFileAppender
extends DataFileAppender {
    public NIODataFileAppender(AsyncDataManager fileManager) {
        super(fileManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueue() {
        DataFile dataFile = null;
        RandomAccessFile file = null;
        FileChannel channel = null;
        try {
            ByteBuffer header = ByteBuffer.allocateDirect(29);
            ByteBuffer footer = ByteBuffer.allocateDirect(3);
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.maxWriteBatchSize);
            header.putInt(0);
            header.put((byte)0);
            header.put(RESERVED_SPACE);
            header.put(AsyncDataManager.ITEM_HEAD_SOR);
            footer.put(AsyncDataManager.ITEM_HEAD_EOR);
            block21: while (true) {
                ByteBuffer source;
                DataFileAppender.WriteCommand write;
                Object o = null;
                Object object = this.enqueueMutex;
                synchronized (object) {
                    while (true) {
                        if (this.shutdown) {
                            o = "SHUTDOWN";
                            break;
                        }
                        if (this.nextWriteBatch != null) {
                            o = this.nextWriteBatch;
                            this.nextWriteBatch = null;
                            break;
                        }
                        this.enqueueMutex.wait();
                    }
                    this.enqueueMutex.notify();
                }
                if (o == "SHUTDOWN") {
                    break;
                }
                DataFileAppender.WriteBatch wb = (DataFileAppender.WriteBatch)o;
                if (dataFile != wb.dataFile) {
                    if (file != null) {
                        dataFile.closeRandomAccessFile(file);
                    }
                    dataFile = wb.dataFile;
                    file = dataFile.openRandomAccessFile(true);
                    channel = file.getChannel();
                }
                file.seek(write.location.getOffset());
                if (wb.size == write.location.getSize()) {
                    header.clear();
                    header.putInt(write.location.getSize());
                    header.put(write.location.getType());
                    header.clear();
                    this.transfer(header, channel);
                    source = ByteBuffer.wrap(write.data.getData(), write.data.getOffset(), write.data.getLength());
                    this.transfer(source, channel);
                    footer.clear();
                    this.transfer(footer, channel);
                } else {
                    for (write = wb.first; write != null; write = (DataFileAppender.WriteCommand)write.getNext()) {
                        header.clear();
                        header.putInt(write.location.getSize());
                        header.put(write.location.getType());
                        header.clear();
                        this.copy(header, buffer);
                        assert (!header.hasRemaining());
                        source = ByteBuffer.wrap(write.data.getData(), write.data.getOffset(), write.data.getLength());
                        this.copy(source, buffer);
                        assert (!source.hasRemaining());
                        footer.clear();
                        this.copy(footer, buffer);
                        assert (!footer.hasRemaining());
                    }
                    buffer.flip();
                    this.transfer(buffer, channel);
                    buffer.clear();
                }
                file.getChannel().force(false);
                DataFileAppender.WriteCommand lastWrite = (DataFileAppender.WriteCommand)wb.first.getTailNode();
                this.dataManager.setLastAppendLocation(lastWrite.location);
                if (wb.latch != null) {
                    wb.latch.countDown();
                }
                write = wb.first;
                while (true) {
                    if (write == null) continue block21;
                    if (!write.sync) {
                        this.inflightWrites.remove(new DataFileAppender.WriteKey(write.location));
                    }
                    write = (DataFileAppender.WriteCommand)write.getNext();
                }
                break;
            }
        }
        catch (IOException e) {
            Object object = this.enqueueMutex;
            synchronized (object) {
                this.firstAsyncException = e;
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            try {
                if (file != null) {
                    dataFile.closeRandomAccessFile(file);
                }
            }
            catch (IOException e) {}
            this.shutdownDone.countDown();
        }
    }

    private void transfer(ByteBuffer header, FileChannel channel) throws IOException {
        while (header.hasRemaining()) {
            channel.write(header);
        }
    }

    private int copy(ByteBuffer src, ByteBuffer dest) {
        int rc = Math.min(dest.remaining(), src.remaining());
        if (rc > 0) {
            int limit = src.limit();
            src.limit(src.position() + rc);
            dest.put(src);
            src.limit(limit);
        }
        return rc;
    }
}

