/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.console.command.AbstractCommand;
import org.apache.activemq.console.formatter.GlobalWriter;

public abstract class AbstractAmqCommand
extends AbstractCommand {
    private URI brokerUrl;
    private ConnectionFactory factory;
    private final List<Connection> connections = new ArrayList<Connection>();

    protected Connection createConnection() throws JMSException {
        if (this.getBrokerUrl() == null) {
            GlobalWriter.printException(new IllegalStateException("You must specify a broker URL to connect to using the --amqurl option."));
            return null;
        }
        if (this.factory == null) {
            this.factory = new ActiveMQConnectionFactory(this.getBrokerUrl());
        }
        Connection conn = this.factory.createConnection();
        this.connections.add(conn);
        return conn;
    }

    protected Connection createConnection(String username, String password) throws JMSException {
        if (this.getBrokerUrl() == null) {
            GlobalWriter.printException(new IllegalStateException("You must specify a broker URL to connect to using the --amqurl option."));
            return null;
        }
        if (this.factory == null) {
            this.factory = new ActiveMQConnectionFactory(this.getBrokerUrl());
        }
        Connection conn = this.factory.createConnection(username, password);
        this.connections.add(conn);
        conn.start();
        return conn;
    }

    protected void closeAllConnections() {
        Iterator<Connection> i = this.connections.iterator();
        while (i.hasNext()) {
            try {
                i.next().close();
            }
            catch (Exception exception) {}
        }
        this.connections.clear();
    }

    protected void handleOption(String token, List tokens) throws Exception {
        if (token.equals("--amqurl")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                GlobalWriter.printException(new IllegalArgumentException("Broker URL not specified."));
                tokens.clear();
                return;
            }
            if (this.getBrokerUrl() != null) {
                GlobalWriter.printException(new IllegalArgumentException("Multiple broker URL cannot be specified."));
                tokens.clear();
                return;
            }
            String strBrokerUrl = (String)tokens.remove(0);
            try {
                this.setBrokerUrl(new URI(strBrokerUrl));
            }
            catch (URISyntaxException e) {
                GlobalWriter.printException(e);
                tokens.clear();
                return;
            }
        } else {
            super.handleOption(token, tokens);
        }
    }

    protected void setBrokerUrl(URI brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    protected void setBrokerUrl(String address) throws URISyntaxException {
        this.brokerUrl = new URI(address);
    }

    protected URI getBrokerUrl() {
        return this.brokerUrl;
    }
}

