/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.broker.region.cursors.FilePendingMessageCursor;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.QueueStorePrefetch;
import org.apache.activemq.command.Message;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.usage.SystemUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreQueueCursor
extends AbstractPendingMessageCursor {
    private static final Log LOG = LogFactory.getLog(StoreQueueCursor.class);
    private int pendingCount;
    private Queue queue;
    private Store tmpStore;
    private PendingMessageCursor nonPersistent;
    private QueueStorePrefetch persistent;
    private boolean started;
    private PendingMessageCursor currentCursor;

    public StoreQueueCursor(Queue queue, Store tmpStore) {
        this.queue = queue;
        this.tmpStore = tmpStore;
        this.persistent = new QueueStorePrefetch(queue);
        this.currentCursor = this.persistent;
    }

    public synchronized void start() throws Exception {
        this.started = true;
        super.start();
        if (this.nonPersistent == null) {
            this.nonPersistent = new FilePendingMessageCursor(this.queue.getDestination(), this.tmpStore);
            this.nonPersistent.setMaxBatchSize(this.getMaxBatchSize());
            this.nonPersistent.setSystemUsage(this.systemUsage);
            this.nonPersistent.setEnableAudit(this.isEnableAudit());
            this.nonPersistent.setMaxAuditDepth(this.getMaxAuditDepth());
            this.nonPersistent.setMaxProducersToAudit(this.getMaxProducersToAudit());
        }
        this.nonPersistent.start();
        this.persistent.start();
        this.pendingCount = this.persistent.size() + this.nonPersistent.size();
    }

    public synchronized void stop() throws Exception {
        this.started = false;
        super.stop();
        if (this.nonPersistent != null) {
            this.nonPersistent.stop();
            this.nonPersistent.gc();
        }
        this.persistent.stop();
        this.persistent.gc();
        this.pendingCount = 0;
    }

    public synchronized void addMessageLast(MessageReference node) throws Exception {
        if (node != null) {
            Message msg = node.getMessage();
            if (this.started) {
                ++this.pendingCount;
                if (!msg.isPersistent()) {
                    this.nonPersistent.addMessageLast(node);
                }
            }
            if (msg.isPersistent()) {
                this.persistent.addMessageLast(node);
            }
        }
    }

    public synchronized void addMessageFirst(MessageReference node) throws Exception {
        if (node != null) {
            Message msg = node.getMessage();
            if (this.started) {
                ++this.pendingCount;
                if (!msg.isPersistent()) {
                    this.nonPersistent.addMessageFirst(node);
                }
            }
            if (msg.isPersistent()) {
                this.persistent.addMessageFirst(node);
            }
        }
    }

    public synchronized void clear() {
        this.pendingCount = 0;
    }

    public synchronized boolean hasNext() {
        boolean result;
        boolean bl = result = this.pendingCount > 0;
        if (result) {
            try {
                this.currentCursor = this.getNextCursor();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to get current cursor ", (Throwable)e);
                throw new RuntimeException(e);
            }
            result = this.currentCursor != null ? this.currentCursor.hasNext() : false;
        }
        return result;
    }

    public synchronized MessageReference next() {
        MessageReference result = this.currentCursor != null ? this.currentCursor.next() : null;
        return result;
    }

    public synchronized void remove() {
        if (this.currentCursor != null) {
            this.currentCursor.remove();
        }
        --this.pendingCount;
    }

    public synchronized void remove(MessageReference node) {
        if (!node.isPersistent()) {
            this.nonPersistent.remove(node);
        } else {
            this.persistent.remove(node);
        }
        --this.pendingCount;
    }

    public synchronized void reset() {
        this.nonPersistent.reset();
        this.persistent.reset();
    }

    public synchronized int size() {
        return this.pendingCount;
    }

    public synchronized boolean isEmpty() {
        return this.pendingCount <= 0;
    }

    public synchronized boolean isRecoveryRequired() {
        return false;
    }

    public synchronized PendingMessageCursor getNonPersistent() {
        return this.nonPersistent;
    }

    public synchronized void setNonPersistent(PendingMessageCursor nonPersistent) {
        this.nonPersistent = nonPersistent;
    }

    public synchronized void setMaxBatchSize(int maxBatchSize) {
        this.persistent.setMaxBatchSize(maxBatchSize);
        if (this.nonPersistent != null) {
            this.nonPersistent.setMaxBatchSize(maxBatchSize);
        }
        super.setMaxBatchSize(maxBatchSize);
    }

    public synchronized void setMaxProducersToAudit(int maxProducersToAudit) {
        super.setMaxProducersToAudit(maxProducersToAudit);
        if (this.persistent != null) {
            this.persistent.setMaxProducersToAudit(maxProducersToAudit);
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.setMaxProducersToAudit(maxProducersToAudit);
        }
    }

    public synchronized void setMaxAuditDepth(int maxAuditDepth) {
        super.setMaxAuditDepth(maxAuditDepth);
        if (this.persistent != null) {
            this.persistent.setMaxAuditDepth(maxAuditDepth);
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.setMaxAuditDepth(maxAuditDepth);
        }
    }

    public synchronized void setEnableAudit(boolean enableAudit) {
        super.setEnableAudit(enableAudit);
        if (this.persistent != null) {
            this.persistent.setEnableAudit(enableAudit);
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.setEnableAudit(enableAudit);
        }
    }

    public synchronized void gc() {
        if (this.persistent != null) {
            this.persistent.gc();
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.gc();
        }
    }

    public synchronized void setSystemUsage(SystemUsage usageManager) {
        super.setSystemUsage(usageManager);
        if (this.persistent != null) {
            this.persistent.setSystemUsage(usageManager);
        }
        if (this.nonPersistent != null) {
            this.nonPersistent.setSystemUsage(usageManager);
        }
    }

    protected synchronized PendingMessageCursor getNextCursor() throws Exception {
        if (this.currentCursor == null || !this.currentCursor.hasMessagesBufferedToDeliver()) {
            PendingMessageCursor pendingMessageCursor = this.currentCursor = this.currentCursor == this.persistent ? this.nonPersistent : this.persistent;
            if (this.currentCursor.isEmpty()) {
                this.currentCursor = this.currentCursor == this.persistent ? this.nonPersistent : this.persistent;
            }
        }
        return this.currentCursor;
    }
}

