/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.BaseDestination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.IndirectMessageReference;
import org.apache.activemq.broker.region.LockOwner;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.MessageReferenceFilter;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.StoreQueueCursor;
import org.apache.activemq.broker.region.cursors.VMPendingMessageCursor;
import org.apache.activemq.broker.region.group.MessageGroupHashBucketFactory;
import org.apache.activemq.broker.region.group.MessageGroupMap;
import org.apache.activemq.broker.region.group.MessageGroupMapFactory;
import org.apache.activemq.broker.region.group.MessageGroupSet;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.RoundRobinDispatchPolicy;
import org.apache.activemq.broker.region.policy.SharedDeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.BrokerSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queue
extends BaseDestination
implements Task {
    final Broker broker;
    private final Log log;
    private final ActiveMQDestination destination;
    private final List<Subscription> consumers = new CopyOnWriteArrayList<Subscription>();
    private final SystemUsage systemUsage;
    private final MemoryUsage memoryUsage;
    private final DestinationStatistics destinationStatistics = new DestinationStatistics();
    private PendingMessageCursor messages;
    private final LinkedList<MessageReference> pagedInMessages = new LinkedList();
    private LockOwner exclusiveOwner;
    private MessageGroupMap messageGroupOwners;
    private int garbageSize;
    private int garbageSizeBeforeCollection = 1000;
    private DispatchPolicy dispatchPolicy = new RoundRobinDispatchPolicy();
    private final MessageStore store;
    private DeadLetterStrategy deadLetterStrategy = new SharedDeadLetterStrategy();
    private MessageGroupMapFactory messageGroupMapFactory = new MessageGroupHashBucketFactory();
    private int maximumPagedInMessages = this.garbageSizeBeforeCollection * 2;
    private final MessageEvaluationContext queueMsgConext = new MessageEvaluationContext();
    private final Object exclusiveLockMutex = new Object();
    private final TaskRunner taskRunner;
    private final LinkedList<Runnable> messagesWaitingForSpace = new LinkedList();
    private final Runnable sendMessagesWaitingForSpaceTask = new Runnable(){

        public void run() {
            try {
                Queue.this.taskRunner.wakeup();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public Queue(Broker broker, ActiveMQDestination destination, SystemUsage systemUsage, MessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory, Store tmpStore) throws Exception {
        this.broker = broker;
        this.destination = destination;
        this.systemUsage = systemUsage;
        this.memoryUsage = new MemoryUsage(systemUsage.getMemoryUsage(), destination.toString());
        this.memoryUsage.setUsagePortion(1.0f);
        this.store = store;
        this.messages = destination.isTemporary() || tmpStore == null ? new VMPendingMessageCursor() : new StoreQueueCursor(this, tmpStore);
        this.taskRunner = taskFactory.createTaskRunner(this, "Queue  " + destination.getPhysicalName());
        if (store != null) {
            store.setMemoryUsage(this.memoryUsage);
        }
        this.destinationStatistics.setEnabled(parentStats.isEnabled());
        this.destinationStatistics.setParent(parentStats);
        this.log = LogFactory.getLog((String)(this.getClass().getName() + "." + destination.getPhysicalName()));
    }

    public void initialize() throws Exception {
        if (this.store != null) {
            this.messages.setSystemUsage(this.systemUsage);
            this.messages.setEnableAudit(this.isEnableAudit());
            this.messages.setMaxAuditDepth(this.getMaxAuditDepth());
            this.messages.setMaxProducersToAudit(this.getMaxProducersToAudit());
            if (this.messages.isRecoveryRequired()) {
                this.store.recover(new MessageRecoveryListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean recoverMessage(Message message) {
                        if (Queue.this.broker.isExpired(message)) {
                            Queue.this.broker.messageExpired(Queue.this.createConnectionContext(), message);
                            Queue.this.destinationStatistics.getMessages().decrement();
                            return true;
                        }
                        if (this.hasSpace()) {
                            message.setRegionDestination(Queue.this);
                            PendingMessageCursor pendingMessageCursor = Queue.this.messages;
                            synchronized (pendingMessageCursor) {
                                try {
                                    Queue.this.messages.addMessageLast(message);
                                }
                                catch (Exception e) {
                                    Queue.this.log.fatal((Object)"Failed to add message to cursor", (Throwable)e);
                                }
                            }
                            Queue.this.destinationStatistics.getMessages().increment();
                            return true;
                        }
                        return false;
                    }

                    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
                        throw new RuntimeException("Should not be called.");
                    }

                    public boolean hasSpace() {
                        return true;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(MessageReference node, LockOwner lockOwner) {
        Object object = this.exclusiveLockMutex;
        synchronized (object) {
            if (this.exclusiveOwner == lockOwner) {
                return true;
            }
            if (this.exclusiveOwner != null) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        sub.add(context, this);
        this.destinationStatistics.getConsumers().increment();
        this.maximumPagedInMessages += sub.getConsumerInfo().getPrefetchSize();
        MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
        try {
            List<Subscription> list = this.consumers;
            synchronized (list) {
                this.consumers.add(sub);
                if (sub.getConsumerInfo().isExclusive()) {
                    LockOwner owner = (LockOwner)((Object)sub);
                    if (this.exclusiveOwner == null) {
                        this.exclusiveOwner = owner;
                    } else if (owner.getLockPriority() > this.exclusiveOwner.getLockPriority()) {
                        this.exclusiveOwner = owner;
                    }
                }
            }
            this.buildList(false);
            msgContext.setDestination(this.destination);
            list = this.pagedInMessages;
            synchronized (list) {
                for (QueueMessageReference queueMessageReference : this.pagedInMessages) {
                    if (queueMessageReference.isDropped() || !sub.getConsumerInfo().isBrowser() && queueMessageReference.getLockOwner() != null) continue;
                    try {
                        msgContext.setMessageReference(queueMessageReference);
                        if (!sub.matches(queueMessageReference, msgContext)) continue;
                        sub.add(queueMessageReference);
                    }
                    catch (IOException e) {
                        this.log.warn((Object)("Could not load message: " + e), (Throwable)e);
                    }
                }
            }
        }
        finally {
            msgContext.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeSubscription(ConnectionContext context, Subscription sub) throws Exception {
        this.destinationStatistics.getConsumers().decrement();
        this.maximumPagedInMessages -= sub.getConsumerInfo().getPrefetchSize();
        List<Subscription> list = this.consumers;
        synchronized (list) {
            LockOwner owner;
            this.consumers.remove(sub);
            if (sub.getConsumerInfo().isExclusive() && this.exclusiveOwner == (owner = (LockOwner)((Object)sub))) {
                this.exclusiveOwner = null;
                for (Subscription s : this.consumers) {
                    LockOwner so = (LockOwner)((Object)s);
                    if (!s.getConsumerInfo().isExclusive() || this.exclusiveOwner != null && so.getLockPriority() <= this.exclusiveOwner.getLockPriority()) continue;
                    this.exclusiveOwner = so;
                }
            }
            if (this.consumers.isEmpty()) {
                this.messages.gc();
            }
        }
        sub.remove(context, this);
        boolean wasExclusiveOwner = false;
        if (this.exclusiveOwner == sub) {
            this.exclusiveOwner = null;
            wasExclusiveOwner = true;
        }
        ConsumerId consumerId = sub.getConsumerInfo().getConsumerId();
        MessageGroupSet ownedGroups = this.getMessageGroupOwners().removeConsumer(consumerId);
        if (!sub.getConsumerInfo().isBrowser()) {
            MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
            try {
                msgContext.setDestination(this.destination);
                ArrayList<QueueMessageReference> messagesToDispatch = new ArrayList<QueueMessageReference>();
                LinkedList<MessageReference> linkedList = this.pagedInMessages;
                synchronized (linkedList) {
                    for (QueueMessageReference queueMessageReference : this.pagedInMessages) {
                        if (queueMessageReference.isDropped()) continue;
                        String groupID = queueMessageReference.getGroupID();
                        if (queueMessageReference.getLockOwner() != sub && !wasExclusiveOwner && (groupID == null || !ownedGroups.contains(groupID))) continue;
                        messagesToDispatch.add(queueMessageReference);
                    }
                }
                for (QueueMessageReference node : messagesToDispatch) {
                    node.incrementRedeliveryCounter();
                    node.unlock();
                    msgContext.setMessageReference(node);
                    this.dispatchPolicy.dispatch(node, msgContext, this.consumers);
                }
            }
            finally {
                msgContext.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(final ProducerBrokerExchange producerExchange, final Message message) throws Exception {
        boolean sendProducerAck;
        final ConnectionContext context = producerExchange.getConnectionContext();
        final ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
        boolean bl = sendProducerAck = !message.isResponseRequired() && producerInfo.getWindowSize() > 0 && !context.isInRecoveryMode();
        if (message.isExpired()) {
            this.broker.messageExpired(context, message);
            this.destinationStatistics.getMessages().decrement();
            if (sendProducerAck) {
                ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                context.getConnection().dispatchAsync(ack);
            }
            return;
        }
        if (this.isProducerFlowControl() && context.isProducerFlowControl() && this.memoryUsage.isFull()) {
            if (this.systemUsage.isSendFailIfNoSpace()) {
                throw new ResourceAllocationException("SystemUsage memory limit reached");
            }
            if (producerInfo.getWindowSize() > 0 || message.isResponseRequired()) {
                LinkedList<Runnable> ack = this.messagesWaitingForSpace;
                synchronized (ack) {
                    this.messagesWaitingForSpace.add(new Runnable(){

                        public void run() {
                            block6: {
                                try {
                                    if (Queue.this.broker.isExpired(message)) {
                                        Queue.this.broker.messageExpired(context, message);
                                        Queue.this.destinationStatistics.getMessages().decrement();
                                    } else {
                                        Queue.this.doMessageSend(producerExchange, message);
                                    }
                                    if (sendProducerAck) {
                                        ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                                        context.getConnection().dispatchAsync(ack);
                                    } else {
                                        Response response = new Response();
                                        response.setCorrelationId(message.getCommandId());
                                        context.getConnection().dispatchAsync(response);
                                    }
                                }
                                catch (Exception e) {
                                    if (sendProducerAck || context.isInRecoveryMode()) break block6;
                                    ExceptionResponse response = new ExceptionResponse(e);
                                    response.setCorrelationId(message.getCommandId());
                                    context.getConnection().dispatchAsync(response);
                                }
                            }
                        }
                    });
                    if (!this.memoryUsage.notifyCallbackWhenNotFull(this.sendMessagesWaitingForSpaceTask)) {
                        this.sendMessagesWaitingForSpaceTask.run();
                    }
                    context.setDontSendReponse(true);
                    return;
                }
            }
            while (!this.memoryUsage.waitForSpace(1000L)) {
                if (!context.getStopping().get()) continue;
                throw new IOException("Connection closed, send aborted.");
            }
            if (message.isExpired()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Expired message: " + message));
                }
                return;
            }
        }
        this.doMessageSend(producerExchange, message);
        if (sendProducerAck) {
            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
            context.getConnection().dispatchAsync(ack);
        }
    }

    synchronized void doMessageSend(ProducerBrokerExchange producerExchange, final Message message) throws IOException, Exception {
        final ConnectionContext context = producerExchange.getConnectionContext();
        message.setRegionDestination(this);
        if (this.store != null && message.isPersistent()) {
            while (!this.systemUsage.getStoreUsage().waitForSpace(1000L)) {
                if (!context.getStopping().get()) continue;
                throw new IOException("Connection closed, send aborted.");
            }
            this.store.addMessage(context, message);
        }
        if (context.isInTransaction()) {
            message.incrementReferenceCount();
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() throws Exception {
                    try {
                        if (Queue.this.broker.isExpired(message)) {
                            Queue.this.broker.messageExpired(context, message);
                            Queue.this.destinationStatistics.getMessages().decrement();
                            return;
                        }
                        Queue.this.sendMessage(context, message);
                    }
                    finally {
                        message.decrementReferenceCount();
                    }
                }

                public void afterRollback() throws Exception {
                    message.decrementReferenceCount();
                }
            });
        } else {
            this.sendMessage(context, message);
        }
    }

    @Override
    public void dispose(ConnectionContext context) throws IOException {
        if (this.store != null) {
            this.store.removeAllMessages(context);
        }
        this.destinationStatistics.setParent(null);
    }

    public void dropEvent() {
        this.dropEvent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropEvent(boolean skipGc) {
        this.destinationStatistics.getMessages().decrement();
        LinkedList<MessageReference> linkedList = this.pagedInMessages;
        synchronized (linkedList) {
            ++this.garbageSize;
        }
        if (!skipGc && this.garbageSize > this.garbageSizeBeforeCollection) {
            this.gc();
        }
        try {
            this.taskRunner.wakeup();
        }
        catch (InterruptedException e) {
            this.log.warn((Object)"Task Runner failed to wakeup ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gc() {
        LinkedList<MessageReference> linkedList = this.pagedInMessages;
        synchronized (linkedList) {
            Iterator i = this.pagedInMessages.iterator();
            while (i.hasNext()) {
                QueueMessageReference node = (QueueMessageReference)i.next();
                if (!node.isDropped()) continue;
                --this.garbageSize;
                i.remove();
            }
        }
    }

    @Override
    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        if (this.store != null && node.isPersistent()) {
            if (ack.getMessageCount() > 0) {
                MessageAck a = new MessageAck();
                ack.copy(a);
                ack = a;
                ack.setFirstMessageId(node.getMessageId());
                ack.setLastMessageId(node.getMessageId());
                ack.setMessageCount(1);
            }
            this.store.removeMessage(context, ack);
        }
    }

    Message loadMessage(MessageId messageId) throws IOException {
        Message msg = this.store.getMessage(messageId);
        if (msg != null) {
            msg.setRegionDestination(this);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int size = 0;
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            size = this.messages.size();
        }
        return "Queue: destination=" + this.destination.getPhysicalName() + ", subscriptions=" + this.consumers.size() + ", memory=" + this.memoryUsage.getPercentUsage() + "%, size=" + size + ", in flight groups=" + this.messageGroupOwners;
    }

    @Override
    public void start() throws Exception {
        if (this.memoryUsage != null) {
            this.memoryUsage.start();
        }
        this.messages.start();
        this.doPageIn(false);
    }

    @Override
    public void stop() throws Exception {
        if (this.taskRunner != null) {
            this.taskRunner.shutdown();
        }
        if (this.messages != null) {
            this.messages.stop();
        }
        if (this.memoryUsage != null) {
            this.memoryUsage.stop();
        }
    }

    @Override
    public ActiveMQDestination getActiveMQDestination() {
        return this.destination;
    }

    public String getDestination() {
        return this.destination.getPhysicalName();
    }

    @Override
    public MemoryUsage getBrokerMemoryUsage() {
        return this.memoryUsage;
    }

    @Override
    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    public MessageGroupMap getMessageGroupOwners() {
        if (this.messageGroupOwners == null) {
            this.messageGroupOwners = this.getMessageGroupMapFactory().createMessageGroupMap();
        }
        return this.messageGroupOwners;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    @Override
    public DeadLetterStrategy getDeadLetterStrategy() {
        return this.deadLetterStrategy;
    }

    public void setDeadLetterStrategy(DeadLetterStrategy deadLetterStrategy) {
        this.deadLetterStrategy = deadLetterStrategy;
    }

    public MessageGroupMapFactory getMessageGroupMapFactory() {
        return this.messageGroupMapFactory;
    }

    public void setMessageGroupMapFactory(MessageGroupMapFactory messageGroupMapFactory) {
        this.messageGroupMapFactory = messageGroupMapFactory;
    }

    @Override
    public String getName() {
        return this.getActiveMQDestination().getPhysicalName();
    }

    public PendingMessageCursor getMessages() {
        return this.messages;
    }

    public void setMessages(PendingMessageCursor messages) {
        this.messages = messages;
    }

    private MessageReference createMessageReference(Message message) {
        IndirectMessageReference result = new IndirectMessageReference(this, this.store, message);
        result.decrementReferenceCount();
        return result;
    }

    @Override
    public MessageStore getMessageStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message[] browse() {
        ArrayList<Message> l = new ArrayList<Message>();
        try {
            this.doPageIn(true);
        }
        catch (Exception e) {
            this.log.error((Object)("caught an exception browsing " + this), (Throwable)e);
        }
        Object object = this.pagedInMessages;
        synchronized (object) {
            for (MessageReference r : this.pagedInMessages) {
                r.incrementReferenceCount();
                try {
                    Message m = r.getMessage();
                    if (m == null) continue;
                    l.add(m);
                }
                catch (IOException e) {
                    this.log.error((Object)("caught an exception browsing " + this), (Throwable)e);
                }
                finally {
                    r.decrementReferenceCount();
                }
            }
        }
        object = this.messages;
        synchronized (object) {
            try {
                this.messages.reset();
                while (this.messages.hasNext()) {
                    try {
                        MessageReference r = this.messages.next();
                        r.incrementReferenceCount();
                        try {
                            Message m = r.getMessage();
                            if (m == null) continue;
                            l.add(m);
                        }
                        finally {
                            r.decrementReferenceCount();
                        }
                    }
                    catch (IOException e) {
                        this.log.error((Object)("caught an exception brwsing " + this), (Throwable)e);
                    }
                }
            }
            finally {
                this.messages.release();
            }
        }
        return l.toArray(new Message[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Message getMessage(String messageId) {
        PendingMessageCursor pendingMessageCursor = this.messages;
        // MONITORENTER : pendingMessageCursor
        try {
            this.messages.reset();
            while (this.messages.hasNext()) {
                try {
                    MessageReference r;
                    block12: {
                        Message message;
                        r = this.messages.next();
                        if (!messageId.equals(r.getMessageId().toString())) continue;
                        r.incrementReferenceCount();
                        try {
                            Message m = r.getMessage();
                            if (m == null) break block12;
                            message = m;
                            r.decrementReferenceCount();
                        }
                        catch (Throwable throwable) {
                            r.decrementReferenceCount();
                            throw throwable;
                        }
                        return message;
                    }
                    r.decrementReferenceCount();
                    return null;
                }
                catch (IOException e) {
                    this.log.error((Object)("got an exception retrieving message " + messageId));
                }
            }
            return null;
        }
        finally {
            this.messages.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() throws Exception {
        this.pageInMessages();
        LinkedList<MessageReference> linkedList = this.pagedInMessages;
        synchronized (linkedList) {
            ConnectionContext c = this.createConnectionContext();
            Iterator i = this.pagedInMessages.iterator();
            while (i.hasNext()) {
                try {
                    QueueMessageReference r = (QueueMessageReference)i.next();
                    if (!r.lock(LockOwner.HIGH_PRIORITY_LOCK_OWNER)) continue;
                    MessageAck ack = new MessageAck();
                    ack.setAckType((byte)2);
                    ack.setDestination(this.destination);
                    ack.setMessageID(r.getMessageId());
                    this.acknowledge(c, null, ack, r);
                    r.drop();
                    this.dropEvent(true);
                }
                catch (IOException e) {}
            }
            this.gc();
        }
    }

    public boolean removeMessage(String messageId) throws Exception {
        return this.removeMatchingMessages(this.createMessageIdFilter(messageId), 1) > 0;
    }

    public int removeMatchingMessages(String selector) throws Exception {
        return this.removeMatchingMessages(selector, -1);
    }

    public int removeMatchingMessages(String selector, int maximumMessages) throws Exception {
        return this.removeMatchingMessages(this.createSelectorFilter(selector), maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeMatchingMessages(MessageReferenceFilter filter, int maximumMessages) throws Exception {
        this.pageInMessages();
        int counter = 0;
        LinkedList<MessageReference> linkedList = this.pagedInMessages;
        synchronized (linkedList) {
            ConnectionContext c = this.createConnectionContext();
            for (IndirectMessageReference indirectMessageReference : this.pagedInMessages) {
                if (!filter.evaluate(c, indirectMessageReference)) continue;
                this.removeMessage(c, indirectMessageReference);
                if (++counter < maximumMessages || maximumMessages <= 0) continue;
                break;
            }
        }
        return counter;
    }

    public boolean copyMessageTo(ConnectionContext context, String messageId, ActiveMQDestination dest) throws Exception {
        return this.copyMatchingMessages(context, this.createMessageIdFilter(messageId), dest, 1) > 0;
    }

    public int copyMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest) throws Exception {
        return this.copyMatchingMessagesTo(context, selector, dest, -1);
    }

    public int copyMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest, int maximumMessages) throws Exception {
        return this.copyMatchingMessages(context, this.createSelectorFilter(selector), dest, maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyMatchingMessages(ConnectionContext context, MessageReferenceFilter filter, ActiveMQDestination dest, int maximumMessages) throws Exception {
        this.pageInMessages();
        int counter = 0;
        LinkedList<MessageReference> linkedList = this.pagedInMessages;
        synchronized (linkedList) {
            for (MessageReference r : this.pagedInMessages) {
                if (!filter.evaluate(context, r)) continue;
                r.incrementReferenceCount();
                try {
                    Message m = r.getMessage();
                    BrokerSupport.resend(context, m, dest);
                    if (++counter < maximumMessages || maximumMessages <= 0) continue;
                    break;
                }
                finally {
                    r.decrementReferenceCount();
                }
            }
        }
        return counter;
    }

    public boolean moveMessageTo(ConnectionContext context, String messageId, ActiveMQDestination dest) throws Exception {
        return this.moveMatchingMessagesTo(context, this.createMessageIdFilter(messageId), dest, 1) > 0;
    }

    public int moveMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest) throws Exception {
        return this.moveMatchingMessagesTo(context, selector, dest, -1);
    }

    public int moveMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest, int maximumMessages) throws Exception {
        return this.moveMatchingMessagesTo(context, this.createSelectorFilter(selector), dest, maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveMatchingMessagesTo(ConnectionContext context, MessageReferenceFilter filter, ActiveMQDestination dest, int maximumMessages) throws Exception {
        this.pageInMessages();
        int counter = 0;
        LinkedList<MessageReference> linkedList = this.pagedInMessages;
        synchronized (linkedList) {
            for (IndirectMessageReference indirectMessageReference : this.pagedInMessages) {
                if (!filter.evaluate(context, indirectMessageReference) || !this.lockMessage(indirectMessageReference)) continue;
                indirectMessageReference.incrementReferenceCount();
                try {
                    Message m = indirectMessageReference.getMessage();
                    BrokerSupport.resend(context, m, dest);
                    this.removeMessage(context, indirectMessageReference);
                    if (++counter < maximumMessages || maximumMessages <= 0) continue;
                    break;
                }
                finally {
                    indirectMessageReference.decrementReferenceCount();
                }
            }
        }
        return counter;
    }

    @Override
    public boolean iterate() {
        while (!this.memoryUsage.isFull() && !this.messagesWaitingForSpace.isEmpty()) {
            Runnable op = this.messagesWaitingForSpace.removeFirst();
            op.run();
        }
        try {
            this.pageInMessages(false);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to page in more queue messages ", (Throwable)e);
        }
        return false;
    }

    protected MessageReferenceFilter createMessageIdFilter(final String messageId) {
        return new MessageReferenceFilter(){

            public boolean evaluate(ConnectionContext context, MessageReference r) {
                return messageId.equals(r.getMessageId().toString());
            }
        };
    }

    protected MessageReferenceFilter createSelectorFilter(String selector) throws InvalidSelectorException {
        final BooleanExpression selectorExpression = new SelectorParser().parse(selector);
        return new MessageReferenceFilter(){

            public boolean evaluate(ConnectionContext context, MessageReference r) throws JMSException {
                MessageEvaluationContext messageEvaluationContext = context.getMessageEvaluationContext();
                messageEvaluationContext.setMessageReference(r);
                if (messageEvaluationContext.getDestination() == null) {
                    messageEvaluationContext.setDestination(Queue.this.getActiveMQDestination());
                }
                return selectorExpression.matches(messageEvaluationContext);
            }
        };
    }

    protected void removeMessage(ConnectionContext c, IndirectMessageReference r) throws IOException {
        MessageAck ack = new MessageAck();
        ack.setAckType((byte)2);
        ack.setDestination(this.destination);
        ack.setMessageID(r.getMessageId());
        this.acknowledge(c, null, ack, r);
        r.drop();
        this.dropEvent();
    }

    protected boolean lockMessage(IndirectMessageReference r) {
        return r.lock(LockOwner.HIGH_PRIORITY_LOCK_OWNER);
    }

    protected ConnectionContext createConnectionContext() {
        ConnectionContext answer = new ConnectionContext();
        answer.getMessageEvaluationContext().setDestination(this.getActiveMQDestination());
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendMessage(ConnectionContext context, Message msg) throws Exception {
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            this.messages.addMessageLast(msg);
        }
        this.destinationStatistics.getEnqueues().increment();
        this.destinationStatistics.getMessages().increment();
        this.pageInMessages(false);
    }

    private List<MessageReference> doPageIn(boolean force) throws Exception {
        List<MessageReference> result = null;
        result = this.buildList(force);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<MessageReference> buildList(boolean force) throws Exception {
        int toPageIn = this.maximumPagedInMessages - this.pagedInMessages.size();
        ArrayList<MessageReference> result = null;
        if ((force || !this.consumers.isEmpty()) && toPageIn > 0) {
            this.messages.setMaxBatchSize(toPageIn);
            try {
                int count = 0;
                result = new ArrayList<MessageReference>(toPageIn);
                Object object = this.messages;
                synchronized (object) {
                    try {
                        this.messages.reset();
                        while (this.messages.hasNext() && count < toPageIn) {
                            MessageReference node = this.messages.next();
                            this.messages.remove();
                            if (!this.broker.isExpired(node)) {
                                node = this.createMessageReference(node.getMessage());
                                result.add(node);
                                ++count;
                                continue;
                            }
                            this.broker.messageExpired(this.createConnectionContext(), node);
                            this.destinationStatistics.getMessages().decrement();
                        }
                    }
                    finally {
                        this.messages.release();
                    }
                }
                object = this.pagedInMessages;
                synchronized (object) {
                    this.pagedInMessages.addAll(result);
                }
            }
            finally {
                this.queueMsgConext.clear();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doDispatch(List<MessageReference> list) throws Exception {
        if (list != null && !list.isEmpty()) {
            try {
                for (int i = 0; i < list.size(); ++i) {
                    MessageReference node = list.get(i);
                    this.queueMsgConext.setDestination(this.destination);
                    this.queueMsgConext.setMessageReference(node);
                    this.dispatchPolicy.dispatch(node, this.queueMsgConext, this.consumers);
                }
            }
            finally {
                this.queueMsgConext.clear();
            }
        }
    }

    private void pageInMessages() throws Exception {
        this.pageInMessages(true);
    }

    private void pageInMessages(boolean force) throws Exception {
        this.doDispatch(this.doPageIn(force));
    }
}

