/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.InvalidSelectorException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.PrefetchSubscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.StoreDurableSubscriberCursor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurableTopicSubscription
extends PrefetchSubscription
implements UsageListener {
    private static final Log LOG = LogFactory.getLog(DurableTopicSubscription.class);
    private final ConcurrentHashMap<MessageId, Integer> redeliveredMessages = new ConcurrentHashMap();
    private final ConcurrentHashMap<ActiveMQDestination, Destination> destinations = new ConcurrentHashMap();
    private final SubscriptionKey subscriptionKey;
    private final boolean keepDurableSubsActive;
    private boolean active;

    public DurableTopicSubscription(Broker broker, SystemUsage usageManager, ConnectionContext context, ConsumerInfo info, boolean keepDurableSubsActive) throws InvalidSelectorException {
        super(broker, usageManager, context, info);
        this.pending = new StoreDurableSubscriberCursor(context.getClientId(), info.getSubscriptionName(), broker.getTempDataStore(), info.getPrefetchSize(), this);
        this.pending.setSystemUsage(usageManager);
        this.keepDurableSubsActive = keepDurableSubsActive;
        this.subscriptionKey = new SubscriptionKey(context.getClientId(), info.getSubscriptionName());
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    protected synchronized boolean isFull() {
        return !this.active || super.isFull();
    }

    public synchronized void gc() {
    }

    public synchronized void add(ConnectionContext context, Destination destination) throws Exception {
        super.add(context, destination);
        this.destinations.put(destination.getActiveMQDestination(), destination);
        if (this.active || this.keepDurableSubsActive) {
            Topic topic = (Topic)destination;
            topic.activate(context, this);
            if (this.pending.isEmpty(topic)) {
                topic.recoverRetroactiveMessages(context, this);
            }
        }
        this.dispatchMatched();
    }

    public synchronized void activate(SystemUsage memoryManager, ConnectionContext context, ConsumerInfo info) throws Exception {
        LOG.debug((Object)("Activating " + this));
        if (!this.active) {
            this.active = true;
            this.context = context;
            this.info = info;
            if (!this.keepDurableSubsActive) {
                for (Topic topic : this.destinations.values()) {
                    topic.activate(context, this);
                }
            }
            this.pending.setSystemUsage(memoryManager);
            this.pending.start();
            if (this.pending.isEmpty()) {
                for (Topic topic : this.destinations.values()) {
                    topic.recoverRetroactiveMessages(context, this);
                }
            }
            this.dispatchMatched();
            this.usageManager.getMemoryUsage().addUsageListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deactivate(boolean keepDurableSubsActive) throws Exception {
        this.active = false;
        this.usageManager.getMemoryUsage().removeUsageListener(this);
        PendingMessageCursor pendingMessageCursor = this.pending;
        synchronized (pendingMessageCursor) {
            this.pending.stop();
        }
        if (!keepDurableSubsActive) {
            for (Topic topic : this.destinations.values()) {
                topic.deactivate(this.context, this);
            }
        }
        for (MessageReference messageReference : this.dispatched) {
            Integer count = this.redeliveredMessages.get(messageReference.getMessageId());
            if (count != null) {
                this.redeliveredMessages.put(messageReference.getMessageId(), count + 1);
            } else {
                this.redeliveredMessages.put(messageReference.getMessageId(), 1);
            }
            if (keepDurableSubsActive && this.pending.isTransient()) {
                PendingMessageCursor pendingMessageCursor2 = this.pending;
                synchronized (pendingMessageCursor2) {
                    this.pending.addMessageFirst(messageReference);
                    continue;
                }
            }
            messageReference.decrementReferenceCount();
        }
        this.dispatched.clear();
        if (!keepDurableSubsActive && this.pending.isTransient()) {
            pendingMessageCursor = this.pending;
            synchronized (pendingMessageCursor) {
                try {
                    this.pending.reset();
                    while (this.pending.hasNext()) {
                        MessageReference messageReference = this.pending.next();
                        messageReference.decrementReferenceCount();
                        this.pending.remove();
                    }
                }
                finally {
                    this.pending.release();
                }
            }
        }
        this.prefetchExtension = 0;
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        MessageDispatch md = super.createMessageDispatch(node, message);
        Integer count = this.redeliveredMessages.get(node.getMessageId());
        if (count != null) {
            md.setRedeliveryCounter(count);
        }
        return md;
    }

    public synchronized void add(MessageReference node) throws Exception {
        if (!this.active && !this.keepDurableSubsActive) {
            return;
        }
        node.incrementReferenceCount();
        super.add(node);
    }

    protected synchronized void doAddRecoveredMessage(MessageReference message) throws Exception {
        this.pending.addRecoveredMessage(message);
    }

    public synchronized int getPendingQueueSize() {
        if (this.active || this.keepDurableSubsActive) {
            return super.getPendingQueueSize();
        }
        return 0;
    }

    public void setSelector(String selector) throws InvalidSelectorException {
        throw new UnsupportedOperationException("You cannot dynamically change the selector for durable topic subscriptions");
    }

    protected synchronized boolean canDispatch(MessageReference node) {
        return this.active;
    }

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference node) throws IOException {
        node.getRegionDestination().acknowledge(context, this, ack, node);
        this.redeliveredMessages.remove(node.getMessageId());
        node.decrementReferenceCount();
    }

    public String getSubscriptionName() {
        return this.subscriptionKey.getSubscriptionName();
    }

    public synchronized String toString() {
        return "DurableTopicSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", total=" + this.enqueueCounter + ", pending=" + this.getPendingQueueSize() + ", dispatched=" + this.dispatchCounter + ", inflight=" + this.dispatched.size() + ", prefetchExtension=" + this.prefetchExtension;
    }

    public String getClientId() {
        return this.subscriptionKey.getClientId();
    }

    public SubscriptionKey getSubscriptionKey() {
        return this.subscriptionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        try {
            PendingMessageCursor pendingMessageCursor = this.pending;
            synchronized (pendingMessageCursor) {
                this.pending.reset();
                while (this.pending.hasNext()) {
                    MessageReference node = this.pending.next();
                    node.decrementReferenceCount();
                }
            }
        }
        finally {
            this.pending.release();
            this.pending.clear();
        }
        for (MessageReference node : this.dispatched) {
            node.decrementReferenceCount();
        }
        this.dispatched.clear();
    }

    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        if (oldPercentUsage > newPercentUsage && oldPercentUsage >= 90) {
            try {
                this.dispatchMatched();
            }
            catch (IOException e) {
                LOG.warn((Object)"problem calling dispatchMatched", (Throwable)e);
            }
        }
    }
}

