/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import org.apache.activemq.management.CountStatisticImpl;
import org.apache.activemq.management.PollCountStatisticImpl;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.management.TimeStatisticImpl;

public class DestinationStatistics
extends StatsImpl {
    protected CountStatisticImpl enqueues = new CountStatisticImpl("enqueues", "The number of messages that have been sent to the destination");
    protected CountStatisticImpl dequeues;
    protected CountStatisticImpl consumers;
    protected CountStatisticImpl messages;
    protected PollCountStatisticImpl messagesCached;
    protected CountStatisticImpl dispatched = new CountStatisticImpl("dispatched", "The number of messages that have been dispatched from the destination");
    protected TimeStatisticImpl processTime;

    public DestinationStatistics() {
        this.dequeues = new CountStatisticImpl("dequeues", "The number of messages that have been acknowledged from the destination");
        this.consumers = new CountStatisticImpl("consumers", "The number of consumers that that are subscribing to messages from the destination");
        this.messages = new CountStatisticImpl("messages", "The number of messages that that are being held by the destination");
        this.messagesCached = new PollCountStatisticImpl("messagesCached", "The number of messages that are held in the destination's memory cache");
        this.processTime = new TimeStatisticImpl("processTime", "information around length of time messages are held by a destination");
        this.addStatistic("enqueues", this.enqueues);
        this.addStatistic("dispatched", this.dispatched);
        this.addStatistic("dequeues", this.dequeues);
        this.addStatistic("consumers", this.consumers);
        this.addStatistic("messages", this.messages);
        this.addStatistic("messagesCached", this.messagesCached);
        this.addStatistic("processTime", this.processTime);
    }

    public CountStatisticImpl getEnqueues() {
        return this.enqueues;
    }

    public CountStatisticImpl getDequeues() {
        return this.dequeues;
    }

    public CountStatisticImpl getConsumers() {
        return this.consumers;
    }

    public PollCountStatisticImpl getMessagesCached() {
        return this.messagesCached;
    }

    public CountStatisticImpl getMessages() {
        return this.messages;
    }

    public void setMessagesCached(PollCountStatisticImpl messagesCached) {
        this.messagesCached = messagesCached;
    }

    public CountStatisticImpl getDispatched() {
        return this.dispatched;
    }

    public TimeStatisticImpl getProcessTime() {
        return this.processTime;
    }

    public void reset() {
        super.reset();
        this.enqueues.reset();
        this.dequeues.reset();
        this.dispatched.reset();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enqueues.setEnabled(enabled);
        this.dispatched.setEnabled(enabled);
        this.dequeues.setEnabled(enabled);
        this.consumers.setEnabled(enabled);
        this.messages.setEnabled(enabled);
        this.messagesCached.setEnabled(enabled);
        this.processTime.setEnabled(enabled);
    }

    public void setParent(DestinationStatistics parent) {
        if (parent != null) {
            this.enqueues.setParent(parent.enqueues);
            this.dispatched.setParent(parent.dispatched);
            this.dequeues.setParent(parent.dequeues);
            this.consumers.setParent(parent.consumers);
            this.messagesCached.setParent(parent.messagesCached);
            this.messages.setParent(parent.messages);
            this.processTime.setParent(parent.processTime);
        } else {
            this.enqueues.setParent(null);
            this.dispatched.setParent(null);
            this.dequeues.setParent(null);
            this.consumers.setParent(null);
            this.messagesCached.setParent(null);
            this.messages.setParent(null);
            this.processTime.setParent(null);
        }
    }
}

