/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTempQueue;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;

public final class ActiveMQMessageTransformation {
    private ActiveMQMessageTransformation() {
    }

    public static ActiveMQDestination transformDestination(Destination destination) throws JMSException {
        ActiveMQDestination activeMQDestination = null;
        if (destination != null) {
            if (destination instanceof ActiveMQDestination) {
                return (ActiveMQDestination)destination;
            }
            if (destination instanceof TemporaryQueue) {
                activeMQDestination = new ActiveMQTempQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof TemporaryTopic) {
                activeMQDestination = new ActiveMQTempTopic(((Topic)destination).getTopicName());
            } else if (destination instanceof Queue) {
                activeMQDestination = new ActiveMQQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof Topic) {
                activeMQDestination = new ActiveMQTopic(((Topic)destination).getTopicName());
            }
        }
        return activeMQDestination;
    }

    public static ActiveMQMessage transformMessage(Message message, ActiveMQConnection connection) throws JMSException {
        if (message instanceof ActiveMQMessage) {
            return (ActiveMQMessage)message;
        }
        ActiveMQMessage activeMessage = null;
        if (message instanceof BytesMessage) {
            BytesMessage bytesMsg = (BytesMessage)message;
            bytesMsg.reset();
            ActiveMQBytesMessage msg = new ActiveMQBytesMessage();
            msg.setConnection(connection);
            try {
                while (true) {
                    msg.writeByte(bytesMsg.readByte());
                }
            }
            catch (MessageEOFException e) {
            }
            catch (JMSException e) {
                // empty catch block
            }
            activeMessage = msg;
        } else if (message instanceof MapMessage) {
            MapMessage mapMsg = (MapMessage)message;
            ActiveMQMapMessage msg = new ActiveMQMapMessage();
            msg.setConnection(connection);
            Enumeration iter = mapMsg.getMapNames();
            while (iter.hasMoreElements()) {
                String name = iter.nextElement().toString();
                msg.setObject(name, mapMsg.getObject(name));
            }
            activeMessage = msg;
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)message;
            ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
            msg.setConnection(connection);
            msg.setObject(objMsg.getObject());
            msg.storeContent();
            activeMessage = msg;
        } else if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            streamMessage.reset();
            ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
            msg.setConnection(connection);
            Object obj = null;
            try {
                while ((obj = streamMessage.readObject()) != null) {
                    msg.writeObject(obj);
                }
            }
            catch (MessageEOFException e) {
            }
            catch (JMSException e) {
                // empty catch block
            }
            activeMessage = msg;
        } else if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            ActiveMQTextMessage msg = new ActiveMQTextMessage();
            msg.setConnection(connection);
            msg.setText(textMsg.getText());
            activeMessage = msg;
        } else {
            activeMessage = new ActiveMQMessage();
            activeMessage.setConnection(connection);
        }
        ActiveMQMessageTransformation.copyProperties(message, activeMessage);
        return activeMessage;
    }

    public static void copyProperties(Message fromMessage, Message toMesage) throws JMSException {
        toMesage.setJMSMessageID(fromMessage.getJMSMessageID());
        toMesage.setJMSCorrelationID(fromMessage.getJMSCorrelationID());
        toMesage.setJMSReplyTo(ActiveMQMessageTransformation.transformDestination(fromMessage.getJMSReplyTo()));
        toMesage.setJMSDestination(ActiveMQMessageTransformation.transformDestination(fromMessage.getJMSDestination()));
        toMesage.setJMSDeliveryMode(fromMessage.getJMSDeliveryMode());
        toMesage.setJMSRedelivered(fromMessage.getJMSRedelivered());
        toMesage.setJMSType(fromMessage.getJMSType());
        toMesage.setJMSExpiration(fromMessage.getJMSExpiration());
        toMesage.setJMSPriority(fromMessage.getJMSPriority());
        toMesage.setJMSTimestamp(fromMessage.getJMSTimestamp());
        Enumeration propertyNames = fromMessage.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            Object obj = fromMessage.getObjectProperty(name);
            toMesage.setObjectProperty(name, obj);
        }
    }
}

