/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.adapters.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.provider.basic.BasicAdapter;
import org.apache.abdera.protocol.server.provider.managed.FeedConfiguration;
import org.apache.abdera.protocol.server.provider.managed.ServerConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBatisCollectionAdapter
extends BasicAdapter {
    protected Map<String, SqlMapClient> sqlMapClients = new HashMap<String, SqlMapClient>();

    public IBatisCollectionAdapter(Abdera abdera, FeedConfiguration config) {
        super(abdera, config);
    }

    protected SqlMapClient getSqlMapClient() throws Exception {
        String dataSourceId = this.config.getFeedConfigLocation();
        if (this.sqlMapClients.containsKey(dataSourceId)) {
            return this.sqlMapClients.get(dataSourceId);
        }
        SqlMapClient client = SqlMapClientBuilder.buildSqlMapClient((Reader)this.config.getAdapterConfiguration().getAdapterConfigAsReader());
        this.sqlMapClients.put(dataSourceId, client);
        return client;
    }

    @Override
    public Feed getFeed() throws Exception {
        SqlMapClient client = this.getSqlMapClient();
        String queryId = this.config.getFeedId() + "-get-feed";
        List rows = client.queryForList(queryId);
        Feed feed = this.createFeed();
        ServerConfiguration serverConfig = this.config.getServerConfiguration();
        if (serverConfig.getFeedNamespacePrefix() != null && serverConfig.getFeedNamespacePrefix().length() > 0) {
            feed.declareNS(serverConfig.getFeedNamespace(), serverConfig.getFeedNamespacePrefix());
        }
        for (Map row : rows) {
            this.createEntryFromRow(feed, row);
        }
        return feed;
    }

    @Override
    public Entry getEntry(Object entryId) throws Exception {
        String queryId = this.config.getFeedId() + "-get-entry";
        SqlMapClient client = this.getSqlMapClient();
        Map row = (Map)client.queryForObject(queryId, entryId);
        if (row == null) {
            return null;
        }
        return this.createEntryFromRow(null, row);
    }

    @Override
    public Entry createEntry(Entry entry) throws Exception {
        SqlMapClient client = this.getSqlMapClient();
        String queryId = this.config.getFeedId() + "-insert-entry";
        Object newEntryId = client.insert(queryId, this.collectColumns(entry));
        return this.getEntry(newEntryId);
    }

    @Override
    public Entry updateEntry(Object entryId, Entry entry) throws Exception {
        String queryId;
        SqlMapClient client = this.getSqlMapClient();
        return client.update(queryId = this.config.getFeedId() + "-update-entry", this.collectColumns(entry)) > 0 ? this.getEntry(entryId) : null;
    }

    @Override
    public boolean deleteEntry(Object entryId) throws Exception {
        String queryId = this.config.getFeedId() + "-delete-entry";
        SqlMapClient client = this.getSqlMapClient();
        return client.delete(queryId, entryId) > 0;
    }

    protected Entry createEntryFromRow(Feed feed, Map<String, Object> row) throws Exception {
        Entry entry = feed != null ? feed.addEntry() : this.abdera.newEntry();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element entity = doc.createElement("entity");
        doc.appendChild(entity);
        for (String columnName : row.keySet()) {
            if (row.get(columnName) == null) continue;
            Object value = row.get(columnName);
            if ("id".equals(columnName)) {
                entry.setId(this.createEntryIdUri(value.toString()));
                continue;
            }
            if ("title".equals(columnName)) {
                entry.setTitle(value.toString());
                continue;
            }
            if ("author".equals(columnName)) {
                entry.addAuthor(value.toString());
                continue;
            }
            if ("updated".equals(columnName) && value instanceof Date) {
                entry.setUpdated((Date)value);
                continue;
            }
            if ("link".equals(columnName)) {
                entry.addLink(value.toString());
                continue;
            }
            Element node = doc.createElement(columnName);
            node.appendChild(doc.createTextNode(value.toString()));
            entity.appendChild(node);
        }
        if (entry.getUpdated() == null) {
            entry.setUpdated(new Date());
        }
        if (entry.getAuthor() == null) {
            entry.addAuthor(this.config.getFeedAuthor());
        }
        if (entry.getTitle() == null) {
            entry.setTitle((String)this.config.getProperty("entryTitle"));
        }
        entry.setContent(IBatisCollectionAdapter.getDocumentAsXml(doc), "text/xml");
        this.addEditLinkToEntry(entry);
        return entry;
    }

    public static String getDocumentAsXml(Document doc) throws TransformerConfigurationException, TransformerException {
        DOMSource domSource = new DOMSource(doc);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(domSource, sr);
        String str = sw.toString();
        logger.finest(str);
        return str;
    }

    protected Map<String, Object> collectColumns(Entry entry) throws Exception {
        Content content;
        HashMap<String, Object> columns = new HashMap<String, Object>();
        if (entry.getId() != null) {
            columns.put("id", entry.getId().toString());
        }
        if (entry.getAuthor() != null) {
            columns.put("author", entry.getAuthor().getText());
        }
        if (entry.getTitle() != null) {
            columns.put("title", entry.getTitle());
        }
        if (entry.getUpdated() != null) {
            columns.put("updated", entry.getUpdated());
        }
        if ((content = entry.getContentElement()) != null) {
            String contentStr = content.getValue();
            IBatisCollectionAdapter.parseContent(contentStr, columns);
        }
        return columns;
    }

    static void parseContent(String str, Map<String, Object> columns) throws Exception {
        ByteArrayInputStream inStr = new ByteArrayInputStream(str.getBytes());
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory.createXMLStreamReader(inStr);
        while (true) {
            int event;
            if ((event = parser.next()) == 8) break;
            if (event != 1) continue;
            String name = parser.getLocalName();
            int eventType = parser.next();
            if (eventType != 4) continue;
            String value = parser.getText();
            columns.put(name, value);
        }
        parser.close();
    }
}

