/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.annotation.WorkerThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.DetectionTracker;
import org.altbeacon.beacon.service.ExtraDataBeaconTracker;
import org.altbeacon.beacon.service.MonitoringStatus;
import org.altbeacon.beacon.service.RangeState;
import org.altbeacon.beacon.service.RangingData;
import org.altbeacon.beacon.service.Stats;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.service.scanner.CycledLeScanner;
import org.altbeacon.beacon.service.scanner.DistinctPacketDetector;
import org.altbeacon.beacon.service.scanner.NonBeaconLeScanCallback;
import org.altbeacon.beacon.service.scanner.ScanFilterUtils;
import org.altbeacon.beacon.startup.StartupBroadcastReceiver;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

class ScanHelper {
    private static final String TAG = ScanHelper.class.getSimpleName();
    @Nullable
    private ExecutorService mExecutor;
    private BeaconManager mBeaconManager;
    @Nullable
    private CycledLeScanner mCycledScanner;
    private MonitoringStatus mMonitoringStatus;
    private final Map<Region, RangeState> mRangedRegionState = new HashMap<Region, RangeState>();
    private DistinctPacketDetector mDistinctPacketDetector = new DistinctPacketDetector();
    @NonNull
    private ExtraDataBeaconTracker mExtraDataBeaconTracker = new ExtraDataBeaconTracker();
    private Set<BeaconParser> mBeaconParsers = new HashSet<BeaconParser>();
    private List<Beacon> mSimulatedScanData = null;
    private Context mContext;
    private final CycledLeScanCallback mCycledLeScanCallback = new CycledLeScanCallback(){

        @Override
        @TargetApi(value=11)
        @MainThread
        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            ScanHelper.this.processScanResult(device, rssi, scanRecord);
        }

        @Override
        @MainThread
        @SuppressLint(value={"WrongThread"})
        public void onCycleEnd() {
            if (BeaconManager.getBeaconSimulator() != null) {
                LogManager.d(TAG, "Beacon simulator enabled", new Object[0]);
                if (BeaconManager.getBeaconSimulator().getBeacons() != null) {
                    if (0 != (((ScanHelper)ScanHelper.this).mContext.getApplicationInfo().flags &= 2)) {
                        LogManager.d(TAG, "Beacon simulator returns " + BeaconManager.getBeaconSimulator().getBeacons().size() + " beacons.", new Object[0]);
                        for (Beacon beacon : BeaconManager.getBeaconSimulator().getBeacons()) {
                            ScanHelper.this.processBeaconFromScan(beacon);
                        }
                    } else {
                        LogManager.w(TAG, "Beacon simulations provided, but ignored because we are not running in debug mode.  Please remove beacon simulations for production.", new Object[0]);
                    }
                } else {
                    LogManager.w(TAG, "getBeacons is returning null. No simulated beacons to report.", new Object[0]);
                }
            } else if (LogManager.isVerboseLoggingEnabled()) {
                LogManager.d(TAG, "Beacon simulator not enabled", new Object[0]);
            }
            ScanHelper.this.mDistinctPacketDetector.clearDetections();
            ScanHelper.this.mMonitoringStatus.updateNewlyOutside();
            ScanHelper.this.processRangeData();
        }
    };

    ScanHelper(Context context) {
        this.mContext = context;
        this.mBeaconManager = BeaconManager.getInstanceForApplication(context);
    }

    private ExecutorService getExecutor() {
        if (this.mExecutor == null) {
            this.mExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
        }
        return this.mExecutor;
    }

    void terminateThreads() {
        if (this.mExecutor != null) {
            this.mExecutor.shutdown();
            try {
                if (!this.mExecutor.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
                    LogManager.e(TAG, "Can't stop beacon parsing thread.", new Object[0]);
                }
            }
            catch (InterruptedException e) {
                LogManager.e(TAG, "Interrupted waiting to stop beacon parsing thread.", new Object[0]);
            }
            this.mExecutor = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.terminateThreads();
    }

    @Nullable
    CycledLeScanner getCycledScanner() {
        return this.mCycledScanner;
    }

    MonitoringStatus getMonitoringStatus() {
        return this.mMonitoringStatus;
    }

    void setMonitoringStatus(MonitoringStatus monitoringStatus) {
        this.mMonitoringStatus = monitoringStatus;
    }

    Map<Region, RangeState> getRangedRegionState() {
        return this.mRangedRegionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRangedRegionState(Map<Region, RangeState> rangedRegionState) {
        Map<Region, RangeState> map = this.mRangedRegionState;
        synchronized (map) {
            this.mRangedRegionState.clear();
            this.mRangedRegionState.putAll(rangedRegionState);
        }
    }

    void setExtraDataBeaconTracker(@NonNull ExtraDataBeaconTracker extraDataBeaconTracker) {
        this.mExtraDataBeaconTracker = extraDataBeaconTracker;
    }

    void setBeaconParsers(Set<BeaconParser> beaconParsers) {
        this.mBeaconParsers = beaconParsers;
    }

    void setSimulatedScanData(List<Beacon> simulatedScanData) {
        this.mSimulatedScanData = simulatedScanData;
    }

    void createCycledLeScanner(boolean backgroundMode, BluetoothCrashResolver crashResolver) {
        this.mCycledScanner = CycledLeScanner.createScanner(this.mContext, 1100L, 0L, backgroundMode, this.mCycledLeScanCallback, crashResolver);
    }

    @TargetApi(value=11)
    void processScanResult(BluetoothDevice device, int rssi, byte[] scanRecord) {
        NonBeaconLeScanCallback nonBeaconLeScanCallback = this.mBeaconManager.getNonBeaconLeScanCallback();
        try {
            new ScanProcessor(nonBeaconLeScanCallback).executeOnExecutor(this.getExecutor(), new ScanData[]{new ScanData(device, rssi, scanRecord)});
        }
        catch (RejectedExecutionException e) {
            LogManager.w(TAG, "Ignoring scan result because we cannot keep up.", new Object[0]);
        }
        catch (OutOfMemoryError e) {
            LogManager.w(TAG, "Ignoring scan result because we cannot start a thread to keep up.", new Object[0]);
        }
    }

    void reloadParsers() {
        HashSet<BeaconParser> newBeaconParsers = new HashSet<BeaconParser>();
        boolean matchBeaconsByServiceUUID = true;
        newBeaconParsers.addAll(this.mBeaconManager.getBeaconParsers());
        for (BeaconParser beaconParser : this.mBeaconManager.getBeaconParsers()) {
            if (beaconParser.getExtraDataParsers().size() <= 0) continue;
            matchBeaconsByServiceUUID = false;
            newBeaconParsers.addAll(beaconParser.getExtraDataParsers());
        }
        this.mBeaconParsers = newBeaconParsers;
        this.mExtraDataBeaconTracker = new ExtraDataBeaconTracker(matchBeaconsByServiceUUID);
    }

    @RequiresApi(api=26)
    void startAndroidOBackgroundScan(Set<BeaconParser> beaconParsers) {
        ScanSettings settings = new ScanSettings.Builder().setScanMode(0).build();
        List<ScanFilter> filters = new ScanFilterUtils().createScanFiltersForBeaconParsers(new ArrayList<BeaconParser>(beaconParsers));
        try {
            BluetoothManager bluetoothManager = (BluetoothManager)this.mContext.getApplicationContext().getSystemService("bluetooth");
            BluetoothAdapter bluetoothAdapter = bluetoothManager.getAdapter();
            if (bluetoothAdapter == null) {
                LogManager.w(TAG, "Failed to construct a BluetoothAdapter", new Object[0]);
            } else if (!bluetoothAdapter.isEnabled()) {
                LogManager.w(TAG, "Failed to start background scan on Android O: BluetoothAdapter is not enabled", new Object[0]);
            } else {
                BluetoothLeScanner scanner = bluetoothAdapter.getBluetoothLeScanner();
                if (scanner != null) {
                    int result = scanner.startScan(filters, settings, this.getScanCallbackIntent());
                    if (result != 0) {
                        LogManager.e(TAG, "Failed to start background scan on Android O.  Code: " + result, new Object[0]);
                    } else {
                        LogManager.d(TAG, "Started passive beacon scan", new Object[0]);
                    }
                } else {
                    LogManager.e(TAG, "Failed to start background scan on Android O: scanner is null", new Object[0]);
                }
            }
        }
        catch (SecurityException e) {
            LogManager.e(TAG, "SecurityException making Android O background scanner", new Object[0]);
        }
        catch (NullPointerException e) {
            LogManager.e(TAG, "NullPointerException starting Android O background scanner", e);
        }
        catch (RuntimeException e) {
            LogManager.e(TAG, "Unexpected runtime exception starting Android O background scanner", e);
        }
    }

    @RequiresApi(api=26)
    void stopAndroidOBackgroundScan() {
        try {
            BluetoothManager bluetoothManager = (BluetoothManager)this.mContext.getApplicationContext().getSystemService("bluetooth");
            BluetoothAdapter bluetoothAdapter = bluetoothManager.getAdapter();
            if (bluetoothAdapter == null) {
                LogManager.w(TAG, "Failed to construct a BluetoothAdapter", new Object[0]);
            } else if (!bluetoothAdapter.isEnabled()) {
                LogManager.w(TAG, "BluetoothAdapter is not enabled", new Object[0]);
            } else {
                BluetoothLeScanner scanner = bluetoothAdapter.getBluetoothLeScanner();
                if (scanner != null) {
                    scanner.stopScan(this.getScanCallbackIntent());
                }
            }
        }
        catch (SecurityException e) {
            LogManager.e(TAG, "SecurityException stopping Android O background scanner", new Object[0]);
        }
        catch (NullPointerException e) {
            LogManager.e(TAG, "NullPointerException stopping Android O background scanner", e);
        }
        catch (RuntimeException e) {
            LogManager.e(TAG, "Unexpected runtime exception stopping Android O background scanner", e);
        }
    }

    PendingIntent getScanCallbackIntent() {
        Intent intent = new Intent(this.mContext, StartupBroadcastReceiver.class);
        intent.putExtra("o-scan", true);
        return PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    CycledLeScanCallback getCycledLeScanCallback() {
        return this.mCycledLeScanCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRangeData() {
        Map<Region, RangeState> map = this.mRangedRegionState;
        synchronized (map) {
            for (Region region : this.mRangedRegionState.keySet()) {
                RangeState rangeState = this.mRangedRegionState.get(region);
                LogManager.d(TAG, "Calling ranging callback", new Object[0]);
                rangeState.getCallback().call(this.mContext, "rangingData", new RangingData(rangeState.finalizeBeacons(), region).toBundle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void processBeaconFromScan(@NonNull Beacon beacon) {
        if (Stats.getInstance().isEnabled()) {
            Stats.getInstance().log(beacon);
        }
        if (LogManager.isVerboseLoggingEnabled()) {
            LogManager.d(TAG, "beacon detected : %s", beacon.toString());
        }
        if ((beacon = this.mExtraDataBeaconTracker.track(beacon)) == null) {
            if (LogManager.isVerboseLoggingEnabled()) {
                LogManager.d(TAG, "not processing detections for GATT extra data beacon", new Object[0]);
            }
        } else {
            this.mMonitoringStatus.updateNewlyInsideInRegionsContaining(beacon);
            LogManager.d(TAG, "looking for ranging region matches for this beacon", new Object[0]);
            Map<Region, RangeState> map = this.mRangedRegionState;
            synchronized (map) {
                List<Region> matchedRegions = this.matchingRegions(beacon, this.mRangedRegionState.keySet());
                for (Region region : matchedRegions) {
                    LogManager.d(TAG, "matches ranging region: %s", region);
                    RangeState rangeState = this.mRangedRegionState.get(region);
                    if (rangeState == null) continue;
                    rangeState.addBeacon(beacon);
                }
            }
        }
    }

    private List<Region> matchingRegions(Beacon beacon, Collection<Region> regions) {
        ArrayList<Region> matched = new ArrayList<Region>();
        for (Region region : regions) {
            if (region == null) continue;
            if (region.matchesBeacon(beacon)) {
                matched.add(region);
                continue;
            }
            LogManager.d(TAG, "This region (%s) does not match beacon: %s", region, beacon);
        }
        return matched;
    }

    private class ScanProcessor
    extends AsyncTask<ScanData, Void, Void> {
        final DetectionTracker mDetectionTracker = DetectionTracker.getInstance();
        private final NonBeaconLeScanCallback mNonBeaconLeScanCallback;

        ScanProcessor(NonBeaconLeScanCallback nonBeaconLeScanCallback) {
            this.mNonBeaconLeScanCallback = nonBeaconLeScanCallback;
        }

        @WorkerThread
        protected Void doInBackground(ScanData ... params) {
            BeaconParser parser;
            ScanData scanData = params[0];
            Beacon beacon = null;
            Iterator iterator = ScanHelper.this.mBeaconParsers.iterator();
            while (iterator.hasNext() && (beacon = (parser = (BeaconParser)iterator.next()).fromScanData(scanData.scanRecord, scanData.rssi, scanData.device)) == null) {
            }
            if (beacon != null) {
                if (LogManager.isVerboseLoggingEnabled()) {
                    LogManager.d(TAG, "Beacon packet detected for: " + beacon + " with rssi " + beacon.getRssi(), new Object[0]);
                }
                this.mDetectionTracker.recordDetection();
                if (ScanHelper.this.mCycledScanner != null && !ScanHelper.this.mCycledScanner.getDistinctPacketsDetectedPerScan() && !ScanHelper.this.mDistinctPacketDetector.isPacketDistinct(scanData.device.getAddress(), scanData.scanRecord)) {
                    LogManager.i(TAG, "Non-distinct packets detected in a single scan.  Restarting scans unecessary.", new Object[0]);
                    ScanHelper.this.mCycledScanner.setDistinctPacketsDetectedPerScan(true);
                }
                ScanHelper.this.processBeaconFromScan(beacon);
            } else if (this.mNonBeaconLeScanCallback != null) {
                this.mNonBeaconLeScanCallback.onNonBeaconLeScan(scanData.device, scanData.rssi, scanData.scanRecord);
            }
            return null;
        }

        protected void onPostExecute(Void result) {
        }

        protected void onPreExecute() {
        }

        protected void onProgressUpdate(Void ... values) {
        }
    }

    private class ScanData {
        final int rssi;
        @NonNull
        BluetoothDevice device;
        @NonNull
        byte[] scanRecord;

        ScanData(BluetoothDevice device, @NonNull int rssi, byte[] scanRecord) {
            this.device = device;
            this.rssi = rssi;
            this.scanRecord = scanRecord;
        }
    }
}

