/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.grgit.auth;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.time.MonotonicClock;

public class GrgitSystemReader
extends SystemReader {
    private static final Pattern PATH_SPLITTER = Pattern.compile(Pattern.quote(File.pathSeparator));
    private final SystemReader delegate;
    private final String gitSsh;

    public GrgitSystemReader(SystemReader delegate, String gitSsh) {
        this.delegate = delegate;
        this.gitSsh = gitSsh;
    }

    public String getHostname() {
        return this.delegate.getHostname();
    }

    public String getenv(String variable) {
        String value = this.delegate.getenv(variable);
        if ("GIT_SSH".equals(variable) && value == null) {
            return this.gitSsh;
        }
        return value;
    }

    public String getProperty(String key) {
        return this.delegate.getProperty(key);
    }

    public FileBasedConfig openUserConfig(Config parent, FS fs) {
        return this.delegate.openUserConfig(parent, fs);
    }

    public FileBasedConfig openSystemConfig(Config parent, FS fs) {
        return this.delegate.openSystemConfig(parent, fs);
    }

    public long getCurrentTime() {
        return this.delegate.getCurrentTime();
    }

    public MonotonicClock getClock() {
        return this.delegate.getClock();
    }

    public int getTimezone(long when) {
        return this.delegate.getTimezone(when);
    }

    public TimeZone getTimeZone() {
        return this.delegate.getTimeZone();
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public SimpleDateFormat getSimpleDateFormat(String pattern) {
        return this.delegate.getSimpleDateFormat(pattern);
    }

    public SimpleDateFormat getSimpleDateFormat(String pattern, Locale locale) {
        return this.delegate.getSimpleDateFormat(pattern, locale);
    }

    public DateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return this.delegate.getDateTimeInstance(dateStyle, timeStyle);
    }

    public boolean isWindows() {
        return this.delegate.isWindows();
    }

    public boolean isMacOS() {
        return this.delegate.isWindows();
    }

    public void checkPath(String path) throws CorruptObjectException {
        this.delegate.checkPath(path);
    }

    public void checkPath(byte[] path) throws CorruptObjectException {
        this.delegate.checkPath(path);
    }

    public static void install() {
        SystemReader current = SystemReader.getInstance();
        String gitSsh = Stream.of("ssh", "plink").map(GrgitSystemReader::findExecutable).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
        GrgitSystemReader grgit = new GrgitSystemReader(current, gitSsh);
        SystemReader.setInstance((SystemReader)grgit);
    }

    private static Optional<String> findExecutable(String exe) {
        List extensions = Optional.ofNullable(System.getenv("PATHEXT")).map(PATH_SPLITTER::splitAsStream).map(stream -> stream.collect(Collectors.toList())).orElse(Collections.emptyList());
        Function<Path, Stream> getCandidatePaths = dir -> {
            if (extensions.isEmpty()) {
                return Stream.of(dir.resolve(exe));
            }
            return extensions.stream().map(ext -> dir.resolve(exe + ext));
        };
        return PATH_SPLITTER.splitAsStream(System.getenv("PATH")).map(x$0 -> Paths.get(x$0, new String[0])).flatMap(getCandidatePaths).filter(Files::isExecutable).map(Path::toAbsolutePath).map(Path::toString).findFirst();
    }
}

