/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.taglib.html.jsp;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

import org.ajax4jsf.framework.renderer.AjaxPhaseListener;
import org.ajax4jsf.framework.util.message.Messages;

/**
 * @author shura
 *
 */
public class KeepAliveTag extends TagSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4322021112358067548L;
	
	private String beanName = null;
	
	private String ajaxOnly = null;

	/**
	 * @return the ajaxOnly
	 */
	public String getAjaxOnly() {
		return ajaxOnly;
	}

	/**
	 * @param ajaxOnly the ajaxOnly to set
	 */
	public void setAjaxOnly(String ajaxOnly) {
		this.ajaxOnly = ajaxOnly;
	}

	/**
	 * @return the name
	 */
	public String getBeanName() {
		return beanName;
	}

	/**
	 * @param name the name to set
	 */
	public void setBeanName(String name) {
		this.beanName = name;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	public int doStartTag() throws JspException {
        if (beanName == null) {
            throw new JspException(Messages.getMessage(Messages.NULL_TYPE_ATTRIBUTE_ERROR));
        }
        if(UIComponentTag.isValueReference(beanName)){
            throw new JspException(Messages.getMessage(Messages.NAME_MUST_BE_LITERAL));
        }
		boolean isAjaxOnly = false;
		FacesContext facesContext = FacesContext.getCurrentInstance();
		if (null != ajaxOnly) {
            if (UIComponentTag.isValueReference(ajaxOnly))
            {
                ValueBinding vb = facesContext.getApplication().createValueBinding(ajaxOnly);
                isAjaxOnly = Boolean.TRUE.equals(vb.getValue(facesContext));
            }
            else
            {
                //TODO: More sophisticated way to convert boolean value (yes/no, 1/0, on/off, etc.)
                isAjaxOnly = Boolean.parseBoolean(ajaxOnly);
            }

		}
        // Get bean instance from EL expression.
        String beanExpression = "#{"+beanName+"}";
        ValueBinding valueBinding = facesContext.getApplication().createValueBinding(beanExpression);
        Object bean = valueBinding.getValue(facesContext);
        // Put bean instance to ViewRoot. 
        String beanAttributeName = isAjaxOnly?AjaxPhaseListener.AJAX_BEAN_PREFIX:AjaxPhaseListener.VIEW_BEAN_PREFIX+beanName;
        facesContext.getViewRoot().getAttributes().put(beanAttributeName, bean);
		return Tag.SKIP_BODY;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#release()
	 */
	public void release() {
		beanName = null;
		ajaxOnly = null;
		super.release();
	}
	

}
