/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.framework.renderer.ComponentsVariableResolver;
import org.ajax4jsf.framework.renderer.ComponentVariables;
import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
//
//
//


import org.ajax4jsf.renderkit.AjaxCommandRendererBase;



/**
 * Renderer for component class org.ajax4jsf.renderkit.html.CommandLinkRenderer
 */
public class CommandLinkRenderer extends AjaxCommandRendererBase {

	public CommandLinkRenderer () {
		super();
	}

	// 
	// Declarations
	//
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.ajax4jsf.ajax.UIAjaxCommandLink.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.ajax4jsf.ajax.UIAjaxCommandLink)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.ajax4jsf.ajax.UIAjaxCommandLink component, ComponentVariables variables ) throws IOException {
	    java.lang.String clientId = component.getClientId(context);
writer.startElement("a", component);
			getUtils().writeAttribute(writer, "href", "#" );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "onclick", getOnClick(context,component) );
						getUtils().writeAttribute(writer, "type", component.getAttributes().get("type") );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "accesskey" ,
	    "charset" ,
	    "class" ,
	    "coords" ,
	    "dir" ,
	    "hreflang" ,
	    "lang" ,
	    "onblur" ,
	    "ondblclick" ,
	    "onfocus" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "rel" ,
	    "rev" ,
	    "shape" ,
	    "style" ,
	    "tabindex" ,
	    "title" ,
	    "xml:lang" });
//
//
//

writer.writeText(convertToString(getValue(component)),null);


	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.ajax4jsf.ajax.UIAjaxCommandLink)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.ajax4jsf.ajax.UIAjaxCommandLink component, ComponentVariables variables) throws IOException {
	    
renderChildren(context, component);


	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.ajax4jsf.ajax.UIAjaxCommandLink component, ComponentVariables variables) throws IOException {
	  
writer.endElement("a");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.ajax4jsf.ajax.UIAjaxCommandLink)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
