/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.renderkit;

import java.io.IOException;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.ajax.AjaxEvent;
import org.ajax4jsf.framework.renderer.AjaxComponentRendererBase;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;


/**
 * @author asmirnov@exadel.com (latest modification by $Author: alexsmirnov $)
 * @version $Revision: 1.1.2.3 $ $Date: 2007/02/12 17:46:53 $
 *
 */
public abstract class AjaxCommandRendererBase extends AjaxComponentRendererBase {

	protected void doDecode(FacesContext facesContext, UIComponent uiComponent) {
	
	    //super.decode must not be called, because value is handled here
	    if ( isSubmitted(facesContext, uiComponent))
	    {
	    	Map attributes = uiComponent.getAttributes();
			Object type = attributes.get("type");
        	if (! "reset".equalsIgnoreCase((String)type) ) {
				ActionEvent event;
				event = new ActionEvent(uiComponent);
				uiComponent.queueEvent(event); 
			} 
			uiComponent.queueEvent( new AjaxEvent(uiComponent));
//	        org.ajax4jsf.framework.ajax.AjaxRegionListener.addRegionsFromComponent(uiComponent, facesContext);
	    }
	}

	public String getOnClick(FacesContext context, UIComponent component) {
	        StringBuffer onClick;
			if ( !getUtils().isBooleanAttribute(component,"disabled")) {
				onClick = AjaxRendererUtils.buildOnClick(component, context);
				if (!"reset".equals(component.getAttributes().get("type"))) {
					onClick.append(";return false;");
				}
			} else {
				onClick = new StringBuffer("return false;");
			}
	        return onClick.toString();
		}

	public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
	    renderChildren(context, component);
	}

	public Object getValue(UIComponent uiComponent) {
	    if (uiComponent instanceof ValueHolder) {
	        return ((ValueHolder) uiComponent).getValue();
	    }
	    return uiComponent.getAttributes().get("value");
	}

	public String getType(UIComponent uiComponent) {
	    String type;
	    if (uiComponent instanceof HtmlCommandButton) {
	        type = ((HtmlCommandButton) uiComponent).getType();
	    } else {
	        type = (String) uiComponent.getAttributes().get("type");
	    }
	    if (type == null) {
	        type = "button";
	    }
	    return type;
	}

	
	protected boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
		// Componet accept only ajax requests. 
		if ( !AjaxContext.getCurrentInstance(facesContext).isAjaxRequest(facesContext)) {
			return false;
		}
		if(getUtils().isBooleanAttribute(uiComponent,"disabled")){
			return false;
		}
	    String clientId = uiComponent.getClientId(facesContext);
	    Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
	    Object  value = paramMap.get( clientId );
		return null != value;
	}

}
