/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.framework.util.javascript;

import java.util.HashMap;
import java.util.Map;

import javax.faces.component.UIComponent;

import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author shura
 *
 */
public class AjaxSubmitFunction extends JSFunction {
	
	/**
	 * Name Javasript function for submit AJAX request
	 */
	public static final String AJAX_FUNCTION_NAME = "A4J.AJAX.Submit";

	/**
	 * Attribute for keep clientId of status component
	 */
	public static final String STATUS_ATTR_NAME = "status";

	/**
	 * Attribute for keep JavaScript funtion name for call after complete
	 * request.
	 */
	public static final String ONCOMPLETE_ATTR_NAME = "oncomplete";

	/**
	 * Attribute to keep
	 */
	public static final String LIMITTOLIST_ATTR_NAME = "limitToList";

	private static Log log = LogFactory.getLog(AjaxRendererUtils.class);

	public static final String AJAX_REGIONS_ATTRIBUTE = "reRender";

	private static final Class OBJECT_ARRAY_CLASS = (new Object[0]).getClass();

	private UIComponent component;
	
	private Map options = new HashMap();
	
	private Map requestParameters = new HashMap();

	/**
	 * 
	 */
	public AjaxSubmitFunction(UIComponent component) {
		this(component,AJAX_FUNCTION_NAME);
	}
	/**
	 * @param name
	 */
	public AjaxSubmitFunction(UIComponent component,String name) {
		super(name);
		this.component = component;
		// Fill parameters and options values.
	}
	/**
	 * @return the options
	 */
	public Map getOptions() {
		return this.options;
	}
	/**
	 * @return the requestParameters
	 */
	public Map getRequestParameters() {
		return this.requestParameters;
	}

}
