/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

/*
 * Helma License Notice
 *
 * The contents of this file are subject to the Helma License
 * Version 2.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://adele.helma.org/download/helma/license.txt
 *
 * Copyright 1998-2003 Helma Software. All Rights Reserved.
 *
 * $RCSfile: GIFImageWriter.java,v $
 * $Author: alexsmirnov $
 * $Revision: 1.1.2.1 $
 * $Date: 2007/01/09 18:58:03 $
 */

/*
 * The imageio integration is inspired by the package org.freehep.graphicsio.gif
 */

package org.ajax4jsf.framework.util.image.imageio.gif;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutput;
import java.io.IOException;

import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;

import org.ajax4jsf.framework.util.image.GIFEncoder;
import org.ajax4jsf.framework.util.message.Messages;


public class GIFImageWriter extends ImageWriter {
    GIFEncoder encoder;

    public GIFImageWriter(GIFImageWriterSpi originatingProvider) {
        super(originatingProvider);
        encoder = new GIFEncoder();
    }

    public void write(IIOMetadata streamMetadata, IIOImage image,
        ImageWriteParam param) throws IOException {
        if (image == null)
            throw new IllegalArgumentException("image == null");

        if (image.hasRaster())
            throw new UnsupportedOperationException(Messages.getMessage(Messages.CANNOT_WRITE_RASTERS));

        Object output = getOutput();
        if (output == null)
            throw new IllegalStateException(Messages.getMessage(Messages.NULL_OUTPUT_ERROR));

        if (param == null)
            param = getDefaultWriteParam();

        RenderedImage ri = image.getRenderedImage();
        if (!(ri instanceof BufferedImage))
            throw new IOException(Messages.getMessage(Messages.IMAGE_NOT_BUFFERED_ERROR));
        if (!(output instanceof DataOutput))
            throw new IOException(Messages.getMessage(Messages.NOT_DATA_OUTPUT_ERROR));
        encoder.encode((BufferedImage) ri, (DataOutput) output,
            param.getProgressiveMode() != ImageWriteParam.MODE_DISABLED, null);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData,
        ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData,
        ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType,
        ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new GIFImageWriteParam(getLocale());
    }
}