/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.framework.util.image;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
/**
 * 
 * TODO: provide English Comments
 * 
 *
 */
public class RoundGradientContext implements PaintContext {
  protected Point2D mPoint;
  protected Point2D mRadius;
  protected Color mC1, mC2;
  public RoundGradientContext(Point2D p, Color c1, Point2D r, Color c2) {
    mPoint = p;
    mC1 = c1;
    mRadius = r;
    mC2 = c2;
  }
  public void dispose() {}
  public ColorModel getColorModel() { return ColorModel.getRGBdefault(); }
 /* The get-Raster() method iterates over each point in the requested rectangle,
      calculating the distance from the center point.
      It calculates a weighting factor, from 0.0 to 1.0, based on the ratio of this
      distance and the radius. */
  public Raster getRaster(int x, int y, int w, int h) {
    WritableRaster raster =
        getColorModel().createCompatibleWritableRaster(w, h);
    int[] data = new int[w * h * 4]; //k=4, 
     double radius   = mRadius.distance(0, 0);
    for (int j = 0; j < h; j++) {
      for (int i = 0; i < w; i++) {
        double distance = mPoint.distance(x + i, y + j);
       
        double ratio    = distance/radius;
        if (ratio > 1.0){
          ratio = 1.0;
        }//if
        int base = (j * w + i) * 4;
        //it simply uses the weighting factor to linearly interpolate between the center color and the background color
        data[base] = (int)(mC1.getRed()       + ratio * (mC2.getRed() - mC1.getRed()));
        data[base + 1] = (int)(mC1.getGreen() + ratio * (mC2.getGreen() - mC1.getGreen()));
        data[base + 2] = (int)(mC1.getBlue()  + ratio * (mC2.getBlue()  - mC1.getBlue()));
        data[base + 3] = (int)(mC1.getAlpha() + ratio * (mC2.getAlpha() - mC1.getAlpha()));
      }
    }
    
    raster.setPixels(0, 0, w, h, data);
    return raster;
  }
}
