/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.framework.renderer.compiler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.faces.FacesException;

import org.ajax4jsf.framework.renderer.RendererBase;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;


/**
 * @author asmirnov@exadel.com (latest modification by $Author: alexsmirnov $)
 * @version $Revision: 1.1.2.1 $ $Date: 2007/01/09 18:57:43 $
 *
 */
public class ResourceElement extends ElementBase {

	private Map attrs = new HashMap();
	/* (non-Javadoc)
	 * @see java.util.Map#put(java.lang.Object, java.lang.Object)
	 */
	public Object put(Object key, Object value) {
		return attrs.put(key, value);
	}

	/* (non-Javadoc)
	 * @see java.util.Map#get(java.lang.Object)
	 */
	public Object get(Object key) {
		return attrs.get(key);
	}

	/* (non-Javadoc)
	 * @see org.ajax4jsf.framework.renderer.compiler.RootElement#encode(javax.faces.render.Renderer, javax.faces.context.FacesContext, javax.faces.component.UIComponent)
	 */
	public void encodeBegin(TemplateContext context) throws IOException {
		InternetResource resource = findResource(context);
		if(null !=resource){
			resource.encodeBegin(context.getFacesContext(),context.getComponent(),attrs);
		}
	}

	/* (non-Javadoc)
	 * @see org.ajax4jsf.framework.renderer.compiler.RootElement#encode(javax.faces.render.Renderer, javax.faces.context.FacesContext, javax.faces.component.UIComponent)
	 */
	public void encodeEnd(TemplateContext context) throws IOException {
		InternetResource resource = findResource(context);
		if(null !=resource){
			resource.encodeEnd(context.getFacesContext(),context.getComponent());
		}
	}

	/* (non-Javadoc)
	 * @see org.ajax4jsf.framework.renderer.compiler.RootElement#getString(javax.faces.render.Renderer, javax.faces.context.FacesContext, javax.faces.component.UIComponent)
	 */
	public String getString(TemplateContext context) throws FacesException {
		InternetResource resource = findResource(context);
		if(null !=resource){
			return resource.getUri(context.getFacesContext(),context.getComponent());
		}
		return "";
	}

	private InternetResource findResource(TemplateContext context) {
		InternetResource resource;
		String path = (String) getValue(context);
		RendererBase renderer = context.getRenderer();
		if (renderer != null)  {
			resource = renderer.getResource(path);
		} else {
			resource = InternetResourceBuilder.getInstance().createResource(null, path);
		}
		
		return resource;
	}
	
	public String getTag() {
		return HtmlCompiler.NS_PREFIX+HtmlCompiler.RESOURCE_TAG;
	}
	
}
