/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.framework.ajax;

import java.io.IOException;

import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

import org.ajax4jsf.framework.renderer.AjaxPhaseListener;

/**
 * @author shura
 *
 */
public class AjaxStateManager extends StateManager {
	
	private StateManager parent;

	/**
	 * @param parent
	 */
	public AjaxStateManager(StateManager parent) {
		super();
		this.parent = parent;
	}

	/* (non-Javadoc)
	 * @see javax.faces.application.StateManager#getComponentStateToSave(javax.faces.context.FacesContext)
	 */
	protected Object getComponentStateToSave(FacesContext context) {
		throw new UnsupportedOperationException();
	}

	/* (non-Javadoc)
	 * @see javax.faces.application.StateManager#getTreeStructureToSave(javax.faces.context.FacesContext)
	 */
	protected Object getTreeStructureToSave(FacesContext context) {
		throw new UnsupportedOperationException();
	}

	/* (non-Javadoc)
	 * @see javax.faces.application.StateManager#restoreComponentState(javax.faces.context.FacesContext, javax.faces.component.UIViewRoot, java.lang.String)
	 */
	protected void restoreComponentState(FacesContext context,
			UIViewRoot viewRoot, String renderKitId) {
		throw new UnsupportedOperationException();
	}

	/* (non-Javadoc)
	 * @see javax.faces.application.StateManager#restoreTreeStructure(javax.faces.context.FacesContext, java.lang.String, java.lang.String)
	 */
	protected UIViewRoot restoreTreeStructure(FacesContext context,
			String viewId, String renderKitId) {
		throw new UnsupportedOperationException();
	}

	/* (non-Javadoc)
	 * @see javax.faces.application.StateManager#restoreView(javax.faces.context.FacesContext, java.lang.String, java.lang.String)
	 */
	public UIViewRoot restoreView(FacesContext context, String viewId,
			String renderKitId) {
		return parent.restoreView(context, viewId, renderKitId);
	}

	/* (non-Javadoc)
	 * @see javax.faces.application.StateManager#saveSerializedView(javax.faces.context.FacesContext)
	 */
	public SerializedView saveSerializedView(FacesContext context) {		
		return parent.saveSerializedView(context);
	}

	/* (non-Javadoc)
	 * @see javax.faces.application.StateManager#writeState(javax.faces.context.FacesContext, javax.faces.application.StateManager.SerializedView)
	 */
	public void writeState(FacesContext context, SerializedView state)
			throws IOException {
		parent.writeState(context, state);
		context.getExternalContext().getRequestMap().put(AjaxPhaseListener.VIEW_STATE_SAVED_PARAM, Boolean.TRUE);
	}

}
