/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

/*
 *  Copyright
 *      Copyright (c) Exadel,Inc. 2006
 *      All rights reserved.
 *  
 *  History
 *      $Source: /cvs/ajax4jsf/framework/src/main/java/org/ajax4jsf/dnd/taglib/Attic/DropSourceMetaRule.java,v $
 *      $Revision: 1.1.2.1 $ 
 */

package org.ajax4jsf.dnd.taglib;

import javax.faces.el.MethodBinding;

import org.ajax4jsf.dnd.event.DropEvent;
import org.ajax4jsf.dnd.event.DropSource;
import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;

/**
 * @author Maksim Kaszynski
 *
 */
public class DropSourceMetaRule extends MetaRule {

	public static final DropSourceMetaRule INSTANCE = new DropSourceMetaRule();
	private static final Class [] SIGNATURE = {DropEvent.class};
	
	private class DropListenerMetaData extends Metadata {
		
		private TagAttribute tagAttribute;
		
		public DropListenerMetaData(TagAttribute attribute) {
			tagAttribute = attribute;
		}
		
		public void applyMetadata(FaceletContext ctx, Object instance) {
			MethodBinding binding = ctx.getFacesContext().getApplication().createMethodBinding(tagAttribute.getValue(), SIGNATURE);
			((DropSource) instance).setDropListener(binding);
		}
	}
	
	
	public Metadata applyRule(String name, TagAttribute attribute,
			MetadataTarget meta) {
		if ("dropListener".equals(name)) {
			return new DropListenerMetaData(attribute);
		}
		return null;
	}

}
