/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.ajax.resource;

import javax.faces.component.UIOutput;

/**
 * @author shura
 *
 */
public abstract class UIMediaOutput extends UIOutput implements ResourceComponent {
	
    public static final String COMPONENT_TYPE = "org.ajax4jsf.MMedia";

	/**
	 * Get URI attribute for resource ( src for images, href for links etc ).
	 * @return
	 */
	public abstract String getUriAttribute();

	/**
	 * Set URI attribute for resource ( src for images, href for links etc ).
	 * @param newvalue
	 */
	public abstract void setUriAttribute(String newvalue);
	
	/**
	 * Get Element name for rendering ( imj , a , object, applet ).
	 * @return
	 */
	public abstract String getElement();

	/**
	 * Set Element name for rendering ( imj , a , object, applet ).
	 * @param newvalue
	 */
	public abstract void setElement(String newvalue);
	

}
