/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.ajax.repeat;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
/**
 * @author shura
 *
 */
public class UIRepeat extends UIDataAdaptor {

	/* (non-Javadoc)
	 * @see org.ajax4jsf.ajax.repeat.UIDataAdaptor#createComponentState()
	 */
	protected DataComponentState createComponentState() {
		// Create component state based on this instance.
		return new DataComponentState(){

			public Range getRange() {
				return new SequenceRange(getFirst(),getRows());
			}

			public boolean isTransient() {
				// TODO Auto-generated method stub
				return false;
			}

			public void restoreState(FacesContext arg0, Object arg1) {
				// TODO Auto-generated method stub
				
			}

			public Object saveState(FacesContext arg0) {
				// TODO Auto-generated method stub
				return null;
			}

			public void setTransient(boolean arg0) {
				// TODO Auto-generated method stub
				
			}
		};
		
	}

	/* (non-Javadoc)
	 * @see org.ajax4jsf.ajax.repeat.UIDataAdaptor#createDataModel()
	 */
	protected ExtendedDataModel createDataModel() {
		return (ExtendedDataModel) getDataModel();
	}

	protected DataModel getDataModel(){
        // Synthesize a DataModel around our current value if possible
		// TODO - for jsf 1.2 use method from superclass ?
        Object current = getValue();
        DataModel model;
        if (current == null) {
            model = new SequenceDataModel(new ListDataModel(Collections.EMPTY_LIST));
        } else if (current instanceof ExtendedDataModel) {
            model = (DataModel) current;
        } else if (current instanceof DataModel) {
            model = new SequenceDataModel((DataModel) current);
        } else if (current instanceof List) {
            model = new SequenceDataModel(new ListDataModel((List) current));
        } else if (Object[].class.isAssignableFrom(current.getClass())) {
            model = new SequenceDataModel(new ArrayDataModel((Object[]) current));
        } else if (current instanceof ResultSet) {
            model = new SequenceDataModel(new ResultSetDataModel((ResultSet) current));
//        } else if (current instanceof Result) {
//            model = new ResultDataModel((Result) current);
        } else {
            model = new SequenceDataModel(new ScalarDataModel(current));
        }
	return (model);
	}
	
	protected void setDataModel(DataModel model) {
		ExtendedDataModel iterableModel;
		if( null == model){
			iterableModel = null;
		} else if (model instanceof ExtendedDataModel) {
			iterableModel = (ExtendedDataModel) model;			
		} else {
			iterableModel = new SequenceDataModel(model);
		}
		setExtendedDataModel(iterableModel);
	}
	/* (non-Javadoc)
	 * @see org.ajax4jsf.ajax.repeat.UIDataAdaptor#dataChildren()
	 */
	protected Iterator dataChildren() {
		// TODO Auto-generated method stub
		return getChildren().iterator();
	}

	/* (non-Javadoc)
	 * @see org.ajax4jsf.ajax.repeat.UIDataAdaptor#fixedChildren()
	 */
	protected Iterator fixedChildren() {
		// TODO Auto-generated method stub
		return getFacets().values().iterator();
	}

}
