/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.ajax;

import java.io.Serializable;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

import org.ajax4jsf.framework.ajax.AjaxActionComponent;
import org.ajax4jsf.framework.ajax.AjaxSupport;
import org.ajax4jsf.framework.ajax.EventValueBinding;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * Component for append ajax functions to any control component.
 * Append action functionality to non-action control,
 * setup javascript events for parent component,
 * @author shura (latest modification by $Author: alexsmirnov $)
 * @version $Revision: 1.1.2.3 $ $Date: 2007/02/12 17:46:52 $
 *
 */
public abstract class UIAjaxSupport extends AjaxActionComponent implements  AjaxSupport
{

    //~ Static fields/initializers ---------------------------------------------

    public static final String COMPONENT_TYPE = "org.ajax4jsf.ajax.Support";
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    public static final String DEFAULT_RENDERER_TYPE = "org.ajax4jsf.components.AjaxSupportRenderer";
    public static final String AJAX_SUPPORT_SET = "com.exadel.components.ajax.support.";
    private static final Log log = LogFactory.getLog(UIAjaxSupport.class);

    /**
     * Name of JavaScript function, called before submit Ajax request
	 * description
	 * @parameter
	 * @return the acceptClass
	 */
	public abstract String getOnsubmit();

	/**
	 * @param newOnsubmit the value  to set
	 */
	public abstract void setOnsubmit(String newOnsubmit);
    /* (non-Javadoc)
	 * @see javax.faces.component.UIComponentBase#setValueBinding(java.lang.String, javax.faces.el.ValueBinding)
	 */
	public void setValueBinding(String arg0, ValueBinding arg1) {
		// var - not allowed name. must be literal.
		if("var".equals(arg0)){
			throw new FacesException(
					Messages.getMessage(Messages.VAR_MUST_BE_LITERAL, getClientId(getFacesContext())));
		}
		if("event".equals(arg0)){
			throw new FacesException(
					Messages.getMessage(Messages.EVENT_MUST_BE_LITERAL, getClientId(getFacesContext())));
		}
		super.setValueBinding(arg0, arg1);
	}

	/**
     * Create Special <code>ValueBinding</code> for build JavaScrept
     * event code in parent component from this.
     * @return <code>EventValueBinding</code> based on properties of current component
     */
    private ValueBinding getEventValueBinding()
    {
        if (log.isDebugEnabled())
        {
            log.debug(Messages.getMessage(Messages.CREATE_JAVASCRIPT_EVENT, getId()));
        }
        return new EventValueBinding(this);
    }

    /**
     * @return JavaScript eventString. Rebuild on every call, since
     * can be in loop ( as in dataTable ) with different parameters.
     */
    public String getEventString()
    {
        StringBuffer buildOnEvent = new StringBuffer();
        String onsubmit = getOnsubmit();
        // Insert script to call before submit ajax request.
        if (null != onsubmit) {
			buildOnEvent.append(onsubmit).append(";");
		}
        // Due to JSF RI 1.1 bug, clear cached clientId
        setId(getId());
		buildOnEvent.append(AjaxRendererUtils.buildOnEvent(this, getFacesContext(),
				                getEvent()));
		String script = buildOnEvent.toString();
		return script;
    }

    /* (non-Javadoc)
     * @see javax.faces.component.UIComponentBase#decode(javax.faces.context.FacesContext)
     */
    public void decode(FacesContext context) {
        // Due to JSF RI 1.1 bug, clear cached clientId
        setId(getId());
    	super.decode(context);
    }
    
    /**
     * After nornal setting <code>parent</code> property in case of
     * created component set Ajax properties for parent.
     * @see javax.faces.component.UIComponentBase#setParent(javax.faces.component.UIComponent)
     */
    public void setParent(UIComponent parent)
    {
        super.setParent(parent);
        if (null != parent && parent.getFamily() != null ) {
			if (log.isDebugEnabled()) {
				log.debug(Messages.getMessage(Messages.CALLED_SET_PARENT, parent.getClass().getName()));
			}
			// TODO If this comopnent configured, set properties for parent component.
			// NEW created component have parent, restored view - null in My faces.
			// and SUN RI not call at restore saved view. 
			// In other case - set in restoreState method.
			//        if (parent.getParent() != null)
			{
				if (log.isDebugEnabled()) {
					log.debug(Messages.getMessage(Messages.DETECT_NEW_COMPONENT));
				}
				setParentProperties(parent);

			}
		}
    }

    public void setParentProperties(UIComponent parent) {
        ValueBinding valueBinding;
//        Map parentAttributes = parent.getAttributes();
/*        if (parent instanceof ActionSource && null == getEvent())
        {
            log.debug("Set properties for parent as ActionSource");
            // Translate AJAX properties to parent component.
            if (_reRender != null)
            {
                parentAttributes
                        .put(AjaxRendererUtils.AJAX_REGIONS_ATTRIBUTE,
                                _reRender);
            }
            else if ((valueBinding = getValueBinding("reRender")) != null)
            {
                parent.setValueBinding(
                        AjaxRendererUtils.AJAX_REGIONS_ATTRIBUTE,
                        valueBinding);
            }
            if (_oncomplete != null)
            {
                parentAttributes
                        .put(AjaxRendererUtils.ONCOMPLETE_ATTR_NAME,
                                _oncomplete);
            }
            else if ((valueBinding = getValueBinding("oncomplete")) != null)
            {
                parent.setValueBinding(
                        AjaxRendererUtils.ONCOMPLETE_ATTR_NAME,
                        valueBinding);
            }
            if (_status != null)
            {
                parentAttributes.put(AjaxRendererUtils.STATUS_ATTR_NAME,
                        _status);
            }
            else if ((valueBinding = getValueBinding("status")) != null)
            {
                parent.setValueBinding(AjaxRendererUtils.STATUS_ATTR_NAME,
                        valueBinding);
            }
            if (_limitToListSet)
            {
                parentAttributes.put(
                        AjaxRendererUtils.LIMITTOLIST_ATTR_NAME, Boolean
                                .valueOf(_limitToList));
            }
            else if ((valueBinding = getValueBinding("limitToList")) != null)
            {
                parent.setValueBinding(
                        AjaxRendererUtils.LIMITTOLIST_ATTR_NAME,
                        valueBinding);
            }
            // Add Listener for all supported types.
            AjaxRegionListener listener = new AjaxRegionListener();
            ((ActionSource) parent).addActionListener(listener);
        }
        else*/ if (null != getEvent())
        {
            if (log.isDebugEnabled())
            {
                log.debug(Messages.getMessage(Messages.SET_VALUE_BINDING_FOR_EVENT, getEvent()));
            }
            // for non action/data components, or for non-default events - build listener for this instance. 
            valueBinding = getEventValueBinding();
            // test for valid event attribute name.
            // TODO - test for compability with concrete element.
            parent.setValueBinding(getEvent(), valueBinding);
        }

    }
    
    protected UIComponent getSingleComponent() {
        return getParent();
    }

}
