/*
 * Decompiled with CFR 0.152.
 */
package org.aim42.htmlsanitycheck.check;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URLDecoder;
import java.util.List;
import org.aim42.htmlsanitycheck.Configuration;
import org.aim42.htmlsanitycheck.check.Checker;
import org.aim42.htmlsanitycheck.collect.SingleCheckResults;
import org.aim42.htmlsanitycheck.html.HtmlElement;
import org.aim42.htmlsanitycheck.html.HtmlPage;
import org.aim42.htmlsanitycheck.html.URLUtil;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingImageFilesChecker
extends Checker {
    private List<HtmlElement> images;
    private File baseDir;
    private File currentDir;
    private static final Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MissingImageFilesChecker(Configuration pConfig) {
        CallSite[] callSiteArray = MissingImageFilesChecker.$getCallSiteArray();
        super(pConfig);
        Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), callSiteArray[2].callGetProperty(Configuration.class));
        this.baseDir = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
    }

    @Override
    protected void initCheckingResultsDescription() {
        CallSite[] callSiteArray = MissingImageFilesChecker.$getCallSiteArray();
        String string = "Missing Local Images Check";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, MissingImageFilesChecker.class, (GroovyObject)callSiteArray[3].callGroovyObjectGetProperty((Object)this), (String)"whatIsChecked");
        String string2 = "img src attributes";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, MissingImageFilesChecker.class, (GroovyObject)callSiteArray[4].callGroovyObjectGetProperty((Object)this), (String)"sourceItemName");
        String string3 = "missing image files";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string3, MissingImageFilesChecker.class, (GroovyObject)callSiteArray[5].callGroovyObjectGetProperty((Object)this), (String)"targetItemName");
    }

    @Override
    protected SingleCheckResults check(HtmlPage pageToCheck) {
        CallSite[] callSiteArray = MissingImageFilesChecker.$getCallSiteArray();
        Object object = callSiteArray[6].callGetPropertySafe(callSiteArray[7].callGroovyObjectGetProperty((Object)pageToCheck));
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : this.baseDir;
        this.currentDir = (File)ScriptBytecodeAdapter.castToType((Object)object2, File.class);
        Object object3 = callSiteArray[8].call((Object)pageToCheck);
        this.images = (List)ScriptBytecodeAdapter.castToType((Object)object3, List.class);
        callSiteArray[9].call((Object)logger, (Object)new GStringImpl(new Object[]{this.images}, new String[]{"images to check: ", ""}));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[10].callCurrent((GroovyObject)this);
        } else {
            this.checkAllImages();
        }
        return (SingleCheckResults)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callGroovyObjectGetProperty((Object)this), SingleCheckResults.class);
    }

    private void checkAllImages() {
        CallSite[] callSiteArray = MissingImageFilesChecker.$getCallSiteArray();
        public final class _checkAllImages_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _checkAllImages_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _checkAllImages_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object image) {
                CallSite[] callSiteArray = _checkAllImages_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, image);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkAllImages_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "checkSingleLocalImage";
                return new CallSiteArray(_checkAllImages_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _checkAllImages_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[12].call(this.images, (Object)new _checkAllImages_closure1(this, this));
    }

    private void checkSingleLocalImage(HtmlElement image) {
        CallSite[] callSiteArray = MissingImageFilesChecker.$getCallSiteArray();
        String imageSrcAttribute = ShortTypeHandling.castToString((Object)callSiteArray[13].call((Object)image));
        Boolean isRemoteURL = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].call(URLUtil.class, (Object)imageSrcAttribute), Boolean.class);
        Boolean isDataURI = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call(URLUtil.class, (Object)imageSrcAttribute), Boolean.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)isRemoteURL)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)isDataURI)) {
                callSiteArray[16].call(callSiteArray[17].callGroovyObjectGetProperty((Object)this));
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    callSiteArray[18].callCurrent((GroovyObject)this, (Object)imageSrcAttribute);
                } else {
                    this.doesDataURIContainData(imageSrcAttribute);
                }
            } else {
                callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this));
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    callSiteArray[21].callCurrent((GroovyObject)this, (Object)imageSrcAttribute);
                } else {
                    this.doesImageFileExist(imageSrcAttribute);
                }
            }
        }
    }

    private void doesImageFileExist(String relativePathToImageFile) {
        CallSite[] callSiteArray = MissingImageFilesChecker.$getCallSiteArray();
        File parentDir = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].callSafe((Object)relativePathToImageFile, (Object)"/")) ? this.baseDir : this.currentDir;
        String decodedRelativePathtoImageFile = ShortTypeHandling.castToString((Object)callSiteArray[23].call(URLDecoder.class, (Object)relativePathToImageFile));
        File imageFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].callConstructor(File.class, (Object)parentDir, (Object)decodedRelativePathtoImageFile), File.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].call((Object)imageFile)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call((Object)imageFile))) {
            String findingText = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{relativePathToImageFile}, new String[]{"image \"", "\" missing"}));
            callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty((Object)this), (Object)findingText);
        }
    }

    private void doesDataURIContainData(String dataURI) {
        CallSite[] callSiteArray = MissingImageFilesChecker.$getCallSiteArray();
        if (ScriptBytecodeAdapter.matchRegex((Object)dataURI, (Object)"^data:image/[a-z]+;base64,")) {
            String findingText = "data-URI image missing";
            callSiteArray[29].call(callSiteArray[30].callGroovyObjectGetProperty((Object)this), (Object)findingText);
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MissingImageFilesChecker.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Object object = MissingImageFilesChecker.$getCallSiteArray()[31].call(LoggerFactory.class, MissingImageFilesChecker.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getConfigItemByName";
        stringArray[1] = "myConfig";
        stringArray[2] = "ITEM_NAME_sourceDir";
        stringArray[3] = "checkingResults";
        stringArray[4] = "checkingResults";
        stringArray[5] = "checkingResults";
        stringArray[6] = "parentFile";
        stringArray[7] = "file";
        stringArray[8] = "getAllImageTags";
        stringArray[9] = "debug";
        stringArray[10] = "checkAllImages";
        stringArray[11] = "checkingResults";
        stringArray[12] = "each";
        stringArray[13] = "getImageSrcAttribute";
        stringArray[14] = "isRemoteURL";
        stringArray[15] = "isDataURI";
        stringArray[16] = "incNrOfChecks";
        stringArray[17] = "checkingResults";
        stringArray[18] = "doesDataURIContainData";
        stringArray[19] = "incNrOfChecks";
        stringArray[20] = "checkingResults";
        stringArray[21] = "doesImageFileExist";
        stringArray[22] = "startsWith";
        stringArray[23] = "decode";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "exists";
        stringArray[26] = "isDirectory";
        stringArray[27] = "newFinding";
        stringArray[28] = "checkingResults";
        stringArray[29] = "newFinding";
        stringArray[30] = "checkingResults";
        stringArray[31] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[32];
        MissingImageFilesChecker.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MissingImageFilesChecker.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MissingImageFilesChecker.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

