/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.service.api.runtime.process.ExecutionActionRequest;
import org.activiti.rest.service.api.runtime.process.ExecutionBaseResource;
import org.activiti.rest.service.api.runtime.process.ExecutionResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ExecutionResource
extends ExecutionBaseResource {
    @RequestMapping(value={"/runtime/executions/{executionId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ExecutionResponse getExecution(@PathVariable String executionId, HttpServletRequest request) {
        return this.restResponseFactory.createExecutionResponse(this.getExecutionFromRequest(executionId));
    }

    @RequestMapping(value={"/runtime/executions/{executionId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ExecutionResponse performExecutionAction(@PathVariable String executionId, @RequestBody ExecutionActionRequest actionRequest, HttpServletRequest request, HttpServletResponse response) {
        Execution execution = this.getExecutionFromRequest(executionId);
        if ("signal".equals(actionRequest.getAction())) {
            if (actionRequest.getVariables() != null) {
                this.runtimeService.trigger(execution.getId(), this.getVariablesToSet(actionRequest));
            } else {
                this.runtimeService.trigger(execution.getId());
            }
        } else if ("signalEventReceived".equals(actionRequest.getAction())) {
            if (actionRequest.getSignalName() == null) {
                throw new ActivitiIllegalArgumentException("Signal name is required");
            }
            if (actionRequest.getVariables() != null) {
                this.runtimeService.signalEventReceived(actionRequest.getSignalName(), execution.getId(), this.getVariablesToSet(actionRequest));
            } else {
                this.runtimeService.signalEventReceived(actionRequest.getSignalName(), execution.getId());
            }
        } else if ("messageEventReceived".equals(actionRequest.getAction())) {
            if (actionRequest.getMessageName() == null) {
                throw new ActivitiIllegalArgumentException("Message name is required");
            }
            if (actionRequest.getVariables() != null) {
                this.runtimeService.messageEventReceived(actionRequest.getMessageName(), execution.getId(), this.getVariablesToSet(actionRequest));
            } else {
                this.runtimeService.messageEventReceived(actionRequest.getMessageName(), execution.getId());
            }
        } else {
            throw new ActivitiIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
        }
        execution = (Execution)this.runtimeService.createExecutionQuery().executionId(execution.getId()).singleResult();
        if (execution == null) {
            response.setStatus(HttpStatus.NO_CONTENT.value());
            return null;
        }
        return this.restResponseFactory.createExecutionResponse(execution);
    }
}

