/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event;

import java.util.Map;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.event.AbstractEventHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.impl.util.ProcessInstanceHelper;
import org.activiti.engine.repository.ProcessDefinition;

public class SignalEventHandler
extends AbstractEventHandler {
    public static final String EVENT_HANDLER_TYPE = "signal";

    @Override
    public String getEventHandlerType() {
        return EVENT_HANDLER_TYPE;
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        if (eventSubscription.getExecutionId() != null) {
            super.handleEvent(eventSubscription, payload, commandContext);
        } else if (eventSubscription.getProcessDefinitionId() != null) {
            String processDefinitionId = eventSubscription.getProcessDefinitionId();
            Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
            ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
            FlowElement flowElement = process.getFlowElement(eventSubscription.getActivityId(), true);
            if (flowElement == null) {
                throw new ActivitiException("Could not find matching FlowElement for activityId " + eventSubscription.getActivityId());
            }
            Map variables = null;
            if (payload != null && payload instanceof Map) {
                variables = (Map)payload;
            }
            ProcessInstanceHelper processInstanceHelper = commandContext.getProcessEngineConfiguration().getProcessInstanceHelper();
            processInstanceHelper.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, null, null, flowElement, process, variables, null, true);
        } else {
            throw new ActivitiException("Invalid signal handling: no execution nor process definition set");
        }
    }
}

