/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event;

import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.event.EventHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public abstract class AbstractEventHandler
implements EventHandler {
    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        ExecutionEntity execution = eventSubscription.getExecution();
        FlowNode currentFlowElement = (FlowNode)execution.getCurrentFlowElement();
        if (currentFlowElement == null) {
            throw new ActivitiException("Error while sending signal for event subscription '" + eventSubscription.getId() + "': no activity associated with event subscription");
        }
        if (payload instanceof Map) {
            Map processVariables = (Map)payload;
            execution.setVariables(processVariables);
        }
        if (currentFlowElement instanceof BoundaryEvent || currentFlowElement instanceof EventSubProcess) {
            try {
                this.dispatchActivitiesCanceledIfNeeded(eventSubscription, execution, (FlowElement)currentFlowElement, commandContext);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ActivitiException("exception while sending signal for event subscription '" + eventSubscription + "':" + e.getMessage(), e);
            }
        }
        Context.getAgenda().planTriggerExecutionOperation(execution);
    }

    protected void dispatchActivitiesCanceledIfNeeded(EventSubscriptionEntity eventSubscription, ExecutionEntity execution, FlowElement currentFlowElement, CommandContext commandContext) {
        BoundaryEvent boundaryEvent;
        if (currentFlowElement instanceof BoundaryEvent && (boundaryEvent = (BoundaryEvent)currentFlowElement).isCancelActivity()) {
            this.dispatchExecutionCancelled(eventSubscription, execution, commandContext);
        }
    }

    protected void dispatchExecutionCancelled(EventSubscriptionEntity eventSubscription, ExecutionEntity execution, CommandContext commandContext) {
        BoundaryEvent boundaryEvent;
        FlowElement flowElement;
        for (ExecutionEntity executionEntity : execution.getExecutions()) {
            this.dispatchExecutionCancelled(eventSubscription, executionEntity, commandContext);
        }
        ExecutionEntity subProcessInstance = commandContext.getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(eventSubscription, subProcessInstance, commandContext);
        }
        if ((flowElement = execution.getCurrentFlowElement()) != null && flowElement instanceof BoundaryEvent && (boundaryEvent = (BoundaryEvent)flowElement).getAttachedToRef() != null) {
            this.dispatchActivityCancelled(eventSubscription, execution, (FlowNode)boundaryEvent.getAttachedToRef(), commandContext);
        }
    }

    protected void dispatchActivityCancelled(EventSubscriptionEntity eventSubscription, ExecutionEntity boundaryEventExecution, FlowNode flowNode, CommandContext commandContext) {
        ExecutionEntity parentExecutionEntity;
        commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(flowNode.getId(), flowNode.getName(), boundaryEventExecution.getId(), boundaryEventExecution.getProcessInstanceId(), boundaryEventExecution.getProcessDefinitionId(), this.parseActivityType(flowNode), eventSubscription));
        if (flowNode instanceof SubProcess && (parentExecutionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(boundaryEventExecution.getParentId())) != null) {
            this.dispatchActivityCancelledForChildExecution(eventSubscription, parentExecutionEntity, boundaryEventExecution, commandContext);
        }
    }

    protected void dispatchActivityCancelledForChildExecution(EventSubscriptionEntity eventSubscription, ExecutionEntity parentExecutionEntity, ExecutionEntity boundaryEventExecution, CommandContext commandContext) {
        List<ExecutionEntity> executionEntities = commandContext.getExecutionEntityManager().findChildExecutionsByParentExecutionId(parentExecutionEntity.getId());
        for (ExecutionEntity childExecution : executionEntities) {
            if (boundaryEventExecution.getId().equals(childExecution.getId()) || childExecution.getCurrentFlowElement() == null || !(childExecution.getCurrentFlowElement() instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)childExecution.getCurrentFlowElement();
            commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(flowNode.getId(), flowNode.getName(), childExecution.getId(), childExecution.getProcessInstanceId(), childExecution.getProcessDefinitionId(), this.parseActivityType(flowNode), eventSubscription));
            if (!childExecution.isScope()) continue;
            this.dispatchActivityCancelledForChildExecution(eventSubscription, childExecution, boundaryEventExecution, commandContext);
        }
    }

    protected String parseActivityType(FlowNode flowNode) {
        String elementType = flowNode.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }
}

