/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.converter.util.InputStreamProvider;
import org.activiti.bpmn.exceptions.XMLException;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.event.impl.ActivitiEventSupport;
import org.activiti.engine.impl.bpmn.parser.BpmnParseHandlers;
import org.activiti.engine.impl.bpmn.parser.BpmnParser;
import org.activiti.engine.impl.bpmn.parser.factory.ActivityBehaviorFactory;
import org.activiti.engine.impl.bpmn.parser.factory.ListenerFactory;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.activiti.engine.impl.util.io.ResourceStreamSource;
import org.activiti.engine.impl.util.io.StreamSource;
import org.activiti.engine.impl.util.io.StringStreamSource;
import org.activiti.engine.impl.util.io.UrlStreamSource;
import org.activiti.validation.ProcessValidator;
import org.activiti.validation.ValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnParse
implements BpmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BpmnParse.class);
    public static final String PROPERTYNAME_INITIAL = "initial";
    public static final String PROPERTYNAME_INITIATOR_VARIABLE_NAME = "initiatorVariableName";
    public static final String PROPERTYNAME_CONDITION = "condition";
    public static final String PROPERTYNAME_CONDITION_TEXT = "conditionText";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";
    public static final String PROPERTYNAME_ISEXPANDED = "isExpanded";
    public static final String PROPERTYNAME_START_TIMER = "timerStart";
    public static final String PROPERTYNAME_COMPENSATION_HANDLER_ID = "compensationHandler";
    public static final String PROPERTYNAME_IS_FOR_COMPENSATION = "isForCompensation";
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = "errorEventDefinitions";
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION = "eventDefinitions";
    protected String name;
    protected boolean validateSchema = true;
    protected boolean validateProcess = true;
    protected StreamSource streamSource;
    protected String sourceSystemId;
    protected BpmnModel bpmnModel;
    protected String targetNamespace;
    protected DeploymentEntity deployment;
    protected List<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
    protected Map<String, SequenceFlow> sequenceFlows;
    protected BpmnParseHandlers bpmnParserHandlers;
    protected ProcessDefinitionEntity currentProcessDefinition;
    protected Process currentProcess;
    protected FlowElement currentFlowElement;
    protected LinkedList<SubProcess> currentSubprocessStack = new LinkedList();
    protected Map<String, String> prefixs = new HashMap<String, String>();
    protected ActivityBehaviorFactory activityBehaviorFactory;
    protected ListenerFactory listenerFactory;

    public BpmnParse(BpmnParser parser) {
        this.activityBehaviorFactory = parser.getActivityBehaviorFactory();
        this.listenerFactory = parser.getListenerFactory();
        this.bpmnParserHandlers = parser.getBpmnParserHandlers();
    }

    public BpmnParse deployment(DeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public BpmnParse execute() {
        try {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            BpmnXMLConverter converter = new BpmnXMLConverter();
            boolean enableSafeBpmnXml = false;
            String encoding = null;
            if (processEngineConfiguration != null) {
                enableSafeBpmnXml = processEngineConfiguration.isEnableSafeBpmnXml();
                encoding = processEngineConfiguration.getXmlEncoding();
            }
            this.bpmnModel = encoding != null ? converter.convertToBpmnModel((InputStreamProvider)this.streamSource, this.validateSchema, enableSafeBpmnXml, encoding) : converter.convertToBpmnModel((InputStreamProvider)this.streamSource, this.validateSchema, enableSafeBpmnXml);
            if (this.validateProcess) {
                ProcessValidator processValidator = processEngineConfiguration.getProcessValidator();
                if (processValidator == null) {
                    LOGGER.warn("Process should be validated, but no process validator is configured on the process engine configuration!");
                } else {
                    List validationErrors = processValidator.validate(this.bpmnModel);
                    if (validationErrors != null && !validationErrors.isEmpty()) {
                        StringBuilder warningBuilder = new StringBuilder();
                        StringBuilder errorBuilder = new StringBuilder();
                        for (ValidationError error : validationErrors) {
                            if (error.isWarning()) {
                                warningBuilder.append(error.toString());
                                warningBuilder.append("\n");
                                continue;
                            }
                            errorBuilder.append(error.toString());
                            errorBuilder.append("\n");
                        }
                        if (errorBuilder.length() > 0) {
                            throw new ActivitiException("Errors while parsing:\n" + errorBuilder.toString());
                        }
                        if (warningBuilder.length() > 0) {
                            LOGGER.warn("Following warnings encountered during process validation: " + warningBuilder.toString());
                        }
                    }
                }
            }
            this.bpmnModel.setSourceSystemId(this.sourceSystemId);
            this.bpmnModel.setEventSupport((Object)new ActivitiEventSupport());
            this.applyParseHandlers();
            this.processDI();
        }
        catch (Exception e) {
            if (e instanceof ActivitiException) {
                throw (ActivitiException)e;
            }
            if (e instanceof XMLException) {
                throw (XMLException)e;
            }
            throw new ActivitiException("Error parsing XML", e);
        }
        return this;
    }

    public BpmnParse name(String name) {
        this.name = name;
        return this;
    }

    public BpmnParse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource(new InputStreamSource(inputStream));
        return this;
    }

    public BpmnParse sourceResource(String resource) {
        return this.sourceResource(resource, null);
    }

    public BpmnParse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource(new UrlStreamSource(url));
        return this;
    }

    public BpmnParse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new ActivitiIllegalArgumentException("malformed url: " + url, e);
        }
    }

    public BpmnParse sourceResource(String resource, ClassLoader classLoader) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource, classLoader));
        return this;
    }

    public BpmnParse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource(new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw new ActivitiIllegalArgumentException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    public BpmnParse setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    protected void applyParseHandlers() {
        this.sequenceFlows = new HashMap<String, SequenceFlow>();
        Iterator iterator = this.bpmnModel.getProcesses().iterator();
        while (iterator.hasNext()) {
            Process process;
            this.currentProcess = process = (Process)iterator.next();
            if (!process.isExecutable()) continue;
            this.bpmnParserHandlers.parseElement(this, (BaseElement)process);
        }
    }

    public void processFlowElements(Collection<FlowElement> flowElements) {
        ArrayList<SequenceFlow> sequenceFlowToParse = new ArrayList<SequenceFlow>();
        ArrayList<BoundaryEvent> boundaryEventsToParse = new ArrayList<BoundaryEvent>();
        ArrayList<FlowElement> defferedFlowElementsToParse = new ArrayList<FlowElement>();
        for (FlowElement flowElement : flowElements) {
            if (flowElement instanceof SequenceFlow) {
                sequenceFlowToParse.add((SequenceFlow)flowElement);
                continue;
            }
            if (flowElement instanceof BoundaryEvent) {
                boundaryEventsToParse.add((BoundaryEvent)flowElement);
                continue;
            }
            if (flowElement instanceof Event) {
                defferedFlowElementsToParse.add(flowElement);
                continue;
            }
            this.bpmnParserHandlers.parseElement(this, (BaseElement)flowElement);
        }
        for (FlowElement flowElement : defferedFlowElementsToParse) {
            this.bpmnParserHandlers.parseElement(this, (BaseElement)flowElement);
        }
        for (BoundaryEvent boundaryEvent : boundaryEventsToParse) {
            this.bpmnParserHandlers.parseElement(this, (BaseElement)boundaryEvent);
        }
        for (SequenceFlow sequenceFlow : sequenceFlowToParse) {
            this.bpmnParserHandlers.parseElement(this, (BaseElement)sequenceFlow);
        }
    }

    public void processDI() {
        if (this.processDefinitions.isEmpty()) {
            return;
        }
        if (!this.bpmnModel.getLocationMap().isEmpty()) {
            for (String bpmnReference : this.bpmnModel.getLocationMap().keySet()) {
                if (this.bpmnModel.getFlowElement(bpmnReference) == null) {
                    if (this.bpmnModel.getArtifact(bpmnReference) != null || this.bpmnModel.getPool(bpmnReference) != null || this.bpmnModel.getLane(bpmnReference) != null) continue;
                    LOGGER.warn("Invalid reference in diagram interchange definition: could not find " + bpmnReference);
                    continue;
                }
                if (this.bpmnModel.getFlowElement(bpmnReference) instanceof FlowNode) continue;
                LOGGER.warn("Invalid reference in diagram interchange definition: " + bpmnReference + " does not reference a flow node");
            }
            for (String bpmnReference : this.bpmnModel.getFlowLocationMap().keySet()) {
                if (this.bpmnModel.getFlowElement(bpmnReference) == null) {
                    if (this.bpmnModel.getArtifact(bpmnReference) != null) continue;
                    LOGGER.warn("Invalid reference in diagram interchange definition: could not find " + bpmnReference);
                    continue;
                }
                if (this.bpmnModel.getFlowElement(bpmnReference) instanceof SequenceFlow) continue;
                LOGGER.warn("Invalid reference in diagram interchange definition: " + bpmnReference + " does not reference a sequence flow");
            }
            for (Process process : this.bpmnModel.getProcesses()) {
                ProcessDefinitionEntity processDefinition;
                if (!process.isExecutable() || (processDefinition = this.getProcessDefinition(process.getId())) == null) continue;
                processDefinition.setGraphicalNotationDefined(true);
                for (String edgeId : this.bpmnModel.getFlowLocationMap().keySet()) {
                    if (this.bpmnModel.getFlowElement(edgeId) == null) continue;
                    this.createBPMNEdge(edgeId, this.bpmnModel.getFlowLocationGraphicInfo(edgeId));
                }
            }
        }
    }

    public void createBPMNEdge(String key, List<GraphicInfo> graphicList) {
        FlowElement flowElement = this.bpmnModel.getFlowElement(key);
        if (flowElement != null && flowElement instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            ArrayList<Integer> waypoints = new ArrayList<Integer>();
            for (GraphicInfo waypointInfo : graphicList) {
                waypoints.add((int)waypointInfo.getX());
                waypoints.add((int)waypointInfo.getY());
            }
            sequenceFlow.setWaypoints(waypoints);
        } else if (this.bpmnModel.getArtifact(key) == null) {
            LOGGER.warn("Invalid reference in 'bpmnElement' attribute, sequenceFlow " + key + " not found");
        }
    }

    public ProcessDefinitionEntity getProcessDefinition(String processDefinitionKey) {
        for (ProcessDefinitionEntity processDefinition : this.processDefinitions) {
            if (!processDefinition.getKey().equals(processDefinitionKey)) continue;
            return processDefinition;
        }
        return null;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public boolean isValidateProcess() {
        return this.validateProcess;
    }

    public void setValidateProcess(boolean validateProcess) {
        this.validateProcess = validateProcess;
    }

    public List<ProcessDefinitionEntity> getProcessDefinitions() {
        return this.processDefinitions;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public BpmnParseHandlers getBpmnParserHandlers() {
        return this.bpmnParserHandlers;
    }

    public void setBpmnParserHandlers(BpmnParseHandlers bpmnParserHandlers) {
        this.bpmnParserHandlers = bpmnParserHandlers;
    }

    public DeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(DeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public BpmnModel getBpmnModel() {
        return this.bpmnModel;
    }

    public void setBpmnModel(BpmnModel bpmnModel) {
        this.bpmnModel = bpmnModel;
    }

    public ActivityBehaviorFactory getActivityBehaviorFactory() {
        return this.activityBehaviorFactory;
    }

    public void setActivityBehaviorFactory(ActivityBehaviorFactory activityBehaviorFactory) {
        this.activityBehaviorFactory = activityBehaviorFactory;
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public void setListenerFactory(ListenerFactory listenerFactory) {
        this.listenerFactory = listenerFactory;
    }

    public Map<String, SequenceFlow> getSequenceFlows() {
        return this.sequenceFlows;
    }

    public ProcessDefinitionEntity getCurrentProcessDefinition() {
        return this.currentProcessDefinition;
    }

    public void setCurrentProcessDefinition(ProcessDefinitionEntity currentProcessDefinition) {
        this.currentProcessDefinition = currentProcessDefinition;
    }

    public FlowElement getCurrentFlowElement() {
        return this.currentFlowElement;
    }

    public void setCurrentFlowElement(FlowElement currentFlowElement) {
        this.currentFlowElement = currentFlowElement;
    }

    public Process getCurrentProcess() {
        return this.currentProcess;
    }

    public void setCurrentProcess(Process currentProcess) {
        this.currentProcess = currentProcess;
    }

    public void setCurrentSubProcess(SubProcess subProcess) {
        this.currentSubprocessStack.push(subProcess);
    }

    public SubProcess getCurrentSubProcess() {
        return this.currentSubprocessStack.peek();
    }

    public void removeCurrentSubProcess() {
        this.currentSubprocessStack.pop();
    }
}

