/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.HashSet;
import java.util.List;
import org.activiti.bpmn.model.EventGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;

public class IntermediateCatchEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(DelegateExecution execution) {
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        this.leaveIntermediateCatchEvent(execution);
    }

    public void leaveIntermediateCatchEvent(DelegateExecution execution) {
        EventGateway eventGateway = this.getPrecedingEventBasedGateway(execution);
        if (eventGateway != null) {
            this.deleteOtherEventsRelatedToEventBasedGateway(execution, eventGateway);
        }
        this.leave(execution);
    }

    public void eventCancelledByEventGateway(DelegateExecution execution) {
        Context.getCommandContext().getExecutionEntityManager().deleteExecutionAndRelatedData((ExecutionEntity)execution, "event based gateway cancel", false);
    }

    protected EventGateway getPrecedingEventBasedGateway(DelegateExecution execution) {
        SequenceFlow sequenceFlow;
        FlowElement sourceFlowElement;
        IntermediateCatchEvent intermediateCatchEvent;
        List incomingSequenFlow;
        FlowElement currentFlowElement = execution.getCurrentFlowElement();
        if (currentFlowElement != null && currentFlowElement instanceof IntermediateCatchEvent && (incomingSequenFlow = (intermediateCatchEvent = (IntermediateCatchEvent)currentFlowElement).getIncomingFlows()) != null && incomingSequenFlow.size() == 1 && (sourceFlowElement = (sequenceFlow = (SequenceFlow)incomingSequenFlow.get(0)).getSourceFlowElement()) instanceof EventGateway) {
            return (EventGateway)sourceFlowElement;
        }
        return null;
    }

    protected void deleteOtherEventsRelatedToEventBasedGateway(DelegateExecution execution, EventGateway eventGateway) {
        List outgoingSequenceFlows = eventGateway.getOutgoingFlows();
        HashSet<String> eventActivityIds = new HashSet<String>(outgoingSequenceFlows.size() - 1);
        for (SequenceFlow outgoingSequenceFlow : outgoingSequenceFlows) {
            if (outgoingSequenceFlow.getTargetFlowElement() == null || outgoingSequenceFlow.getTargetFlowElement().getId().equals(execution.getCurrentActivityId())) continue;
            eventActivityIds.add(outgoingSequenceFlow.getTargetFlowElement().getId());
        }
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        List<ExecutionEntity> executionEntities = executionEntityManager.findExecutionsByParentExecutionAndActivityIds(execution.getParentId(), eventActivityIds);
        for (ExecutionEntity executionEntity : executionEntities) {
            IntermediateCatchEvent intermediateCatchEvent;
            if (!eventActivityIds.contains(executionEntity.getActivityId()) || !(execution.getCurrentFlowElement() instanceof IntermediateCatchEvent) || !((intermediateCatchEvent = (IntermediateCatchEvent)execution.getCurrentFlowElement()).getBehavior() instanceof IntermediateCatchEventActivityBehavior)) continue;
            ((IntermediateCatchEventActivityBehavior)intermediateCatchEvent.getBehavior()).eventCancelledByEventGateway(executionEntity);
            eventActivityIds.remove(executionEntity.getActivityId());
        }
    }
}

