/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.CollectionUtil;

public class CancelEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(DelegateExecution execution) {
        SubProcess subProcess;
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        DelegateExecution parentScopeExecution = null;
        ExecutionEntity currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(executionEntity.getParentId());
        while (currentlyExaminedExecution != null && parentScopeExecution == null) {
            if (currentlyExaminedExecution.getCurrentFlowElement() instanceof SubProcess) {
                ExecutionEntity miExecution;
                FlowElement miElement;
                parentScopeExecution = currentlyExaminedExecution;
                subProcess = (SubProcess)currentlyExaminedExecution.getCurrentFlowElement();
                if (subProcess.getLoopCharacteristics() == null || (miElement = (miExecution = parentScopeExecution.getParent()).getCurrentFlowElement()) == null || !miElement.getId().equals(subProcess.getId())) continue;
                parentScopeExecution = miExecution;
                continue;
            }
            currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
        }
        if (parentScopeExecution == null) {
            throw new ActivitiException("No sub process execution found for cancel end event " + executionEntity.getCurrentActivityId());
        }
        subProcess = (SubProcess)parentScopeExecution.getCurrentFlowElement();
        BoundaryEvent cancelBoundaryEvent = null;
        if (CollectionUtil.isNotEmpty(subProcess.getBoundaryEvents())) {
            for (BoundaryEvent boundaryEvent : subProcess.getBoundaryEvents()) {
                if (!CollectionUtil.isNotEmpty(boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CancelEventDefinition)) continue;
                cancelBoundaryEvent = boundaryEvent;
                break;
            }
        }
        if (cancelBoundaryEvent == null) {
            throw new ActivitiException("Could not find cancel boundary event for cancel end event " + executionEntity.getCurrentActivityId());
        }
        ExecutionEntity newParentScopeExecution = null;
        currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(parentScopeExecution.getParentId());
        while (currentlyExaminedExecution != null && newParentScopeExecution == null) {
            if (currentlyExaminedExecution.isScope()) {
                newParentScopeExecution = currentlyExaminedExecution;
                continue;
            }
            currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
        }
        if (newParentScopeExecution == null) {
            throw new ActivitiException("Programmatic error: no parent scope execution found for boundary event " + cancelBoundaryEvent.getId());
        }
        ScopeUtil.createCopyOfSubProcessExecutionForCompensation((ExecutionEntity)parentScopeExecution);
        if (subProcess.getLoopCharacteristics() != null) {
            List<? extends ExecutionEntity> multiInstanceExecutions = parentScopeExecution.getExecutions();
            ArrayList<ExecutionEntity> executionsToDelete = new ArrayList<ExecutionEntity>();
            for (ExecutionEntity executionEntity2 : multiInstanceExecutions) {
                if (executionEntity2.getId().equals(parentScopeExecution.getId())) continue;
                ScopeUtil.createCopyOfSubProcessExecutionForCompensation(executionEntity2);
                executionsToDelete.add(executionEntity2);
                this.deleteChildExecutions(executionEntity2, executionEntity, commandContext, "transaction canceled");
            }
            for (ExecutionEntity executionEntity3 : executionsToDelete) {
                this.deleteChildExecutions(executionEntity3, executionEntity, commandContext, "transaction canceled");
            }
        }
        commandContext.getHistoryManager().recordActivityEnd(executionEntity, null);
        executionEntity.setParent(newParentScopeExecution);
        executionEntity.setCurrentFlowElement((FlowElement)cancelBoundaryEvent);
        this.deleteChildExecutions((ExecutionEntity)parentScopeExecution, executionEntity, commandContext, "transaction canceled");
        commandContext.getHistoryManager().recordActivityEnd((ExecutionEntity)parentScopeExecution, "transaction canceled");
        commandContext.getAgenda().planTriggerExecutionOperation(executionEntity);
    }

    protected void deleteChildExecutions(ExecutionEntity parentExecution, ExecutionEntity notToDeleteExecution, CommandContext commandContext, String deleteReason) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        if (CollectionUtil.isNotEmpty(childExecutions)) {
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getId().equals(notToDeleteExecution.getId())) continue;
                this.deleteChildExecutions(childExecution, notToDeleteExecution, commandContext, deleteReason);
            }
        }
        executionEntityManager.deleteExecutionAndRelatedData(parentExecution, deleteReason, false);
    }
}

