/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.asyncexecutor.JobManager;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.calendar.CycleBusinessCalendar;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.NoExecutionVariableScope;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.AsyncJobAddedNotification;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.entity.AbstractJobEntity;
import org.activiti.engine.impl.persistence.entity.DeadLetterJobEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.SuspendedJobEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntityManager;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.impl.util.TimerUtil;
import org.activiti.engine.runtime.Job;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJobManager
implements JobManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultJobManager.class);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultJobManager() {
    }

    public DefaultJobManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public JobEntity createAsyncJob(ExecutionEntity execution, boolean exclusive) {
        JobEntity jobEntity = null;
        jobEntity = this.isAsyncExecutorActive() ? this.internalCreateLockedAsyncJob(execution, exclusive) : this.internalCreateAsyncJob(execution, exclusive);
        return jobEntity;
    }

    @Override
    public void scheduleAsyncJob(JobEntity jobEntity) {
        this.processEngineConfiguration.getJobEntityManager().insert(jobEntity);
        this.triggerExecutorIfNeeded(jobEntity);
    }

    protected void triggerExecutorIfNeeded(JobEntity jobEntity) {
        if (this.isAsyncExecutorActive()) {
            this.hintAsyncExecutor(jobEntity);
        }
    }

    @Override
    public TimerJobEntity createTimerJob(TimerEventDefinition timerEventDefinition, boolean interrupting, ExecutionEntity execution, String timerEventType, String jobHandlerConfiguration) {
        TimerJobEntity timerEntity = TimerUtil.createTimerEntityForTimerEventDefinition(timerEventDefinition, interrupting, execution, timerEventType, jobHandlerConfiguration);
        return timerEntity;
    }

    @Override
    public void scheduleTimerJob(TimerJobEntity timerJob) {
        if (timerJob == null) {
            throw new ActivitiException("Empty timer job can not be scheduled");
        }
        this.processEngineConfiguration.getTimerJobEntityManager().insert(timerJob);
    }

    @Override
    public JobEntity moveTimerJobToExecutableJob(TimerJobEntity timerJob) {
        if (timerJob == null) {
            throw new ActivitiException("Empty timer job can not be scheduled");
        }
        JobEntity executableJob = this.createExecutableJobFromOtherJob(timerJob);
        boolean insertSuccesful = this.processEngineConfiguration.getJobEntityManager().insertJobEntity(executableJob);
        if (insertSuccesful) {
            this.processEngineConfiguration.getTimerJobEntityManager().delete(timerJob);
            this.triggerExecutorIfNeeded(executableJob);
            return executableJob;
        }
        return null;
    }

    @Override
    public TimerJobEntity moveJobToTimerJob(AbstractJobEntity job) {
        TimerJobEntity timerJob = this.createTimerJobFromOtherJob(job);
        boolean insertSuccesful = this.processEngineConfiguration.getTimerJobEntityManager().insertTimerJobEntity(timerJob);
        if (insertSuccesful) {
            if (job instanceof JobEntity) {
                this.processEngineConfiguration.getJobEntityManager().delete((JobEntity)job);
            } else if (job instanceof SuspendedJobEntity) {
                this.processEngineConfiguration.getSuspendedJobEntityManager().delete((SuspendedJobEntity)job);
            }
            return timerJob;
        }
        return null;
    }

    @Override
    public SuspendedJobEntity moveJobToSuspendedJob(AbstractJobEntity job) {
        SuspendedJobEntity suspendedJob = this.createSuspendedJobFromOtherJob(job);
        this.processEngineConfiguration.getSuspendedJobEntityManager().insert(suspendedJob);
        if (job instanceof TimerJobEntity) {
            this.processEngineConfiguration.getTimerJobEntityManager().delete((TimerJobEntity)job);
        } else if (job instanceof JobEntity) {
            this.processEngineConfiguration.getJobEntityManager().delete((JobEntity)job);
        }
        return suspendedJob;
    }

    @Override
    public AbstractJobEntity activateSuspendedJob(SuspendedJobEntity job) {
        AbstractJobEntity activatedJob = null;
        if ("timer".equals(job.getJobType())) {
            activatedJob = this.createTimerJobFromOtherJob(job);
            this.processEngineConfiguration.getTimerJobEntityManager().insert(activatedJob);
        } else {
            activatedJob = this.createExecutableJobFromOtherJob(job);
            JobEntity jobEntity = (JobEntity)activatedJob;
            this.processEngineConfiguration.getJobEntityManager().insert(jobEntity);
            this.triggerExecutorIfNeeded(jobEntity);
        }
        this.processEngineConfiguration.getSuspendedJobEntityManager().delete(job);
        return activatedJob;
    }

    @Override
    public DeadLetterJobEntity moveJobToDeadLetterJob(AbstractJobEntity job) {
        DeadLetterJobEntity deadLetterJob = this.createDeadLetterJobFromOtherJob(job);
        this.processEngineConfiguration.getDeadLetterJobEntityManager().insert(deadLetterJob);
        if (job instanceof TimerJobEntity) {
            this.processEngineConfiguration.getTimerJobEntityManager().delete((TimerJobEntity)job);
        } else if (job instanceof JobEntity) {
            this.processEngineConfiguration.getJobEntityManager().delete((JobEntity)job);
        }
        return deadLetterJob;
    }

    @Override
    public JobEntity moveDeadLetterJobToExecutableJob(DeadLetterJobEntity deadLetterJobEntity, int retries) {
        if (deadLetterJobEntity == null) {
            throw new ActivitiIllegalArgumentException("Null job provided");
        }
        JobEntity executableJob = this.createExecutableJobFromOtherJob(deadLetterJobEntity);
        executableJob.setRetries(retries);
        boolean insertSuccesful = this.processEngineConfiguration.getJobEntityManager().insertJobEntity(executableJob);
        if (insertSuccesful) {
            this.processEngineConfiguration.getDeadLetterJobEntityManager().delete(deadLetterJobEntity);
            this.triggerExecutorIfNeeded(executableJob);
            return executableJob;
        }
        return null;
    }

    @Override
    public void execute(Job job) {
        if (job instanceof JobEntity) {
            if ("message".equals(job.getJobType())) {
                this.executeMessageJob((JobEntity)job);
            } else if ("timer".equals(job.getJobType())) {
                this.executeTimerJob((JobEntity)job);
            }
        } else {
            throw new ActivitiException("Only jobs with type JobEntity are supported to be executed");
        }
    }

    @Override
    public void unacquire(Job job) {
        if (job instanceof JobEntity) {
            JobEntity jobEntity = (JobEntity)job;
            this.processEngineConfiguration.getJobEntityManager().delete(jobEntity.getId());
            JobEntity newJobEntity = (JobEntity)this.processEngineConfiguration.getJobEntityManager().create();
            this.copyJobInfo(newJobEntity, jobEntity);
            newJobEntity.setId(null);
            newJobEntity.setLockExpirationTime(null);
            newJobEntity.setLockOwner(null);
            this.processEngineConfiguration.getJobEntityManager().insert(newJobEntity);
        } else {
            this.processEngineConfiguration.getJobEntityManager().resetExpiredJob(job.getId());
        }
    }

    protected void executeMessageJob(JobEntity jobEntity) {
        this.executeJobHandler(jobEntity);
        if (jobEntity.getId() != null) {
            Context.getCommandContext().getJobEntityManager().delete(jobEntity);
        }
    }

    protected void executeTimerJob(JobEntity timerEntity) {
        TimerJobEntity newTimerJobEntity;
        TimerJobEntityManager timerJobEntityManager = this.processEngineConfiguration.getTimerJobEntityManager();
        VariableScope variableScope = null;
        if (timerEntity.getExecutionId() != null) {
            variableScope = (VariableScope)this.getExecutionEntityManager().findById(timerEntity.getExecutionId());
        }
        if (variableScope == null) {
            variableScope = NoExecutionVariableScope.getSharedInstance();
        }
        this.restoreExtraData(timerEntity, variableScope);
        if (timerEntity.getDuedate() != null && !this.isValidTime(timerEntity, timerEntity.getDuedate(), variableScope)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Timer {} fired. but the dueDate is after the endDate.  Deleting timer.", (Object)timerEntity.getId());
            }
            this.processEngineConfiguration.getJobEntityManager().delete(timerEntity);
            return;
        }
        this.executeJobHandler(timerEntity);
        this.processEngineConfiguration.getJobEntityManager().delete(timerEntity);
        if (logger.isDebugEnabled()) {
            logger.debug("Timer {} fired. Deleting timer.", (Object)timerEntity.getId());
        }
        if (timerEntity.getRepeat() != null && (newTimerJobEntity = timerJobEntityManager.createAndCalculateNextTimer(timerEntity, variableScope)) != null) {
            timerJobEntityManager.insert(newTimerJobEntity);
        }
    }

    protected void executeJobHandler(JobEntity jobEntity) {
        ExecutionEntity execution = null;
        if (jobEntity.getExecutionId() != null) {
            execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId());
        }
        Map<String, JobHandler> jobHandlers = this.processEngineConfiguration.getJobHandlers();
        JobHandler jobHandler = jobHandlers.get(jobEntity.getJobHandlerType());
        jobHandler.execute(jobEntity, jobEntity.getJobHandlerConfiguration(), execution, this.getCommandContext());
    }

    protected void restoreExtraData(JobEntity timerEntity, VariableScope variableScope) {
        Process process;
        String activityId = timerEntity.getJobHandlerConfiguration();
        if (timerEntity.getJobHandlerType().equalsIgnoreCase("timer-start-event") || timerEntity.getJobHandlerType().equalsIgnoreCase("trigger-timer")) {
            activityId = TimerEventHandler.getActivityIdFromConfiguration(timerEntity.getJobHandlerConfiguration());
            String endDateExpressionString = TimerEventHandler.getEndDateFromConfiguration(timerEntity.getJobHandlerConfiguration());
            if (endDateExpressionString != null) {
                Expression endDateExpression = this.processEngineConfiguration.getExpressionManager().createExpression(endDateExpressionString);
                String endDateString = null;
                BusinessCalendar businessCalendar = this.processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(TimerEventHandler.geCalendarNameFromConfiguration(timerEntity.getJobHandlerConfiguration()), variableScope));
                if (endDateExpression != null) {
                    Object endDateValue = endDateExpression.getValue(variableScope);
                    if (endDateValue instanceof String) {
                        endDateString = (String)endDateValue;
                    } else if (endDateValue instanceof Date) {
                        timerEntity.setEndDate((Date)endDateValue);
                    } else {
                        throw new ActivitiException("Timer '" + ((ExecutionEntity)variableScope).getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
                    }
                    if (timerEntity.getEndDate() == null) {
                        timerEntity.setEndDate(businessCalendar.resolveEndDate(endDateString));
                    }
                }
            }
        }
        int maxIterations = 1;
        if (timerEntity.getProcessDefinitionId() != null && (maxIterations = this.getMaxIterations(process = ProcessDefinitionUtil.getProcess(timerEntity.getProcessDefinitionId()), activityId)) <= 1) {
            maxIterations = this.getMaxIterations(process, activityId);
        }
        timerEntity.setMaxIterations(maxIterations);
    }

    protected int getMaxIterations(Process process, String activityId) {
        Event event;
        List eventDefinitions;
        FlowElement flowElement = process.getFlowElement(activityId, true);
        if (flowElement != null && flowElement instanceof Event && (eventDefinitions = (event = (Event)flowElement).getEventDefinitions()) != null) {
            for (EventDefinition eventDefinition : eventDefinitions) {
                TimerEventDefinition timerEventDefinition;
                if (!(eventDefinition instanceof TimerEventDefinition) || (timerEventDefinition = (TimerEventDefinition)eventDefinition).getTimeCycle() == null) continue;
                return this.calculateMaxIterationsValue(timerEventDefinition.getTimeCycle());
            }
        }
        return -1;
    }

    protected int calculateMaxIterationsValue(String originalExpression) {
        int times = Integer.MAX_VALUE;
        List<String> expression = Arrays.asList(originalExpression.split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R")) {
            times = Integer.MAX_VALUE;
            if (expression.get(0).length() > 1) {
                times = Integer.parseInt(expression.get(0).substring(1));
            }
        }
        return times;
    }

    protected boolean isValidTime(JobEntity timerEntity, Date newTimerDate, VariableScope variableScope) {
        BusinessCalendar businessCalendar = this.processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(TimerEventHandler.geCalendarNameFromConfiguration(timerEntity.getJobHandlerConfiguration()), variableScope));
        return businessCalendar.validateDuedate(timerEntity.getRepeat(), timerEntity.getMaxIterations(), timerEntity.getEndDate(), newTimerDate);
    }

    protected String getBusinessCalendarName(String calendarName, VariableScope variableScope) {
        String businessCalendarName = CycleBusinessCalendar.NAME;
        if (StringUtils.isNotEmpty((CharSequence)calendarName)) {
            businessCalendarName = (String)Context.getProcessEngineConfiguration().getExpressionManager().createExpression(calendarName).getValue(variableScope);
        }
        return businessCalendarName;
    }

    protected void hintAsyncExecutor(JobEntity job) {
        AsyncJobAddedNotification jobAddedNotification = new AsyncJobAddedNotification(job, this.getAsyncExecutor());
        this.getCommandContext().addCloseListener(jobAddedNotification);
    }

    protected JobEntity internalCreateAsyncJob(ExecutionEntity execution, boolean exclusive) {
        JobEntity asyncJob = (JobEntity)this.processEngineConfiguration.getJobEntityManager().create();
        this.fillDefaultAsyncJobInfo(asyncJob, execution, exclusive);
        return asyncJob;
    }

    protected JobEntity internalCreateLockedAsyncJob(ExecutionEntity execution, boolean exclusive) {
        JobEntity asyncJob = (JobEntity)this.processEngineConfiguration.getJobEntityManager().create();
        this.fillDefaultAsyncJobInfo(asyncJob, execution, exclusive);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.processEngineConfiguration.getClock().getCurrentTime());
        gregorianCalendar.add(14, this.getAsyncExecutor().getAsyncJobLockTimeInMillis());
        asyncJob.setLockExpirationTime(gregorianCalendar.getTime());
        asyncJob.setLockOwner(this.getAsyncExecutor().getLockOwner());
        return asyncJob;
    }

    protected void fillDefaultAsyncJobInfo(JobEntity jobEntity, ExecutionEntity execution, boolean exclusive) {
        jobEntity.setJobType("message");
        jobEntity.setRevision(1);
        jobEntity.setRetries(this.processEngineConfiguration.getAsyncExecutorNumberOfRetries());
        jobEntity.setExecutionId(execution.getId());
        jobEntity.setProcessInstanceId(execution.getProcessInstanceId());
        jobEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        jobEntity.setExclusive(exclusive);
        jobEntity.setJobHandlerType("async-continuation");
        if (execution.getTenantId() != null) {
            jobEntity.setTenantId(execution.getTenantId());
        }
    }

    protected JobEntity createExecutableJobFromOtherJob(AbstractJobEntity job) {
        JobEntity executableJob = (JobEntity)this.processEngineConfiguration.getJobEntityManager().create();
        this.copyJobInfo(executableJob, job);
        if (this.isAsyncExecutorActive()) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(this.processEngineConfiguration.getClock().getCurrentTime());
            gregorianCalendar.add(14, this.getAsyncExecutor().getTimerLockTimeInMillis());
            executableJob.setLockExpirationTime(gregorianCalendar.getTime());
            executableJob.setLockOwner(this.getAsyncExecutor().getLockOwner());
        }
        return executableJob;
    }

    protected TimerJobEntity createTimerJobFromOtherJob(AbstractJobEntity otherJob) {
        TimerJobEntity timerJob = (TimerJobEntity)this.processEngineConfiguration.getTimerJobEntityManager().create();
        this.copyJobInfo(timerJob, otherJob);
        return timerJob;
    }

    protected SuspendedJobEntity createSuspendedJobFromOtherJob(AbstractJobEntity otherJob) {
        SuspendedJobEntity suspendedJob = (SuspendedJobEntity)this.processEngineConfiguration.getSuspendedJobEntityManager().create();
        this.copyJobInfo(suspendedJob, otherJob);
        return suspendedJob;
    }

    protected DeadLetterJobEntity createDeadLetterJobFromOtherJob(AbstractJobEntity otherJob) {
        DeadLetterJobEntity deadLetterJob = (DeadLetterJobEntity)this.processEngineConfiguration.getDeadLetterJobEntityManager().create();
        this.copyJobInfo(deadLetterJob, otherJob);
        return deadLetterJob;
    }

    protected AbstractJobEntity copyJobInfo(AbstractJobEntity copyToJob, AbstractJobEntity copyFromJob) {
        copyToJob.setDuedate(copyFromJob.getDuedate());
        copyToJob.setEndDate(copyFromJob.getEndDate());
        copyToJob.setExclusive(copyFromJob.isExclusive());
        copyToJob.setExecutionId(copyFromJob.getExecutionId());
        copyToJob.setId(copyFromJob.getId());
        copyToJob.setJobHandlerConfiguration(copyFromJob.getJobHandlerConfiguration());
        copyToJob.setJobHandlerType(copyFromJob.getJobHandlerType());
        copyToJob.setJobType(copyFromJob.getJobType());
        copyToJob.setExceptionMessage(copyFromJob.getExceptionMessage());
        copyToJob.setExceptionStacktrace(copyFromJob.getExceptionStacktrace());
        copyToJob.setMaxIterations(copyFromJob.getMaxIterations());
        copyToJob.setProcessDefinitionId(copyFromJob.getProcessDefinitionId());
        copyToJob.setProcessInstanceId(copyFromJob.getProcessInstanceId());
        copyToJob.setRepeat(copyFromJob.getRepeat());
        copyToJob.setRetries(copyFromJob.getRetries());
        copyToJob.setRevision(copyFromJob.getRevision());
        copyToJob.setTenantId(copyFromJob.getTenantId());
        return copyToJob;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    @Override
    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    protected boolean isAsyncExecutorActive() {
        return this.processEngineConfiguration.getAsyncExecutor().isActive();
    }

    protected CommandContext getCommandContext() {
        return Context.getCommandContext();
    }

    protected AsyncExecutor getAsyncExecutor() {
        return this.processEngineConfiguration.getAsyncExecutor();
    }

    protected ExecutionEntityManager getExecutionEntityManager() {
        return this.processEngineConfiguration.getExecutionEntityManager();
    }
}

