/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.activiti.engine.impl.asyncexecutor.AcquireAsyncJobsDueRunnable;
import org.activiti.engine.impl.asyncexecutor.AcquireTimerJobsRunnable;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.activiti.engine.impl.asyncexecutor.ExecuteAsyncRunnableFactory;
import org.activiti.engine.impl.asyncexecutor.ResetExpiredJobsRunnable;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.runtime.Job;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncJobExecutor
implements AsyncExecutor {
    private static Logger log = LoggerFactory.getLogger(DefaultAsyncJobExecutor.class);
    protected int corePoolSize = 2;
    protected int maxPoolSize = 10;
    protected long keepAliveTime = 5000L;
    protected int queueSize = 100;
    protected BlockingQueue<Runnable> threadPoolQueue;
    protected ExecutorService executorService;
    protected long secondsToWaitOnShutdown = 60L;
    protected Thread timerJobAcquisitionThread;
    protected Thread asyncJobAcquisitionThread;
    protected Thread resetExpiredJobThread;
    protected AcquireTimerJobsRunnable timerJobRunnable;
    protected AcquireAsyncJobsDueRunnable asyncJobsDueRunnable;
    protected ResetExpiredJobsRunnable resetExpiredJobsRunnable;
    protected ExecuteAsyncRunnableFactory executeAsyncRunnableFactory;
    protected boolean isAutoActivate;
    protected boolean isActive;
    protected boolean isMessageQueueMode;
    protected int maxTimerJobsPerAcquisition = 1;
    protected int maxAsyncJobsDuePerAcquisition = 1;
    protected int defaultTimerJobAcquireWaitTimeInMillis = 10000;
    protected int defaultAsyncJobAcquireWaitTimeInMillis = 10000;
    protected int defaultQueueSizeFullWaitTime = 0;
    protected String lockOwner = UUID.randomUUID().toString();
    protected int timerLockTimeInMillis = 300000;
    protected int asyncJobLockTimeInMillis = 300000;
    protected int retryWaitTimeInMillis = 500;
    protected int resetExpiredJobsInterval = 60000;
    protected int resetExpiredJobsPageSize = 3;
    protected LinkedList<Job> temporaryJobQueue = new LinkedList();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Override
    public boolean executeAsyncJob(final Job job) {
        if (this.isMessageQueueMode) {
            return true;
        }
        Runnable runnable = null;
        if (this.isActive) {
            runnable = this.createRunnableForJob(job);
            try {
                this.executorService.execute(runnable);
            }
            catch (RejectedExecutionException e) {
                CommandContext commandContext = Context.getCommandContext();
                if (commandContext != null) {
                    commandContext.getJobManager().unacquire(job);
                } else {
                    this.processEngineConfiguration.getCommandExecutor().execute(new Command<Void>(){

                        @Override
                        public Void execute(CommandContext commandContext) {
                            commandContext.getJobManager().unacquire(job);
                            return null;
                        }
                    });
                }
                return false;
            }
        } else {
            this.temporaryJobQueue.add(job);
        }
        return true;
    }

    protected Runnable createRunnableForJob(Job job) {
        if (this.executeAsyncRunnableFactory == null) {
            return new ExecuteAsyncRunnable(job, this.processEngineConfiguration);
        }
        return this.executeAsyncRunnableFactory.createExecuteAsyncRunnable(job, this.processEngineConfiguration);
    }

    @Override
    public void start() {
        if (this.isActive) {
            return;
        }
        log.info("Starting up the default async job executor [{}].", (Object)this.getClass().getName());
        if (this.timerJobRunnable == null) {
            this.timerJobRunnable = new AcquireTimerJobsRunnable(this, this.processEngineConfiguration.getJobManager());
        }
        if (this.resetExpiredJobsRunnable == null) {
            this.resetExpiredJobsRunnable = new ResetExpiredJobsRunnable(this);
        }
        if (!this.isMessageQueueMode && this.asyncJobsDueRunnable == null) {
            this.asyncJobsDueRunnable = new AcquireAsyncJobsDueRunnable(this);
        }
        if (!this.isMessageQueueMode) {
            this.initAsyncJobExecutionThreadPool();
            this.startJobAcquisitionThread();
        }
        this.startTimerAcquisitionThread();
        this.startResetExpiredJobsThread();
        this.isActive = true;
        while (!this.temporaryJobQueue.isEmpty()) {
            Job job = this.temporaryJobQueue.pop();
            this.executeAsyncJob(job);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isActive) {
            return;
        }
        log.info("Shutting down the default async job executor [{}].", (Object)this.getClass().getName());
        if (this.timerJobRunnable != null) {
            this.timerJobRunnable.stop();
        }
        if (this.asyncJobsDueRunnable != null) {
            this.asyncJobsDueRunnable.stop();
        }
        if (this.resetExpiredJobsRunnable != null) {
            this.resetExpiredJobsRunnable.stop();
        }
        this.stopResetExpiredJobsThread();
        this.stopTimerAcquisitionThread();
        this.stopJobAcquisitionThread();
        this.stopExecutingAsyncJobs();
        this.timerJobRunnable = null;
        this.asyncJobsDueRunnable = null;
        this.resetExpiredJobsRunnable = null;
        this.isActive = false;
    }

    protected void initAsyncJobExecutionThreadPool() {
        if (this.threadPoolQueue == null) {
            log.info("Creating thread pool queue of size {}", (Object)this.queueSize);
            this.threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
        }
        if (this.executorService == null) {
            log.info("Creating executor service with corePoolSize {}, maxPoolSize {} and keepAliveTime {}", new Object[]{this.corePoolSize, this.maxPoolSize, this.keepAliveTime});
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("activiti-async-job-executor-thread-%d").build();
            this.executorService = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, this.threadPoolQueue, (ThreadFactory)threadFactory);
        }
    }

    protected void stopExecutingAsyncJobs() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(this.secondsToWaitOnShutdown, TimeUnit.SECONDS)) {
                    log.warn("Timeout during shutdown of async job executor. The current running jobs could not end within " + this.secondsToWaitOnShutdown + " seconds after shutdown operation.");
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while shutting down the async job executor. ", (Throwable)e);
            }
            this.executorService = null;
        }
    }

    protected void startJobAcquisitionThread() {
        if (this.asyncJobAcquisitionThread == null) {
            this.asyncJobAcquisitionThread = new Thread(this.asyncJobsDueRunnable);
        }
        this.asyncJobAcquisitionThread.start();
    }

    protected void startTimerAcquisitionThread() {
        if (this.timerJobAcquisitionThread == null) {
            this.timerJobAcquisitionThread = new Thread(this.timerJobRunnable);
        }
        this.timerJobAcquisitionThread.start();
    }

    protected void stopJobAcquisitionThread() {
        if (this.asyncJobAcquisitionThread != null) {
            try {
                this.asyncJobAcquisitionThread.join();
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for the async job acquisition thread to terminate", (Throwable)e);
            }
            this.asyncJobAcquisitionThread = null;
        }
    }

    protected void stopTimerAcquisitionThread() {
        if (this.timerJobAcquisitionThread != null) {
            try {
                this.timerJobAcquisitionThread.join();
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for the timer job acquisition thread to terminate", (Throwable)e);
            }
            this.timerJobAcquisitionThread = null;
        }
    }

    protected void startResetExpiredJobsThread() {
        if (this.resetExpiredJobThread == null) {
            this.resetExpiredJobThread = new Thread(this.resetExpiredJobsRunnable);
        }
        this.resetExpiredJobThread.start();
    }

    protected void stopResetExpiredJobsThread() {
        if (this.resetExpiredJobThread != null) {
            try {
                this.resetExpiredJobThread.join();
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for the reset expired jobs thread to terminate", (Throwable)e);
            }
            this.resetExpiredJobThread = null;
        }
    }

    @Override
    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    @Override
    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public Thread getTimerJobAcquisitionThread() {
        return this.timerJobAcquisitionThread;
    }

    public void setTimerJobAcquisitionThread(Thread timerJobAcquisitionThread) {
        this.timerJobAcquisitionThread = timerJobAcquisitionThread;
    }

    public Thread getAsyncJobAcquisitionThread() {
        return this.asyncJobAcquisitionThread;
    }

    public void setAsyncJobAcquisitionThread(Thread asyncJobAcquisitionThread) {
        this.asyncJobAcquisitionThread = asyncJobAcquisitionThread;
    }

    public Thread getResetExpiredJobThread() {
        return this.resetExpiredJobThread;
    }

    public void setResetExpiredJobThread(Thread resetExpiredJobThread) {
        this.resetExpiredJobThread = resetExpiredJobThread;
    }

    @Override
    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    @Override
    public void setAutoActivate(boolean isAutoActivate) {
        this.isAutoActivate = isAutoActivate;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isMessageQueueMode() {
        return this.isMessageQueueMode;
    }

    public void setMessageQueueMode(boolean isMessageQueueMode) {
        this.isMessageQueueMode = isMessageQueueMode;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public long getSecondsToWaitOnShutdown() {
        return this.secondsToWaitOnShutdown;
    }

    public void setSecondsToWaitOnShutdown(long secondsToWaitOnShutdown) {
        this.secondsToWaitOnShutdown = secondsToWaitOnShutdown;
    }

    public BlockingQueue<Runnable> getThreadPoolQueue() {
        return this.threadPoolQueue;
    }

    public void setThreadPoolQueue(BlockingQueue<Runnable> threadPoolQueue) {
        this.threadPoolQueue = threadPoolQueue;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    @Override
    public int getTimerLockTimeInMillis() {
        return this.timerLockTimeInMillis;
    }

    @Override
    public void setTimerLockTimeInMillis(int timerLockTimeInMillis) {
        this.timerLockTimeInMillis = timerLockTimeInMillis;
    }

    @Override
    public int getAsyncJobLockTimeInMillis() {
        return this.asyncJobLockTimeInMillis;
    }

    @Override
    public void setAsyncJobLockTimeInMillis(int asyncJobLockTimeInMillis) {
        this.asyncJobLockTimeInMillis = asyncJobLockTimeInMillis;
    }

    @Override
    public int getMaxTimerJobsPerAcquisition() {
        return this.maxTimerJobsPerAcquisition;
    }

    @Override
    public void setMaxTimerJobsPerAcquisition(int maxTimerJobsPerAcquisition) {
        this.maxTimerJobsPerAcquisition = maxTimerJobsPerAcquisition;
    }

    @Override
    public int getMaxAsyncJobsDuePerAcquisition() {
        return this.maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public void setMaxAsyncJobsDuePerAcquisition(int maxAsyncJobsDuePerAcquisition) {
        this.maxAsyncJobsDuePerAcquisition = maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public int getDefaultTimerJobAcquireWaitTimeInMillis() {
        return this.defaultTimerJobAcquireWaitTimeInMillis;
    }

    @Override
    public void setDefaultTimerJobAcquireWaitTimeInMillis(int defaultTimerJobAcquireWaitTimeInMillis) {
        this.defaultTimerJobAcquireWaitTimeInMillis = defaultTimerJobAcquireWaitTimeInMillis;
    }

    @Override
    public int getDefaultAsyncJobAcquireWaitTimeInMillis() {
        return this.defaultAsyncJobAcquireWaitTimeInMillis;
    }

    @Override
    public void setDefaultAsyncJobAcquireWaitTimeInMillis(int defaultAsyncJobAcquireWaitTimeInMillis) {
        this.defaultAsyncJobAcquireWaitTimeInMillis = defaultAsyncJobAcquireWaitTimeInMillis;
    }

    public void setTimerJobRunnable(AcquireTimerJobsRunnable timerJobRunnable) {
        this.timerJobRunnable = timerJobRunnable;
    }

    @Override
    public int getDefaultQueueSizeFullWaitTimeInMillis() {
        return this.defaultQueueSizeFullWaitTime;
    }

    @Override
    public void setDefaultQueueSizeFullWaitTimeInMillis(int defaultQueueSizeFullWaitTime) {
        this.defaultQueueSizeFullWaitTime = defaultQueueSizeFullWaitTime;
    }

    public void setAsyncJobsDueRunnable(AcquireAsyncJobsDueRunnable asyncJobsDueRunnable) {
        this.asyncJobsDueRunnable = asyncJobsDueRunnable;
    }

    public void setResetExpiredJobsRunnable(ResetExpiredJobsRunnable resetExpiredJobsRunnable) {
        this.resetExpiredJobsRunnable = resetExpiredJobsRunnable;
    }

    @Override
    public int getRetryWaitTimeInMillis() {
        return this.retryWaitTimeInMillis;
    }

    @Override
    public void setRetryWaitTimeInMillis(int retryWaitTimeInMillis) {
        this.retryWaitTimeInMillis = retryWaitTimeInMillis;
    }

    @Override
    public int getResetExpiredJobsInterval() {
        return this.resetExpiredJobsInterval;
    }

    @Override
    public void setResetExpiredJobsInterval(int resetExpiredJobsInterval) {
        this.resetExpiredJobsInterval = resetExpiredJobsInterval;
    }

    @Override
    public int getResetExpiredJobsPageSize() {
        return this.resetExpiredJobsPageSize;
    }

    @Override
    public void setResetExpiredJobsPageSize(int resetExpiredJobsPageSize) {
        this.resetExpiredJobsPageSize = resetExpiredJobsPageSize;
    }

    public ExecuteAsyncRunnableFactory getExecuteAsyncRunnableFactory() {
        return this.executeAsyncRunnableFactory;
    }

    public void setExecuteAsyncRunnableFactory(ExecuteAsyncRunnableFactory executeAsyncRunnableFactory) {
        this.executeAsyncRunnableFactory = executeAsyncRunnableFactory;
    }
}

