/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.Transaction;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.agenda.AbstractOperation;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.SubProcessActivityBehavior;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.CollectionUtil;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndExecutionOperation
extends AbstractOperation {
    private static final Logger logger = LoggerFactory.getLogger(EndExecutionOperation.class);

    public EndExecutionOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    @Override
    public void run() {
        if (this.execution.isProcessInstanceType()) {
            this.handleProcessInstanceExecution(this.execution);
        } else {
            this.handleRegularExecution();
        }
    }

    protected void handleProcessInstanceExecution(ExecutionEntity processInstanceExecution) {
        int activeExecutions;
        ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
        String processInstanceId = processInstanceExecution.getId();
        logger.debug("No parent execution found. Verifying if process instance {} can be stopped.", (Object)processInstanceId);
        ExecutionEntity superExecution = processInstanceExecution.getSuperExecution();
        SubProcessActivityBehavior subProcessActivityBehavior = null;
        if (superExecution != null) {
            FlowNode superExecutionElement = (FlowNode)superExecution.getCurrentFlowElement();
            subProcessActivityBehavior = (SubProcessActivityBehavior)superExecutionElement.getBehavior();
            try {
                subProcessActivityBehavior.completing(superExecution, processInstanceExecution);
            }
            catch (RuntimeException e) {
                logger.error("Error while completing sub process of execution {}", (Object)processInstanceExecution, (Object)e);
                throw e;
            }
            catch (Exception e) {
                logger.error("Error while completing sub process of execution {}", (Object)processInstanceExecution, (Object)e);
                throw new ActivitiException("Error while completing sub process of execution " + processInstanceExecution, e);
            }
        }
        if ((activeExecutions = this.getNumberOfActiveChildExecutionsForProcessInstance(executionEntityManager, processInstanceId)) == 0) {
            logger.debug("No active executions found. Ending process instance {} ", (Object)processInstanceId);
            executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceId, this.execution.getCurrentFlowElement() != null ? this.execution.getCurrentFlowElement().getId() : null, null, false, false, true);
        } else {
            logger.debug("Active executions found. Process instance {} will not be ended.", (Object)processInstanceId);
        }
        Process process = ProcessDefinitionUtil.getProcess(processInstanceExecution.getProcessDefinitionId());
        if (CollectionUtil.isNotEmpty(process.getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)process, processInstanceExecution, "end");
        }
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
            try {
                subProcessActivityBehavior.completed(superExecution);
            }
            catch (RuntimeException e) {
                logger.error("Error while completing sub process of execution {}", (Object)processInstanceExecution, (Object)e);
                throw e;
            }
            catch (Exception e) {
                logger.error("Error while completing sub process of execution {}", (Object)processInstanceExecution, (Object)e);
                throw new ActivitiException("Error while completing sub process of execution " + processInstanceExecution, e);
            }
        }
    }

    protected void handleRegularExecution() {
        ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
        ExecutionEntity parentExecution = (ExecutionEntity)executionEntityManager.findById(this.execution.getParentId());
        if (this.execution.isScope()) {
            executionEntityManager.deleteChildExecutions(this.execution, null, false);
        }
        logger.debug("Ending execution {}", (Object)this.execution.getId());
        executionEntityManager.deleteExecutionAndRelatedData(this.execution, null, false);
        logger.debug("Parent execution found. Continuing process using execution {}", (Object)parentExecution.getId());
        if (this.isEndEventInMultiInstanceSubprocess(this.execution)) {
            this.handleMultiInstanceSubProcess(executionEntityManager, parentExecution);
            return;
        }
        SubProcess subProcess = this.execution.getCurrentFlowElement().getSubProcess();
        if (this.getNumberOfActiveChildExecutionsForExecution(executionEntityManager, parentExecution.getId()) == 0 || this.isAllEventScopeExecutions(executionEntityManager, parentExecution)) {
            ExecutionEntity executionToContinue = null;
            if (subProcess != null) {
                if (subProcess.isForCompensation()) {
                    this.agenda.planEndExecutionOperation(parentExecution);
                } else {
                    executionToContinue = this.handleSubProcessEnd(executionEntityManager, parentExecution, subProcess);
                }
            } else {
                executionToContinue = this.handleRegularExecutionEnd(executionEntityManager, parentExecution);
            }
            if (executionToContinue != null) {
                if (executionToContinue.isProcessInstanceType()) {
                    this.handleProcessInstanceExecution(executionToContinue);
                } else {
                    this.agenda.planTakeOutgoingSequenceFlowsOperation(executionToContinue, true);
                }
            }
        }
    }

    protected ExecutionEntity handleSubProcessEnd(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution, SubProcess subProcess) {
        ExecutionEntity executionToContinue = null;
        executionToContinue = executionEntityManager.createChildExecution(parentExecution.getParent());
        executionToContinue.setCurrentFlowElement((FlowElement)subProcess);
        boolean hasCompensation = false;
        if (subProcess instanceof Transaction) {
            hasCompensation = true;
        } else {
            block0: for (FlowElement subElement : subProcess.getFlowElements()) {
                Activity subActivity;
                if (!(subElement instanceof Activity) || !CollectionUtil.isNotEmpty((subActivity = (Activity)subElement).getBoundaryEvents())) continue;
                for (BoundaryEvent boundaryEvent : subActivity.getBoundaryEvents()) {
                    if (!CollectionUtil.isNotEmpty(boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                    hasCompensation = true;
                    continue block0;
                }
            }
        }
        if (hasCompensation) {
            ScopeUtil.createCopyOfSubProcessExecutionForCompensation(parentExecution);
        }
        executionEntityManager.deleteChildExecutions(parentExecution, null, false);
        executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_COMPLETED, subProcess.getId(), subProcess.getName(), parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId(), (FlowElement)subProcess));
        return executionToContinue;
    }

    protected ExecutionEntity handleRegularExecutionEnd(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution) {
        ExecutionEntity executionToContinue = null;
        if (!parentExecution.isProcessInstanceType() && !(parentExecution.getCurrentFlowElement() instanceof SubProcess)) {
            parentExecution.setCurrentFlowElement(this.execution.getCurrentFlowElement());
        }
        if (this.execution.getCurrentFlowElement() instanceof SubProcess) {
            SubProcess currentSubProcess = (SubProcess)this.execution.getCurrentFlowElement();
            if (currentSubProcess.getOutgoingFlows().size() > 0) {
                executionToContinue = executionEntityManager.createChildExecution(parentExecution);
                executionToContinue.setCurrentFlowElement(this.execution.getCurrentFlowElement());
            } else if (!parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                executionToContinue = executionEntityManager.createChildExecution(parentExecution.getParent());
                executionToContinue.setCurrentFlowElement(parentExecution.getCurrentFlowElement());
                executionEntityManager.deleteChildExecutions(parentExecution, null, false);
                executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
            } else {
                executionToContinue = parentExecution;
            }
        } else {
            executionToContinue = parentExecution;
        }
        return executionToContinue;
    }

    protected void handleMultiInstanceSubProcess(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution) {
        List<ExecutionEntity> activeChildExecutions = this.getActiveChildExecutionsForExecution(executionEntityManager, parentExecution.getId());
        boolean containsOtherChildExecutions = false;
        for (ExecutionEntity activeExecution : activeChildExecutions) {
            if (activeExecution.getId().equals(this.execution.getId())) continue;
            containsOtherChildExecutions = true;
        }
        if (!containsOtherChildExecutions) {
            ScopeUtil.createCopyOfSubProcessExecutionForCompensation(parentExecution);
            this.agenda.planDestroyScopeOperation(parentExecution);
            SubProcess subProcess = this.execution.getCurrentFlowElement().getSubProcess();
            MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)subProcess.getBehavior();
            parentExecution.setCurrentFlowElement((FlowElement)subProcess);
            multiInstanceBehavior.leave(parentExecution);
        }
    }

    protected boolean isEndEventInMultiInstanceSubprocess(ExecutionEntity executionEntity) {
        if (executionEntity.getCurrentFlowElement() instanceof EndEvent) {
            SubProcess subProcess = ((EndEvent)this.execution.getCurrentFlowElement()).getSubProcess();
            return !executionEntity.getParent().isProcessInstanceType() && subProcess != null && subProcess.getLoopCharacteristics() != null && subProcess.getBehavior() instanceof MultiInstanceActivityBehavior;
        }
        return false;
    }

    protected int getNumberOfActiveChildExecutionsForProcessInstance(ExecutionEntityManager executionEntityManager, String processInstanceId) {
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceId);
        int activeExecutions = 0;
        for (ExecutionEntity execution : executions) {
            if (!execution.isActive() || processInstanceId.equals(execution.getId())) continue;
            ++activeExecutions;
        }
        return activeExecutions;
    }

    protected int getNumberOfActiveChildExecutionsForExecution(ExecutionEntityManager executionEntityManager, String executionId) {
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(executionId);
        int activeExecutions = 0;
        for (ExecutionEntity activeExecution : executions) {
            if (activeExecution.getCurrentFlowElement() instanceof BoundaryEvent) continue;
            ++activeExecutions;
        }
        return activeExecutions;
    }

    protected List<ExecutionEntity> getActiveChildExecutionsForExecution(ExecutionEntityManager executionEntityManager, String executionId) {
        ArrayList<ExecutionEntity> activeChildExecutions = new ArrayList<ExecutionEntity>();
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(executionId);
        for (ExecutionEntity activeExecution : executions) {
            if (activeExecution.getCurrentFlowElement() instanceof BoundaryEvent) continue;
            activeChildExecutions.add(activeExecution);
        }
        return activeChildExecutions;
    }

    protected boolean isAllEventScopeExecutions(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution) {
        boolean allEventScopeExecutions = true;
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        for (ExecutionEntity childExecution : executions) {
            if (childExecution.isEventScope()) {
                executionEntityManager.deleteExecutionAndRelatedData(childExecution, null, false);
                continue;
            }
            allEventScopeExecutions = false;
            break;
        }
        return allEventScopeExecutions;
    }

    protected boolean allChildExecutionsEnded(ExecutionEntity parentExecutionEntity, ExecutionEntity executionEntityToIgnore) {
        for (ExecutionEntity executionEntity : parentExecutionEntity.getExecutions()) {
            if (executionEntityToIgnore != null && executionEntityToIgnore.getId().equals(executionEntity.getId())) continue;
            if (!executionEntity.isEnded()) {
                return false;
            }
            if (executionEntity.getExecutions() == null || executionEntity.getExecutions().size() <= 0 || this.allChildExecutionsEnded(executionEntity, executionEntityToIgnore)) continue;
            return false;
        }
        return true;
    }
}

