/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import java.util.LinkedList;
import org.activiti.engine.impl.agenda.ContinueMultiInstanceOperation;
import org.activiti.engine.impl.agenda.ContinueProcessOperation;
import org.activiti.engine.impl.agenda.DestroyScopeOperation;
import org.activiti.engine.impl.agenda.EndExecutionOperation;
import org.activiti.engine.impl.agenda.ExecuteInactiveBehaviorsOperation;
import org.activiti.engine.impl.agenda.TakeOutgoingSequenceFlowsOperation;
import org.activiti.engine.impl.agenda.TriggerExecutionOperation;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agenda {
    private static final Logger logger = LoggerFactory.getLogger(Agenda.class);
    protected CommandContext commandContext;
    protected LinkedList<Runnable> operations = new LinkedList();

    public Agenda(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public Runnable getNextOperation() {
        return this.operations.poll();
    }

    public void planOperation(Runnable operation) {
        this.planOperation(operation, null);
    }

    public void planOperation(Runnable operation, ExecutionEntity executionEntity) {
        this.operations.add(operation);
        logger.debug("Operation {} added to agenda", operation.getClass());
        if (executionEntity != null) {
            this.commandContext.addInvolvedExecution(executionEntity);
        }
    }

    public void planContinueProcessOperation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution), execution);
    }

    public void planContinueProcessSynchronousOperation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution, true, false), execution);
    }

    public void planContinueProcessInCompensation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution, false, true), execution);
    }

    public void planContinueMultiInstanceOperation(ExecutionEntity execution) {
        this.planOperation(new ContinueMultiInstanceOperation(this.commandContext, execution), execution);
    }

    public void planTakeOutgoingSequenceFlowsOperation(ExecutionEntity execution, boolean evaluateConditions) {
        this.planOperation(new TakeOutgoingSequenceFlowsOperation(this.commandContext, execution, evaluateConditions), execution);
    }

    public void planEndExecutionOperation(ExecutionEntity execution) {
        this.planOperation(new EndExecutionOperation(this.commandContext, execution), execution);
    }

    public void planTriggerExecutionOperation(ExecutionEntity execution) {
        this.planOperation(new TriggerExecutionOperation(this.commandContext, execution), execution);
    }

    public void planDestroyScopeOperation(ExecutionEntity execution) {
        this.planOperation(new DestroyScopeOperation(this.commandContext, execution), execution);
    }

    public void planExecuteInactiveBehaviorsOperation() {
        this.planOperation(new ExecuteInactiveBehaviorsOperation(this.commandContext));
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public void setCommandContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public LinkedList<Runnable> getOperations() {
        return this.operations;
    }
}

