/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;

public class IntermediateCatchEventParseHandler
extends AbstractActivityBpmnParseHandler<IntermediateCatchEvent> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return IntermediateCatchEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, IntermediateCatchEvent event) {
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        ActivityImpl nestedActivity = null;
        EventDefinition eventDefinition = null;
        if (event.getEventDefinitions().size() > 0) {
            eventDefinition = (EventDefinition)event.getEventDefinitions().get(0);
        }
        if (eventDefinition == null) {
            bpmnModel.addProblem("No event definition for intermediate catch event " + event.getId(), (BaseElement)event);
            nestedActivity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)event, "intermediateCatchEvent");
        } else {
            ScopeImpl scope = bpmnParse.getCurrentScope();
            String eventBasedGatewayId = this.getPrecedingEventBasedGateway(bpmnParse, event);
            if (eventBasedGatewayId != null) {
                ActivityImpl gatewayActivity = scope.findActivity(eventBasedGatewayId);
                nestedActivity = this.createActivityOnScope(bpmnParse, (FlowElement)event, "intermediateCatchEvent", gatewayActivity);
            } else {
                nestedActivity = this.createActivityOnScope(bpmnParse, (FlowElement)event, "intermediateCatchEvent", scope);
            }
            nestedActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createIntermediateCatchEventActivityBehavior(event));
            if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof MessageEventDefinition) {
                bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
            } else {
                bpmnModel.addProblem("Unsupported intermediate catch event type.", (BaseElement)event);
            }
        }
    }
}

