/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import javax.script.ScriptException;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.scripting.ScriptingEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptTaskActivityBehavior.class);
    protected String script;
    protected String language;
    protected String resultVariable;
    protected boolean storeScriptVariables = false;

    public ScriptTaskActivityBehavior(String script, String language, String resultVariable) {
        this.script = script;
        this.language = language;
        this.resultVariable = resultVariable;
    }

    public ScriptTaskActivityBehavior(String script, String language, String resultVariable, boolean storeScriptVariables) {
        this(script, language, resultVariable);
        this.storeScriptVariables = storeScriptVariables;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        boolean noErrors = true;
        try {
            Object result = scriptingEngines.evaluate(this.script, this.language, execution, this.storeScriptVariables);
            if (this.resultVariable != null) {
                execution.setVariable(this.resultVariable, result);
            }
        }
        catch (ActivitiException e) {
            LOGGER.warn("Exception while executing " + execution.getActivity().getId() + " : " + e.getMessage());
            noErrors = false;
            if (e.getCause() instanceof ScriptException && e.getCause().getCause() instanceof ScriptException && e.getCause().getCause().getCause() instanceof BpmnError) {
                ErrorPropagation.propagateError((BpmnError)e.getCause().getCause().getCause(), execution);
            }
            throw e;
        }
        if (noErrors) {
            this.leave(execution);
        }
    }
}

