/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.Task;

public class BpmnAutoLayout {
    private static final String STYLE_EVENT = "styleEvent";
    private static final String STYLE_GATEWAY = "styleGateway";
    private static final String STYLE_SEQUENCEFLOW = "styleSequenceFlow";
    private static final String STYLE_BOUNDARY_SEQUENCEFLOW = "styleBoundarySequenceFlow";
    protected BpmnModel bpmnModel;
    protected int eventSize = 30;
    protected int gatewaySize = 40;
    protected int taskWidth = 100;
    protected int taskHeight = 60;
    protected int subProcessMargin = 20;
    protected mxGraph graph;
    protected Object cellParent;
    protected Map<String, SequenceFlow> sequenceFlows;
    protected List<BoundaryEvent> boundaryEvents;
    protected Map<String, FlowElement> handledFlowElements;
    protected Map<String, Object> generatedVertices;
    protected Map<String, Object> generatedEdges;

    public BpmnAutoLayout(BpmnModel bpmnModel) {
        this.bpmnModel = bpmnModel;
    }

    public void execute() {
        this.bpmnModel.getLocationMap().clear();
        this.bpmnModel.getFlowLocationMap().clear();
        for (Process process : this.bpmnModel.getProcesses()) {
            this.layout((FlowElementsContainer)process);
        }
    }

    protected void layout(FlowElementsContainer flowElementsContainer) {
        this.graph = new mxGraph();
        this.cellParent = this.graph.getDefaultParent();
        this.graph.getModel().beginUpdate();
        this.handledFlowElements = new HashMap<String, FlowElement>();
        this.generatedVertices = new HashMap<String, Object>();
        this.generatedEdges = new HashMap<String, Object>();
        this.sequenceFlows = new HashMap<String, SequenceFlow>();
        this.boundaryEvents = new ArrayList<BoundaryEvent>();
        for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
            if (flowElement instanceof SequenceFlow) {
                this.handleSequenceFlow((SequenceFlow)flowElement);
            } else if (flowElement instanceof Event) {
                this.handleEvent(flowElement);
            } else if (flowElement instanceof Gateway) {
                this.createGatewayVertex(flowElement);
            } else if (flowElement instanceof Task || flowElement instanceof CallActivity) {
                this.handleActivity(flowElement);
            } else if (flowElement instanceof SubProcess) {
                this.handleSubProcess(flowElement);
            }
            this.handledFlowElements.put(flowElement.getId(), flowElement);
        }
        this.handleBoundaryEvents();
        this.handleSequenceFlow();
        CustomLayout layout = new CustomLayout(this.graph, 7);
        layout.setIntraCellSpacing(100.0);
        layout.setResizeParent(true);
        layout.setFineTuning(true);
        layout.setParentBorder(20);
        layout.setMoveParent(true);
        layout.setDisableEdgeStyle(false);
        layout.setUseBoundingBox(true);
        layout.execute(this.graph.getDefaultParent());
        this.graph.getModel().endUpdate();
        this.generateDiagramInterchangeElements();
    }

    protected void ensureSequenceFlowIdSet(SequenceFlow sequenceFlow) {
        if (sequenceFlow.getId() == null) {
            sequenceFlow.setId("sequenceFlow-" + UUID.randomUUID().toString());
        }
    }

    protected void handleSequenceFlow(SequenceFlow sequenceFlow) {
        this.ensureSequenceFlowIdSet(sequenceFlow);
        this.sequenceFlows.put(sequenceFlow.getId(), sequenceFlow);
    }

    protected void handleEvent(FlowElement flowElement) {
        if (flowElement instanceof BoundaryEvent) {
            this.boundaryEvents.add((BoundaryEvent)flowElement);
        } else {
            this.createEventVertex(flowElement);
        }
    }

    protected void handleActivity(FlowElement flowElement) {
        Object activityVertex = this.graph.insertVertex(this.cellParent, flowElement.getId(), (Object)"", 0.0, 0.0, (double)this.taskWidth, (double)this.taskHeight);
        this.generatedVertices.put(flowElement.getId(), activityVertex);
    }

    protected void handleSubProcess(FlowElement flowElement) {
        BpmnAutoLayout bpmnAutoLayout = new BpmnAutoLayout(this.bpmnModel);
        bpmnAutoLayout.layout((FlowElementsContainer)((SubProcess)flowElement));
        double subProcessWidth = bpmnAutoLayout.getGraph().getView().getGraphBounds().getWidth();
        double subProcessHeight = bpmnAutoLayout.getGraph().getView().getGraphBounds().getHeight();
        Object subProcessVertex = this.graph.insertVertex(this.cellParent, flowElement.getId(), (Object)"", 0.0, 0.0, subProcessWidth + (double)(2 * this.subProcessMargin), subProcessHeight + (double)(2 * this.subProcessMargin));
        this.generatedVertices.put(flowElement.getId(), subProcessVertex);
    }

    protected void handleBoundaryEvents() {
        for (BoundaryEvent boundaryEvent : this.boundaryEvents) {
            mxGeometry geometry = new mxGeometry(0.8, 1.0, (double)this.eventSize, (double)this.eventSize);
            geometry.setOffset(new mxPoint((double)(-(this.eventSize / 2)), (double)(-(this.eventSize / 2))));
            geometry.setRelative(true);
            mxCell boundaryPort = new mxCell(null, geometry, "shape=ellipse;perimter=ellipsePerimeter");
            boundaryPort.setId("boundary-event-" + boundaryEvent.getId());
            boundaryPort.setVertex(true);
            Object portParent = null;
            if (boundaryEvent.getAttachedToRefId() != null) {
                portParent = this.generatedVertices.get(boundaryEvent.getAttachedToRefId());
            } else if (boundaryEvent.getAttachedToRef() != null) {
                portParent = this.generatedVertices.get(boundaryEvent.getAttachedToRef().getId());
            } else {
                throw new RuntimeException("Could not generate DI: boundaryEvent '" + boundaryEvent.getId() + "' has no attachedToRef");
            }
            this.graph.addCell((Object)boundaryPort, portParent);
            this.generatedVertices.put(boundaryEvent.getId(), boundaryPort);
        }
    }

    protected void handleSequenceFlow() {
        Hashtable<String, Comparable<Boolean>> edgeStyle = new Hashtable<String, Comparable<Boolean>>();
        edgeStyle.put(mxConstants.STYLE_ORTHOGONAL, Boolean.valueOf(true));
        edgeStyle.put(mxConstants.STYLE_EDGE, (Comparable<Boolean>)mxEdgeStyle.ElbowConnector);
        edgeStyle.put(mxConstants.STYLE_ENTRY_X, Double.valueOf(0.0));
        edgeStyle.put(mxConstants.STYLE_ENTRY_Y, Double.valueOf(0.5));
        this.graph.getStylesheet().putCellStyle(STYLE_SEQUENCEFLOW, edgeStyle);
        Hashtable<String, Double> boundaryEdgeStyle = new Hashtable<String, Double>();
        boundaryEdgeStyle.put(mxConstants.STYLE_EXIT_X, 0.5);
        boundaryEdgeStyle.put(mxConstants.STYLE_EXIT_Y, 1.0);
        boundaryEdgeStyle.put(mxConstants.STYLE_ENTRY_X, 0.5);
        boundaryEdgeStyle.put(mxConstants.STYLE_ENTRY_Y, 1.0);
        boundaryEdgeStyle.put(mxConstants.STYLE_EDGE, (Double)mxEdgeStyle.orthConnector);
        this.graph.getStylesheet().putCellStyle(STYLE_BOUNDARY_SEQUENCEFLOW, boundaryEdgeStyle);
        for (SequenceFlow sequenceFlow : this.sequenceFlows.values()) {
            Object sourceVertex = this.generatedVertices.get(sequenceFlow.getSourceRef());
            Object targertVertex = this.generatedVertices.get(sequenceFlow.getTargetRef());
            String style = null;
            style = this.handledFlowElements.get(sequenceFlow.getSourceRef()) instanceof BoundaryEvent ? STYLE_BOUNDARY_SEQUENCEFLOW : STYLE_SEQUENCEFLOW;
            Object sequenceFlowEdge = this.graph.insertEdge(this.cellParent, sequenceFlow.getId(), (Object)"", sourceVertex, targertVertex, style);
            this.generatedEdges.put(sequenceFlow.getId(), sequenceFlowEdge);
        }
    }

    protected void createEventVertex(FlowElement flowElement) {
        if (!this.graph.getStylesheet().getStyles().containsKey(STYLE_EVENT)) {
            Hashtable<String, String> eventStyle = new Hashtable<String, String>();
            eventStyle.put(mxConstants.STYLE_SHAPE, "ellipse");
            this.graph.getStylesheet().putCellStyle(STYLE_EVENT, eventStyle);
        }
        Object eventVertex = this.graph.insertVertex(this.cellParent, flowElement.getId(), (Object)"", 0.0, 0.0, (double)this.eventSize, (double)this.eventSize, STYLE_EVENT);
        this.generatedVertices.put(flowElement.getId(), eventVertex);
    }

    protected void createGatewayVertex(FlowElement flowElement) {
        if (this.graph.getStylesheet().getStyles().containsKey(STYLE_GATEWAY)) {
            Hashtable<String, String> style = new Hashtable<String, String>();
            style.put(mxConstants.STYLE_SHAPE, "rhombus");
            this.graph.getStylesheet().putCellStyle(STYLE_GATEWAY, style);
        }
        Object gatewayVertex = this.graph.insertVertex(this.cellParent, flowElement.getId(), (Object)"", 0.0, 0.0, (double)this.gatewaySize, (double)this.gatewaySize, STYLE_GATEWAY);
        this.generatedVertices.put(flowElement.getId(), gatewayVertex);
    }

    protected void generateDiagramInterchangeElements() {
        this.generateActivityDiagramInterchangeElements();
        this.generateSequenceFlowDiagramInterchangeElements();
    }

    protected void generateActivityDiagramInterchangeElements() {
        for (String flowElementId : this.generatedVertices.keySet()) {
            Object vertex = this.generatedVertices.get(flowElementId);
            mxCellState cellState = this.graph.getView().getState(vertex);
            GraphicInfo subProcessGraphicInfo = this.createDiagramInterchangeInformation(this.handledFlowElements.get(flowElementId), (int)cellState.getX(), (int)cellState.getY(), (int)cellState.getWidth(), (int)cellState.getHeight());
            if (!(this.handledFlowElements.get(flowElementId) instanceof SubProcess)) continue;
            SubProcess subProcess = (SubProcess)this.handledFlowElements.get(flowElementId);
            subProcessGraphicInfo.setExpanded(Boolean.valueOf(true));
            double subProcessX = cellState.getX();
            double subProcessY = cellState.getY();
            double translationX = subProcessX + (double)this.subProcessMargin;
            double translationY = subProcessY + (double)this.subProcessMargin;
            for (FlowElement subProcessElement : subProcess.getFlowElements()) {
                if (subProcessElement instanceof SequenceFlow) {
                    List graphicInfoList = this.bpmnModel.getFlowLocationGraphicInfo(subProcessElement.getId());
                    for (GraphicInfo graphicInfo : graphicInfoList) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                        graphicInfo.setY(graphicInfo.getY() + translationY);
                    }
                    continue;
                }
                GraphicInfo graphicInfo = (GraphicInfo)this.bpmnModel.getLocationMap().get(subProcessElement.getId());
                graphicInfo.setX(graphicInfo.getX() + translationX);
                graphicInfo.setY(graphicInfo.getY() + translationY);
            }
        }
    }

    protected void generateSequenceFlowDiagramInterchangeElements() {
        for (String sequenceFlowId : this.generatedEdges.keySet()) {
            Object edge = this.generatedEdges.get(sequenceFlowId);
            List points = this.graph.getView().getState(edge).getAbsolutePoints();
            FlowElement sourceElement = this.handledFlowElements.get(this.sequenceFlows.get(sequenceFlowId).getSourceRef());
            if (sourceElement instanceof Gateway && ((Gateway)sourceElement).getOutgoingFlows().size() > 1) {
                mxPoint startPoint = (mxPoint)points.get(0);
                Object gatewayVertex = this.generatedVertices.get(sourceElement.getId());
                mxCellState gatewayState = this.graph.getView().getState(gatewayVertex);
                mxPoint northPoint = new mxPoint(gatewayState.getX() + gatewayState.getWidth() / 2.0, gatewayState.getY());
                mxPoint southPoint = new mxPoint(gatewayState.getX() + gatewayState.getWidth() / 2.0, gatewayState.getY() + gatewayState.getHeight());
                mxPoint eastPoint = new mxPoint(gatewayState.getX() + gatewayState.getWidth(), gatewayState.getY() + gatewayState.getHeight() / 2.0);
                mxPoint westPoint = new mxPoint(gatewayState.getX(), gatewayState.getY() + gatewayState.getHeight() / 2.0);
                double closestDistance = Double.MAX_VALUE;
                mxPoint closestPoint = null;
                for (mxPoint rhombusPoint : Arrays.asList(northPoint, southPoint, eastPoint, westPoint)) {
                    double distance = this.euclidianDistance(startPoint, rhombusPoint);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closestPoint = rhombusPoint;
                }
                startPoint.setX(closestPoint.getX());
                startPoint.setY(closestPoint.getY());
                if (points.size() > 1) {
                    mxPoint nextPoint = (mxPoint)points.get(1);
                    nextPoint.setY(closestPoint.getY());
                }
            }
            this.createDiagramInterchangeInformation((SequenceFlow)this.handledFlowElements.get(sequenceFlowId), this.optimizeEdgePoints(points));
        }
    }

    protected double euclidianDistance(mxPoint point1, mxPoint point2) {
        return Math.sqrt((point2.getX() - point1.getX()) * (point2.getX() - point1.getX()) + (point2.getY() - point1.getY()) * (point2.getY() - point1.getY()));
    }

    protected List<mxPoint> optimizeEdgePoints(List<mxPoint> unoptimizedPointsList) {
        ArrayList<mxPoint> optimizedPointsList = new ArrayList<mxPoint>();
        for (int i = 0; i < unoptimizedPointsList.size(); ++i) {
            boolean keepPoint = true;
            mxPoint currentPoint = unoptimizedPointsList.get(i);
            if (i > 0 && i != unoptimizedPointsList.size() - 1) {
                mxPoint previousPoint = unoptimizedPointsList.get(i - 1);
                mxPoint nextPoint = unoptimizedPointsList.get(i + 1);
                if (currentPoint.getX() >= previousPoint.getX() && currentPoint.getX() <= nextPoint.getX() && currentPoint.getY() == previousPoint.getY() && currentPoint.getY() == nextPoint.getY()) {
                    keepPoint = false;
                } else if (currentPoint.getY() >= previousPoint.getY() && currentPoint.getY() <= nextPoint.getY() && currentPoint.getX() == previousPoint.getX() && currentPoint.getX() == nextPoint.getX()) {
                    keepPoint = false;
                }
            }
            if (!keepPoint) continue;
            optimizedPointsList.add(currentPoint);
        }
        return optimizedPointsList;
    }

    protected GraphicInfo createDiagramInterchangeInformation(FlowElement flowElement, int x, int y, int width, int height) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX((double)x);
        graphicInfo.setY((double)y);
        graphicInfo.setWidth((double)width);
        graphicInfo.setHeight((double)height);
        graphicInfo.setElement(flowElement);
        this.bpmnModel.addGraphicInfo(flowElement.getId(), graphicInfo);
        return graphicInfo;
    }

    protected void createDiagramInterchangeInformation(SequenceFlow sequenceFlow, List<mxPoint> waypoints) {
        ArrayList<GraphicInfo> graphicInfoForWaypoints = new ArrayList<GraphicInfo>();
        for (mxPoint waypoint : waypoints) {
            GraphicInfo graphicInfo = new GraphicInfo();
            graphicInfo.setElement((FlowElement)sequenceFlow);
            graphicInfo.setX(waypoint.getX());
            graphicInfo.setY(waypoint.getY());
            graphicInfoForWaypoints.add(graphicInfo);
        }
        this.bpmnModel.addFlowGraphicInfoList(sequenceFlow.getId(), graphicInfoForWaypoints);
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    public void setGraph(mxGraph graph) {
        this.graph = graph;
    }

    public int getEventSize() {
        return this.eventSize;
    }

    public void setEventSize(int eventSize) {
        this.eventSize = eventSize;
    }

    public int getGatewaySize() {
        return this.gatewaySize;
    }

    public void setGatewaySize(int gatewaySize) {
        this.gatewaySize = gatewaySize;
    }

    public int getTaskWidth() {
        return this.taskWidth;
    }

    public void setTaskWidth(int taskWidth) {
        this.taskWidth = taskWidth;
    }

    public int getTaskHeight() {
        return this.taskHeight;
    }

    public void setTaskHeight(int taskHeight) {
        this.taskHeight = taskHeight;
    }

    public int getSubProcessMargin() {
        return this.subProcessMargin;
    }

    public void setSubProcessMargin(int subProcessMargin) {
        this.subProcessMargin = subProcessMargin;
    }

    static class CustomLayout
    extends mxHierarchicalLayout {
        public CustomLayout(mxGraph graph, int orientation) {
            super(graph, orientation);
            this.traverseAncestors = false;
        }
    }
}

